/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.MethodPropertiesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ZeroArgConstructorPreference;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class MethodsPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel mwClassHolder;
    PropertyValueModel methodSelectionHolder;
    private MethodPropertiesPanel methodPropertiesPanel;
    private AddRemoveListPanel methodListPanel;

    MethodsPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.mwClassHolder = this.buildMWClassHolder();
        this.methodSelectionHolder = new SimplePropertyValueModel();
    }

    private PropertyValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.classInfo.methods";
    }

    private CollectionValueModel buildMethodsHolder() {
        return new CollectionAspectAdapter(this.mwClassHolder, "methods"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).methods();
            }

            protected int sizeFromSubject() {
                return ((MWClass)this.subject).methodsSize();
            }
        };
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        this.methodListPanel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAddRemoveListPanelAdapter(), this.buildMethodsListModel(), this.resourceRepository().getString("METHODS_LIST"));
        this.methodListPanel.setBorder(this.buildStandardEmptyBorder());
        this.methodListPanel.setCellRenderer(new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        this.methodListPanel.addListSelectionListener(this.buildListSelectionListener(this.methodListPanel));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        jPanel.add((Component)this.methodListPanel, gridBagConstraints);
        this.methodPropertiesPanel = new MethodPropertiesPanel(this.methodSelectionHolder, this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.methodPropertiesPanel, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private ListSelectionListener buildListSelectionListener(final AddRemoveListPanel addRemoveListPanel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (addRemoveListPanel.getSelectedValues().length > 1) {
                    MethodsPropertiesPage.this.methodSelectionHolder.setValue(null);
                } else {
                    MethodsPropertiesPage.this.methodSelectionHolder.setValue(addRemoveListPanel.getSelectedValue());
                }
            }
        };
    }

    private ListValueModel buildMethodsListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedMethodsListValueModelAdapter(), "modifierAccessLevel", "signature");
    }

    private SortedListValueModelAdapter buildSortedMethodsListValueModelAdapter() {
        return new SortedListValueModelAdapter(this.buildMethodNameAdapter());
    }

    private ItemPropertyListValueModelAdapter buildMethodNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildMethodsHolder(), "name");
    }

    private AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                MethodsPropertiesPage.this.addNewMethod(objectListSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                MethodsPropertiesPage.this.removeMethods(CollectionTools.iterator((Object[])objectListSelectionModel.getSelectedValues()));
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                MethodsPropertiesPage.this.renameMethod(objectListSelectionModel);
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    void addNewMethod(ObjectListSelectionModel objectListSelectionModel) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTextFieldDescription(this.resourceRepository().getString("enterTheNameOfTheNewMethod.message"));
        builder.setTitle(this.resourceRepository().getString("addNewMethod.title"));
        builder.setHelpTopicId("dialog.newMethod");
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            public Document buildDocument() {
                return new RegexpDocument(5);
            }
        });
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        MWMethod mWMethod = this.getMWClass().addMethod(newNameDialog.getNewName());
        objectListSelectionModel.setSelectedValue(mWMethod);
    }

    void removeMethods(Iterator iterator) {
        while (iterator.hasNext()) {
            this.getMWClass().removeMethod((MWMethod)iterator.next());
        }
    }

    void renameMethod(ObjectListSelectionModel objectListSelectionModel) {
        MWMethod mWMethod = (MWMethod)objectListSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTextFieldDescription(this.resourceRepository().getString("EDIT_METHOD_DIALOG_MESSAGE"));
        builder.setTitle(this.resourceRepository().getString("EDIT_METHOD_DIALOG_TITLE"));
        builder.setHelpTopicId("dialog.newMethod");
        builder.setOriginalName(mWMethod.getName());
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            public Document buildDocument() {
                return new RegexpDocument(5);
            }
        });
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        String string = newNameDialog.getNewName();
        if (mWMethod.isZeroArgumentConstructor()) {
            mWMethod.setName(string);
            ZeroArgConstructorPreference.optionallyAddZeroArgumentConstructor(this.getMWClass(), this.getWorkbenchContext());
        } else {
            mWMethod.setName(string);
        }
        objectListSelectionModel.setSelectedValue(mWMethod);
    }

    private MWClass getMWClass() {
        return (MWClass)this.mwClassHolder.getValue();
    }

    void selectMethod(MWMethod mWMethod) {
        this.methodListPanel.setSelectedValue(mWMethod, true);
    }
}

