/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class TableDescriptorSequencingPanel
extends AbstractPanel {
    private PropertyValueModel relationalDescriptorHolder;
    private PropertyValueModel useSequencingHolder;
    private PropertyValueModel sequenceTableHolder;

    TableDescriptorSequencingPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.relationalDescriptorHolder = propertyValueModel;
        this.useSequencingHolder = this.buildUseSequencingHolder();
        this.sequenceTableHolder = this.buildSequenceTableHolder();
        this.initializeLayout();
    }

    private PropertyValueModel buildUseSequencingHolder() {
        return new PropertyAspectAdapter(this.relationalDescriptorHolder, "usesSequencing"){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).usesSequencing();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTableDescriptor)this.subject).setUsesSequencing(((Boolean)object).booleanValue());
            }
        };
    }

    private PropertyValueModel buildSequenceTableHolder() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.relationalDescriptorHolder, "sequenceNumberTable"){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getSequenceNumberTable();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTableDescriptor)this.subject).setSequenceNumberTable((MWTable)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "qualifiedName");
    }

    private void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GroupBox groupBox = new GroupBox(this.buildUseSequencingCheckBox(), (JComponent)this.buildSequencingPanel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)groupBox, gridBagConstraints);
    }

    protected JPanel buildSequencingPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Vector<JComponent> vector = new Vector<JComponent>();
        Pane pane = new Pane(new GridBagLayout());
        JComponent jComponent = this.buildLabeledTextField("name", this.buildSequencingNameTextFieldDocument(this.buildSequencingNameHolder()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jComponent, gridBagConstraints);
        vector.add(jComponent);
        JComponent jComponent2 = this.buildLabeledComponent("table", this.buildSequenceTableListChooser());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)jComponent2, gridBagConstraints);
        vector.add(jComponent2);
        JComponent jComponent3 = this.buildLabeledComponent("field*", this.buildSequenceColumnListChooser());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pane.add((Component)jComponent3, gridBagConstraints);
        vector.add(jComponent3);
        new ComponentEnabler((ValueModel)this.useSequencingHolder, vector);
        return pane;
    }

    private JCheckBox buildUseSequencingCheckBox() {
        return this.buildCheckBox("useSequencing", new CheckBoxModelAdapter(this.useSequencingHolder));
    }

    private PropertyValueModel buildSequencingNameHolder() {
        return new PropertyAspectAdapter(this.relationalDescriptorHolder, "sequenceNumberName"){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getSequenceNumberName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTableDescriptor)this.subject).setSequenceNumberName((String)object);
            }
        };
    }

    private Document buildSequencingNameTextFieldDocument(PropertyValueModel propertyValueModel) {
        return new DocumentAdapter(propertyValueModel);
    }

    private ListChooser buildSequenceTableListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildTableComboBoxModel(), this.getWorkbenchContextHolder(), RelationalProjectComponentFactory.buildTableNodeSelector(this.getWorkbenchContextHolder()), this.buildSequenceTableChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildTableListRenderer());
        return defaultListChooser;
    }

    private CachingComboBoxModel buildTableComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.sequenceTableHolder, this.relationalDescriptorHolder){

            protected ListIterator listValueFromSubject(Object object) {
                return TableDescriptorSequencingPanel.this.orderedTableChoices((MWRelationalDescriptor)object);
            }
        });
    }

    ListIterator orderedTableChoices(MWRelationalDescriptor mWRelationalDescriptor) {
        return CollectionTools.sort((Iterator)mWRelationalDescriptor.associatedTables(), (Comparator)this.buildTableComparator()).listIterator();
    }

    private Comparator buildTableComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((MWTable)object).getName().compareTo(((MWTable)object2).getName());
            }
        };
    }

    private DefaultListChooserDialog.Builder buildSequenceTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableStringConverter());
        return builder;
    }

    private StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWTable)object).getName();
            }
        };
    }

    private ListCellRenderer buildTableListRenderer() {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(this.resourceRepository()));
    }

    private ListChooser buildSequenceColumnListChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildExtendedSequenceColumnComboBoxModel(), this.getWorkbenchContextHolder(), RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder()), this.buildSequenceColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(this.buildColumnListRenderer());
        return defaultListChooser;
    }

    private ComboBoxModel buildExtendedSequenceColumnComboBoxModel() {
        return new ExtendedComboBoxModel(this.buildSequenceColumnComboBoxModel());
    }

    private ComboBoxModel buildSequenceColumnComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildSortedColumnsListHolder(), this.buildSequenceColumnAdapter());
    }

    private ListValueModel buildSortedColumnsListHolder() {
        return new SortedListValueModelAdapter(this.buildUpdatingColumnsListHolder(), this.buildColumnComparator());
    }

    private ListValueModel buildUpdatingColumnsListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildColumnsAdapter(), "name");
    }

    private CollectionValueModel buildColumnsAdapter() {
        return new CollectionAspectAdapter(this.sequenceTableHolder, "columns"){

            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private Comparator buildColumnComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((MWColumn)object).getName().compareTo(((MWColumn)object2).getName());
            }
        };
    }

    private PropertyValueModel buildSequenceColumnAdapter() {
        PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter(this.relationalDescriptorHolder, "sequenceNumberColumn"){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getSequenceNumberColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTableDescriptor)this.subject).setSequenceNumberColumn((MWColumn)object);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter(propertyAspectAdapter, "qualifiedName", "databaseType");
    }

    private DefaultListChooserDialog.Builder buildSequenceColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildColumnStringConverter());
        return builder;
    }

    private StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object object) {
                return object == null ? "" : ((MWColumn)object).getName();
            }
        };
    }

    private ListCellRenderer buildColumnListRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository(), false));
    }
}

