/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.MethodCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.Model;

public final class ContainerPolicyPanel
extends AbstractSubjectPanel {
    private PropertyValueModel containerPolicyHolder;
    PropertyValueModel containerTypeHolder;
    private PropertyValueModel defaultingContainerClassHolder;
    private PropertyValueModel mapContainerPolicyHolder;
    private JCheckBox useSortingCheckBox;
    private static final String CONTAINER_TYPE_COLLECTION = "collection";
    private static final String CONTAINER_TYPE_LIST = "list";
    private static final String CONTAINER_TYPE_MAP = "map";
    private static final String CONTAINER_TYPE_SET = "set";

    public ContainerPolicyPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initialize(ValueModel valueModel) {
        super.initialize(valueModel);
        this.containerTypeHolder = this.buildContainerTypeHolder();
        this.containerPolicyHolder = this.buildContainerPolicyHolder();
        this.mapContainerPolicyHolder = this.buildMapContainerPolicyHolder(this.containerPolicyHolder);
        this.defaultingContainerClassHolder = this.buildDefaultingContainerClassHolder(this.containerPolicyHolder);
    }

    private PropertyValueModel buildContainerTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerPolicy"){

            protected Object getValueFromSubject() {
                MWContainerPolicy mWContainerPolicy = ((MWContainerMapping)this.subject).getContainerPolicy();
                if (mWContainerPolicy instanceof MWCollectionContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_COLLECTION;
                }
                if (mWContainerPolicy instanceof MWListContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_LIST;
                }
                if (mWContainerPolicy instanceof MWSetContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_SET;
                }
                if (mWContainerPolicy instanceof MWMapContainerPolicy) {
                    return ContainerPolicyPanel.CONTAINER_TYPE_MAP;
                }
                return null;
            }

            protected void setValueOnSubject(Object object) {
                if (object == ContainerPolicyPanel.CONTAINER_TYPE_COLLECTION) {
                    ((MWContainerMapping)this.subject).setCollectionContainerPolicy();
                } else if (object == ContainerPolicyPanel.CONTAINER_TYPE_LIST) {
                    ((MWContainerMapping)this.subject).setListContainerPolicy();
                } else if (object == ContainerPolicyPanel.CONTAINER_TYPE_SET) {
                    ((MWContainerMapping)this.subject).setSetContainerPolicy();
                } else if (object == ContainerPolicyPanel.CONTAINER_TYPE_MAP) {
                    ((MWMapContainerMapping)this.subject).setMapContainerPolicy();
                }
            }
        };
    }

    private PropertyValueModel buildContainerPolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerPolicy"){

            protected Object getValueFromSubject() {
                return ((MWContainerMapping)this.subject).getContainerPolicy();
            }
        };
    }

    private PropertyValueModel buildMapContainerPolicyHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWMapContainerPolicy;
            }
        };
    }

    private PropertyValueModel buildDefaultingContainerClassHolder(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter(propertyValueModel){

            protected Object getValueFromSubject() {
                return ((MWContainerPolicy)this.subject).getDefaultingContainerClass();
            }
        };
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        Insets insets = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        insets.left += 5;
        insets.right += 5;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("CONTAINER_POLICY_GROUP_BOX"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4, 20, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        Spacer spacer = new Spacer();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)spacer, gridBagConstraints);
        JRadioButton jRadioButton = this.buildListContainerTypeRadioButton();
        jPanel2.add(jRadioButton);
        buttonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = this.buildSetContainerTypeRadioButton();
        jPanel2.add(jRadioButton2);
        buttonGroup.add(jRadioButton2);
        JRadioButton jRadioButton3 = this.buildCollectionContainerTypeRadioButton();
        jPanel2.add(jRadioButton3);
        buttonGroup.add(jRadioButton3);
        JRadioButton jRadioButton4 = this.buildMapContainerTypeRadioButton();
        jPanel2.add(jRadioButton4);
        buttonGroup.add(jRadioButton4);
        JCheckBox jCheckBox = this.buildOverrideDefaultContainerClassCheckBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, insets.left, 0, 0);
        this.add((Component)jCheckBox, gridBagConstraints);
        this.addAlignLeft(jCheckBox);
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.buildContainerClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), new JLabel(jCheckBox.getText()), this.getWorkbenchContextHolder());
        classChooserPanel.setEnabled(jCheckBox.isSelected());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 5, 0, insets.right);
        this.add((Component)classChooserPanel, gridBagConstraints);
        this.addPaneForAlignment(classChooserPanel);
        jCheckBox.addItemListener(this.buildContainerClassChooserEnabler(classChooserPanel));
        JComponent jComponent = this.buildLabeledComponent("CONTAINER_POLICY_KEY_METHOD_CHOOSER", this.buildKeyMethodChooser());
        jComponent.setEnabled(jRadioButton4.isSelected());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, insets.left, 0, insets.right);
        this.add((Component)jComponent, gridBagConstraints);
        jRadioButton4.addItemListener(this.buildKeyMethodWidgetsEnabler(jComponent));
        this.useSortingCheckBox = this.buildUseSortingCheckBox();
        this.useSortingCheckBox.setEnabled(jRadioButton2.isSelected());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, insets.left, 0, 0);
        this.add((Component)this.useSortingCheckBox, gridBagConstraints);
        this.addAlignLeft(this.useSortingCheckBox);
        jRadioButton2.addItemListener(this.buildUseSortingCheckboxEnabler(this.useSortingCheckBox));
        ClassChooserPanel classChooserPanel2 = ClassChooserTools.buildPanel(this.buildComparatorClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), new JLabel(this.useSortingCheckBox.getText()), this.getWorkbenchContextHolder());
        classChooserPanel2.setEnabled(this.useSortingCheckBox.isSelected());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 5, 0, insets.right);
        this.add((Component)classChooserPanel2, gridBagConstraints);
        this.addPaneForAlignment(classChooserPanel2);
        jRadioButton2.addItemListener(this.buildComparatorClassChooserSetEnabler(classChooserPanel2));
        this.useSortingCheckBox.addItemListener(this.buildComparatorClassChooserSortingEnabler(classChooserPanel2));
    }

    private JRadioButton buildCollectionContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_COLLECTION_CLASS_RADIO_BUTTON", this.buildCollectionContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildCollectionContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_COLLECTION);
    }

    private JRadioButton buildListContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_LIST_CLASS_RADIO_BUTTON", this.buildListContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildListContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_LIST);
    }

    private JRadioButton buildMapContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_MAP_CLASS_RADIO_BUTTON", this.buildMapContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildMapContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_MAP);
    }

    private JRadioButton buildSetContainerTypeRadioButton() {
        return this.buildRadioButton("CONTAINER_POLICY_SET_CLASS_RADIO_BUTTON", this.buildSetContainerTypeRadioButtonAdapter());
    }

    private ButtonModel buildSetContainerTypeRadioButtonAdapter() {
        return new RadioButtonModelAdapter(this.containerTypeHolder, CONTAINER_TYPE_SET);
    }

    private PropertyValueModel buildContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "containerClass", "usesDefaultContainerClass"){

            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).getContainerClass();
            }

            protected void setValueOnSubject(Object object) {
                ((DefaultingContainerClass)this.subject).setContainerClass((MWClass)object);
            }
        };
    }

    private PropertyValueModel buildComparatorClassHolder() {
        return new PropertyAspectAdapter(this.containerPolicyHolder, "comparatorClass", "sort"){

            protected Object getValueFromSubject() {
                return ((MWContainerPolicy)this.subject).getComparatorClass();
            }

            protected void setValueOnSubject(Object object) {
                ((MWContainerPolicy)this.subject).setComparatorClass((MWClass)object);
            }
        };
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return ((MWModel)ContainerPolicyPanel.this.subject()).getRepository();
            }
        };
    }

    private ItemListener buildContainerClassChooserEnabler(final ClassChooserPanel classChooserPanel) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                classChooserPanel.setEnabled(itemEvent.getStateChange() == 1);
            }
        };
    }

    private JCheckBox buildOverrideDefaultContainerClassCheckBox() {
        return this.buildCheckBox("CONTAINER_POLICY_OVERRIDE_DEFAULT_CLASS_CHECK_BOX", this.buildOverrideDefaultClassCheckBoxAdapter());
    }

    private ButtonModel buildOverrideDefaultClassCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildOverrideDefaultClassHolder());
    }

    private PropertyValueModel buildOverrideDefaultClassHolder() {
        return new TransformationPropertyValueModel(this.buildUseDefaultContainerClassHolder()){

            private Boolean oppositeValue(Boolean bl) {
                return bl == null ? null : Boolean.valueOf(bl == false);
            }

            protected Object reverseTransform(Object object) {
                return this.oppositeValue((Boolean)object);
            }

            protected Object transform(Object object) {
                return this.oppositeValue((Boolean)object);
            }
        };
    }

    private PropertyValueModel buildUseDefaultContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "usesDefaultContainerClass"){

            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).usesDefaultContainerClass();
            }

            protected void setValueOnSubject(Object object) {
                ((DefaultingContainerClass)this.subject).setUseDefaultContainerClass(((Boolean)object).booleanValue());
            }
        };
    }

    private JCheckBox buildUseSortingCheckBox() {
        return this.buildCheckBox("CONTAINER_POLICY_USE_SORTING_CHECK_BOX", this.buildUseSortingCheckBoxAdapter());
    }

    private ButtonModel buildUseSortingCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildUseSortingHolder());
    }

    private PropertyValueModel buildUseSortingHolder() {
        return new PropertyAspectAdapter(this.containerPolicyHolder, "sort"){

            protected Object getValueFromSubject() {
                return ((MWContainerPolicy)this.subject).usesSorting();
            }

            protected void setValueOnSubject(Object object) {
                ((MWContainerPolicy)this.subject).setUsesSorting(((Boolean)object).booleanValue());
            }
        };
    }

    private ListChooser buildKeyMethodChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(this.buildKeyMethodComboBoxModel(), this.getWorkbenchContextHolder());
        defaultListChooser.setRenderer((ListCellRenderer)new AdaptableListCellRenderer(new MethodCellRendererAdapter(this.resourceRepository())));
        return defaultListChooser;
    }

    private ComboBoxModel buildKeyMethodComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildSortedCandidateKeyMethodsHolder(), this.buildKeyMethodHolder());
    }

    private ListValueModel buildSortedCandidateKeyMethodsHolder() {
        return new SortedListValueModelAdapter(this.buildCandidateKeyMethodsHolder());
    }

    private CollectionValueModel buildCandidateKeyMethodsHolder() {
        return new FilteringCollectionValueModel(this.buildReferenceTypeMethodsSignatureAdapter()){

            protected boolean accept(Object object) {
                return ((MWMethod)object).isCandidateMapContainerPolicyKeyMethod();
            }
        };
    }

    private ListValueModel buildReferenceTypeMethodsSignatureAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildReferenceTypeLineageMethodsAdapter(), "signature");
    }

    private CollectionValueModel buildReferenceTypeLineageMethodsAdapter() {
        return new CompositeCollectionValueModel(this.buildReferenceTypeLineageAdapter()){

            protected CollectionValueModel transform(Object object) {
                return ContainerPolicyPanel.this.buildMethodsAdapter((MWClass)object);
            }
        };
    }

    CollectionValueModel buildMethodsAdapter(MWClass mWClass) {
        return new CollectionAspectAdapter("methods", (Model)mWClass){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).methods();
            }

            protected int sizeFromSubject() {
                return ((MWClass)this.subject).methodsSize();
            }
        };
    }

    private CollectionValueModel buildReferenceTypeLineageAdapter() {
        return new CollectionAspectAdapter(this.buildReferenceTypeAdapter(), "superclasses"){

            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).lineage();
            }
        };
    }

    private ValueModel buildReferenceTypeAdapter() {
        return new PropertyAspectAdapter(this.buildReferenceDescriptorAdapter(), "mwClass"){

            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    private ValueModel buildReferenceDescriptorAdapter() {
        return new PropertyAspectAdapter(this.buildMapContainerMappingAdapter(), "referenceDescriptor"){

            protected Object getValueFromSubject() {
                return ((MWReferenceObjectMapping)this.subject).getReferenceDescriptor();
            }
        };
    }

    private ValueModel buildMapContainerMappingAdapter() {
        return new TransformationPropertyValueModel(this.mapContainerPolicyHolder){

            protected Object transform(Object object) {
                return object == null ? null : ((MWMapContainerPolicy)object).getMapContainerMapping();
            }

            protected Object reverseTransform(Object object) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private PropertyValueModel buildKeyMethodHolder() {
        return new PropertyAspectAdapter(this.mapContainerPolicyHolder, "keyMethod"){

            protected Object getValueFromSubject() {
                return ((MWMapContainerPolicy)this.subject).getKeyMethod();
            }

            protected void setValueOnSubject(Object object) {
                ((MWMapContainerPolicy)this.subject).setKeyMethod((MWMethod)object);
            }
        };
    }

    private ItemListener buildKeyMethodWidgetsEnabler(final JComponent jComponent) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                jComponent.setEnabled(itemEvent.getStateChange() == 1);
            }
        };
    }

    private ItemListener buildUseSortingCheckboxEnabler(final JComponent jComponent) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                jComponent.setEnabled(itemEvent.getStateChange() == 1);
            }
        };
    }

    private ItemListener buildComparatorClassChooserSetEnabler(final JComponent jComponent) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                jComponent.setEnabled(itemEvent.getStateChange() == 1 && ContainerPolicyPanel.this.useSortingCheckBox.isSelected());
            }
        };
    }

    private ItemListener buildComparatorClassChooserSortingEnabler(final JComponent jComponent) {
        return new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                jComponent.setEnabled(itemEvent.getStateChange() == 1);
            }
        };
    }
}

