/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.ColumnPairsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.AbstractTableReferencePanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class OneToOneTableReferencePanel
extends AbstractTableReferencePanel {
    OneToOneTableReferencePanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected ColumnPairsPanel buildColumnPairsPanel() {
        return new ExpandedColumnPairsPanel(this.getSubjectHolder(), this.getWorkbenchContextHolder(), this.buildTableReferenceHolder());
    }

    protected MWTable defaultNewReferenceSourceTable() {
        Iterator iterator = this.mapping().getParentRelationalDescriptor().candidateTables();
        return iterator.hasNext() ? (MWTable)iterator.next() : null;
    }

    protected MWTable defaultNewReferenceTargetTable() {
        MWRelationalDescriptor mWRelationalDescriptor = (MWRelationalDescriptor)this.mapping().getReferenceDescriptor();
        if (mWRelationalDescriptor == null) {
            return null;
        }
        Iterator iterator = mWRelationalDescriptor.candidateTables();
        return iterator.hasNext() ? (MWTable)iterator.next() : null;
    }

    private MWOneToOneMapping mapping() {
        return (MWOneToOneMapping)this.subject();
    }

    private static class TargetForeignKeyAdapter
    extends CollectionPropertyValueModelAdapter {
        private ExpandedColumnPairsColumnAdapter columnAdapter;
        private MWColumnPair columnPair;

        public TargetForeignKeyAdapter(CollectionValueModel collectionValueModel, ExpandedColumnPairsColumnAdapter expandedColumnPairsColumnAdapter, MWColumnPair mWColumnPair) {
            super(collectionValueModel);
            this.columnAdapter = expandedColumnPairsColumnAdapter;
            this.columnPair = mWColumnPair;
        }

        public Object getValue() {
            Object object = super.getValue();
            return object == null ? Boolean.FALSE : object;
        }

        public void setValue(Object object) {
            if (this.booleanValue()) {
                if (!this.booleanValueOf(object)) {
                    this.mapping().removeTargetForeignKey(this.columnPair);
                }
            } else if (this.booleanValueOf(object)) {
                this.mapping().addTargetForeignKey(this.columnPair);
            }
        }

        protected Object buildValue() {
            return this.columnPairIsTargetForeignKey();
        }

        private boolean booleanValue() {
            return this.booleanValueOf(this.value);
        }

        private boolean booleanValueOf(Object object) {
            return object == null ? false : (Boolean)object;
        }

        private ValueModel mappingHolder() {
            return this.columnAdapter.mappingHolder();
        }

        private MWOneToOneMapping mapping() {
            return (MWOneToOneMapping)this.mappingHolder().getValue();
        }

        private boolean columnPairIsTargetForeignKey() {
            MWOneToOneMapping mWOneToOneMapping = this.mapping();
            if (mWOneToOneMapping == null) {
                return false;
            }
            return mWOneToOneMapping.containsTargetForeignKey(this.columnPair);
        }
    }

    private static class ExpandedColumnPairsColumnAdapter
    implements ColumnAdapter {
        private ExpandedColumnPairsPanel panel;
        private ResourceRepository resourceRepository;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"ONE_TO_ONE_SOURCE_FIELD_COLUMN", "ONE_TO_ONE_TARGET_FIELD_COLUMN", "ONE_TO_ONE_TARGET_FOREIGN_KEY"};
        private static final int COLUMN_COUNT = 3;
        private static final int SOURCE_COLUMN_COLUMN = 0;
        private static final int TARGET_COLUMN_COLUMN = 1;
        private static final int TARGET_FOREIGN_KEY_COLUMN = 2;

        private ExpandedColumnPairsColumnAdapter(ExpandedColumnPairsPanel expandedColumnPairsPanel, ResourceRepository resourceRepository) {
            this.panel = expandedColumnPairsPanel;
            this.resourceRepository = resourceRepository;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWColumnPair mWColumnPair = (MWColumnPair)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildSourceColumnAdapter(mWColumnPair), this.buildTargetColumnAdapter(mWColumnPair), this.buildTargetForeignKeyAdapter(mWColumnPair)};
            return propertyValueModelArray;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public boolean isColumnEditable(int n) {
            return true;
        }

        private PropertyValueModel buildSourceColumnAdapter(MWColumnPair mWColumnPair) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("sourceColumn", (Model)mWColumnPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getSourceColumn();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumnPair)this.subject).setSourceColumn((MWColumn)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildTargetColumnAdapter(MWColumnPair mWColumnPair) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("targetColumn", (Model)mWColumnPair){

                protected Object getValueFromSubject() {
                    return ((MWColumnPair)this.subject).getTargetColumn();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWColumnPair)this.subject).setTargetColumn((MWColumn)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        ValueModel mappingHolder() {
            return this.panel.getMappingHolder();
        }

        private PropertyValueModel buildTargetForeignKeyAdapter(MWColumnPair mWColumnPair) {
            return new TargetForeignKeyAdapter(this.buildTargetForeignKeysAdapter(), this, mWColumnPair);
        }

        private CollectionValueModel buildTargetForeignKeysAdapter() {
            return new CollectionAspectAdapter(this.mappingHolder(), "targetForeignKeys"){

                protected Iterator getValueFromSubject() {
                    return ((MWOneToOneMapping)this.subject).targetForeignKeys();
                }
            };
        }
    }

    private static class ExpandedColumnPairsPanel
    extends ColumnPairsPanel {
        private ValueModel mappingHolder;

        private ExpandedColumnPairsPanel(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder, PropertyValueModel propertyValueModel) {
            super(workbenchContextHolder, propertyValueModel);
            this.mappingHolder = valueModel;
        }

        protected ColumnAdapter buildColumnAdapter() {
            return new ExpandedColumnPairsColumnAdapter(this, this.resourceRepository());
        }

        ValueModel getMappingHolder() {
            return this.mappingHolder;
        }
    }
}

