/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.ClasspathPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public abstract class AbstractProjectGeneralPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel projectSaveDirectoryHolder;

    protected AbstractProjectGeneralPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
        this.projectSaveDirectoryHolder = this.buildProjectSaveDirectoryHolder();
    }

    protected final JComponent buildProjectSaveLocationPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = this.buildLabel("SAVE_LOCATION_TEXT_FIELD_LABEL");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JTextField jTextField = new JTextField(this.buildSaveLocationDocumentAdapter(), null, 1);
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jTextField, gridBagConstraints);
        this.addHelpTopicId(jTextField, this.helpTopicId() + ".location");
        jLabel.setLabelFor(jTextField);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    protected final JComponent buildCommentPanel() {
        return SwingComponentFactory.buildCommentPanel(this.getSelectionHolder(), this.resourceRepository());
    }

    protected final AbstractPanel buildClassPathPanel() {
        ClasspathPanel classpathPanel = new ClasspathPanel(this.getApplicationContext(), this.buildClasspathHolder(), this.projectSaveDirectoryHolder);
        classpathPanel.setDefaultClasspathDirectoryHolder(this.buildDefaultClasspathDirectoryHolder());
        return classpathPanel;
    }

    protected MWProject getProject() {
        return (MWProject)this.getSelectionHolder().getValue();
    }

    File projectSaveDirectory() {
        return this.getProject().getSaveDirectory();
    }

    String mostRecentClasspathDirectoryPreference() {
        return this.preferences().get("recent classpath directory", null);
    }

    void setMostRecentClasspathDirectoryPreference(String string) {
        this.preferences().put("recent classpath directory", string);
    }

    private ClasspathPanel.DefaultClasspathDirectoryHolder buildDefaultClasspathDirectoryHolder() {
        return new ClasspathPanel.DefaultClasspathDirectoryHolder(){

            public File getDefaultClasspathDirectory() {
                String string = AbstractProjectGeneralPropertiesPage.this.mostRecentClasspathDirectoryPreference();
                if (string != null) {
                    return new File(string);
                }
                File file = AbstractProjectGeneralPropertiesPage.this.projectSaveDirectory();
                if (file != null) {
                    return file;
                }
                return FileTools.userHomeDirectory();
            }

            public void setDefaultClasspathDirectory(File file) {
                AbstractProjectGeneralPropertiesPage.this.setMostRecentClasspathDirectoryPreference(file.getPath());
            }
        };
    }

    private PropertyValueModel buildProjectSaveDirectoryHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "saveDirectory"){

            protected Object getValueFromSubject() {
                return ((MWProject)this.subject).getSaveDirectory();
            }
        };
    }

    private Document buildSaveLocationDocumentAdapter() {
        return new DocumentAdapter(new PropertyAspectAdapter(this.projectSaveDirectoryHolder){

            protected Object getValueFromSubject() {
                return ((File)this.subject).getAbsolutePath();
            }
        });
    }

    private PropertyValueModel buildRepositoryHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWProject)this.subject).getRepository();
            }
        };
    }

    private ListValueModel buildClasspathHolder() {
        return new ListAspectAdapter(this.buildRepositoryHolder(), "classpathEntries"){

            public void addItem(int n, Object object) {
                ((MWClassRepository)this.subject).addClasspathEntry(n, (String)object);
            }

            protected ListIterator getValueFromSubject() {
                return ((MWClassRepository)this.subject).classpathEntries();
            }

            public Object removeItem(int n) {
                return ((MWClassRepository)this.subject).removeClasspathEntry(n);
            }

            public Object replaceItem(int n, Object object) {
                return ((MWClassRepository)this.subject).replaceClasspathEntry(n, (String)object);
            }

            protected int sizeFromSubject() {
                return ((MWClassRepository)this.subject).classpathEntriesSize();
            }
        };
    }

    protected final String helpTopicId() {
        return "project.general";
    }
}

