/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Color;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWBatchReadItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTree;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableTreeNode;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

final class BatchReadAttributesPanel
extends AbstractAttributeItemsPanel {
    public BatchReadAttributesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected PropertyValueModel buildQueryHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWRelationalReadAllQuery;
            }
        };
    }

    protected String helpTopicId() {
        return "query.report.batchReadAttributes";
    }

    String listTitleKey() {
        return "BATCH_READ_ATTRIBUTES_LIST";
    }

    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public String optionalButtonKey() {
                return "BATCH_READ_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                BatchReadAttributesPanel.this.editSelectedAttribute((MWAttributeItem)objectListSelectionModel.getSelectedValue());
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                BatchReadAttributesPanel.this.addBatchReadAttribute();
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWRelationalReadAllQuery)BatchReadAttributesPanel.this.getQuery()).removeBatchReadItem((MWBatchReadItem)objectArray[i]);
                }
            }

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWRelationalReadAllQuery)BatchReadAttributesPanel.this.getQuery()).moveBatchReadItemDown((MWBatchReadItem)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWRelationalReadAllQuery)BatchReadAttributesPanel.this.getQuery()).moveBatchReadItemUp((MWBatchReadItem)objectArray[i]);
                }
            }
        };
    }

    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "batchReadItems"){

            protected ListIterator getValueFromSubject() {
                return ((MWRelationalReadAllQuery)this.subject).batchReadItems();
            }

            protected int sizeFromSubject() {
                return ((MWRelationalReadAllQuery)this.subject).batchReadItemsSize();
            }
        };
    }

    protected boolean panelEnabled(MWQueryFormat mWQueryFormat) {
        return mWQueryFormat.batchReadAttributesAllowed();
    }

    private void addBatchReadAttribute() {
        this.editSelectedAttribute(null);
    }

    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem mWAttributeItem) {
        return new AttributeItemDialog(this.getQuery(), mWAttributeItem, this.getWorkbenchContext()){

            protected String titleKey() {
                return "BATCH_READ_ATTRIBUTE_DIALOG_TITLE";
            }

            protected String editTitleKey() {
                return "BATCH_READ_ATTRIBUTE_EDIT_DIALOG_TITLE";
            }

            protected String helpTopicId() {
                return "dialog.batchReadAttribute";
            }

            protected QueryableTree buildQueryableTree() {
                QueryableTree queryableTree = super.buildQueryableTree();
                queryableTree.setCellRenderer(this.buildQueryableTreeRenderer(queryableTree));
                queryableTree.setCellEditor(null);
                return queryableTree;
            }

            private TreeCellRenderer buildQueryableTreeRenderer(final QueryableTree queryableTree) {
                return new SimpleTreeCellRenderer(){

                    public Color getBackgroundSelectionColor() {
                        if (!queryableTree.hasFocus() && !queryableTree.isEditing()) {
                            return UIManager.getColor("Panel.background");
                        }
                        return super.getBackgroundSelectionColor();
                    }

                    public Color getBorderSelectionColor() {
                        if (!queryableTree.hasFocus() && !queryableTree.isEditing()) {
                            return UIManager.getColor("Panel.background");
                        }
                        return super.getBorderSelectionColor();
                    }

                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        dimension.height += 2;
                        return dimension;
                    }

                    protected String buildText(Object object) {
                        if (MWTableDescriptor.class.isAssignableFrom(((DefaultMutableTreeNode)object).getUserObject().getClass())) {
                            return "";
                        }
                        return ((QueryableTreeNode)object).getQueryable().getName();
                    }

                    protected Icon buildIcon(Object object) {
                        if (MWTableDescriptor.class.isAssignableFrom(((DefaultMutableTreeNode)object).getUserObject().getClass())) {
                            return null;
                        }
                        return this.resourceRepository().getIcon(((QueryableTreeNode)object).getQueryable().iconKey());
                    }
                };
            }

            protected int attributeItemsSize() {
                return ((MWRelationalReadAllQuery)this.getQuery()).batchReadItemsSize();
            }

            protected int indexOfAttributeItem(MWAttributeItem mWAttributeItem) {
                return ((MWRelationalReadAllQuery)this.getQuery()).indexOfBatchReadItem((MWBatchReadItem)mWAttributeItem);
            }

            protected void removeAttributeItem(int n) {
                ((MWRelationalReadAllQuery)this.getQuery()).removeBatchReadItem(n);
            }

            protected void addAttributeItem(int n, Iterator iterator, Iterator iterator2) {
                ((MWRelationalReadAllQuery)this.getQuery()).addBatchReadItem(n, iterator, iterator2);
            }

            protected Filter buildTraversableFilter() {
                return new Filter(){

                    public boolean accept(Object object) {
                        return ((MWQueryable)object).isTraversableForBatchReadAttribute();
                    }
                };
            }

            protected Filter buildChooseableFilter() {
                return new Filter(){

                    public boolean accept(Object object) {
                        return ((MWQueryable)object).isValidForBatchReadAttribute();
                    }
                };
            }
        };
    }
}

