/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryableEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class FirstArgumentPanel
extends AbstractPanel {
    private PropertyValueModel argumentHolder;
    private JTextField queryKeyTextField;
    private JButton editQueryKeyButton;

    FirstArgumentPanel(PropertyValueModel propertyValueModel, ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.argumentHolder = propertyValueModel;
        this.initializeLayout(valueModel);
    }

    private void initializeLayout(ValueModel valueModel) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        JLabel jLabel = new JLabel(this.resourceRepository().getString("QUERY_KEY_LABEL_ON_FIRST_ARGUMENT_PANEL"));
        arrayList.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)jLabel, gridBagConstraints);
        this.queryKeyTextField = this.buildQueryableTextField();
        arrayList.add(this.queryKeyTextField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.queryKeyTextField, gridBagConstraints);
        this.editQueryKeyButton = new JButton(this.resourceRepository().getString("QUERY_KEY_EDIT_BUTTON_ON_FIRST_ARGUMENT_PANEL"));
        this.editQueryKeyButton.setMnemonic(this.resourceRepository().getMnemonic("QUERY_KEY_EDIT_BUTTON_ON_FIRST_ARGUMENT_PANEL"));
        this.editQueryKeyButton.addActionListener(this.buildEditQueryKeyAction());
        arrayList.add(this.editQueryKeyButton);
        new ComponentEnabler(valueModel, arrayList);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.editQueryKeyButton, gridBagConstraints);
    }

    private JTextField buildQueryableTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setDocument(new DocumentAdapter(this.buildQueryableHolder()));
        jTextField.setEditable(false);
        return jTextField;
    }

    private PropertyValueModel buildQueryableHolder() {
        return new PropertyAspectAdapter(this.argumentHolder, "queryableArgumentElement"){

            protected Object getValueFromSubject() {
                return ((MWQueryableArgument)this.subject).displayString();
            }
        };
    }

    private ActionListener buildEditQueryKeyAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FirstArgumentPanel.this.editQueryKey();
            }
        };
    }

    private void editQueryKey() {
        QueryableEditDialog queryableEditDialog = new QueryableEditDialog((MWQueryableArgument)this.argumentHolder.getValue(), this.getWorkbenchContext());
        queryableEditDialog.show();
    }
}

