/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryParameterArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryParameterDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class ParameterArgumentPanel
extends ArgumentPanel {
    private PropertyValueModel queryArgumentHolder;

    ParameterArgumentPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder, Collection collection) {
        super(propertyValueModel, workbenchContextHolder);
        this.initialize(collection);
    }

    private void initialize(Collection collection) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JComboBox jComboBox = this.buildParameterComboBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jComboBox, gridBagConstraints);
        collection.add(jComboBox);
        JButton jButton = this.buildButton("ADD_PARAMETER_BUTTON");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParameterArgumentPanel.this.addParameter();
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jButton, gridBagConstraints);
    }

    private void addParameter() {
        MWQuery mWQuery = (MWQuery)this.getQueryHolder().getValue();
        String string = NameTools.uniqueNameFor((String)"arg", (Iterator)mWQuery.parameterNames());
        QueryParameterDialog queryParameterDialog = new QueryParameterDialog(mWQuery, mWQuery.typeFor(String.class), string, (AbstractDialog)this.getWorkbenchContext().getCurrentWindow(), this.getWorkbenchContext(), this.resourceRepository().getString("QUERY_PARAMETER_DIALOG.title"));
        queryParameterDialog.show();
        if (queryParameterDialog.wasConfirmed()) {
            MWClass mWClass = queryParameterDialog.getParameterType();
            String string2 = queryParameterDialog.getParameterName();
            MWQueryParameter mWQueryParameter = mWQuery.addParameter(mWClass);
            mWQueryParameter.setName(string2);
            ((MWQueryParameterArgument)this.getArgumentHolder().getValue()).setQueryParameter(mWQueryParameter);
        }
    }

    private JComboBox buildParameterComboBox() {
        JComboBox jComboBox = new JComboBox(new ComboBoxModelAdapter(this.buildParametersCollectionHolder(), this.buildParameterHolder()));
        jComboBox.setRenderer(this.buildParametersListCellRenderer());
        return jComboBox;
    }

    private ListValueModel buildParametersCollectionHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "parameters"){

            protected ListIterator getValueFromSubject() {
                return ((MWAbstractQuery)this.subject).parameters();
            }

            protected int sizeFromSubject() {
                return ((MWAbstractQuery)this.subject).parametersSize();
            }
        };
    }

    private PropertyValueModel buildParameterHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "queryParameter"){

            protected Object getValueFromSubject() {
                return ((MWQueryParameterArgument)this.subject).getQueryParameter();
            }

            protected void setValueOnSubject(Object object) {
                ((MWQueryParameterArgument)this.subject).setQueryParameter((MWQueryParameter)object);
            }
        };
    }

    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWQueryParameterArgument;
            }
        };
    }

    private ListCellRenderer buildParametersListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? ParameterArgumentPanel.this.resourceRepository().getString("NONE_SELECTED") : ((MWQueryParameter)object).getName();
            }
        };
    }
}

