/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListSplitPane;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalClassDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWUserDefinedQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.QueryKeyCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class RelationalDescriptorQueryKeysPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel selectedQueryKeyHolder;
    private ListChooser fieldChooser;
    private AddRemoveListPanel queryKeyListPanel;

    public RelationalDescriptorQueryKeysPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initialize(PropertyValueModel propertyValueModel) {
        super.initialize(propertyValueModel);
    }

    protected String helpTopicId() {
        return "descriptor.queryKeys";
    }

    protected Component buildPage() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.selectedQueryKeyHolder = new SimplePropertyValueModel();
        this.queryKeyListPanel = new AddRemoveListPanel(this.getApplicationContext(), (AddRemovePanel.Adapter)this.buildAddRemoveListPanelAdapter(), this.buildSortedQueryKeysListValueModel(), this.resourceRepository().getString("QUERYKEYS"));
        this.queryKeyListPanel.setCellRenderer(this.buildAbstractQueryListCellRenderer());
        this.queryKeyListPanel.addListSelectionListener(this.buildListSelectionListener(this.queryKeyListPanel));
        AddRemoveListSplitPane addRemoveListSplitPane = new AddRemoveListSplitPane(this.queryKeyListPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)addRemoveListSplitPane, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        addRemoveListSplitPane.setRightComponent(jPanel2);
        JLabel jLabel = this.buildLabel("FIELD");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.fieldChooser = this.buildDatabaseFieldChooser();
        jLabel.setLabelFor(this.fieldChooser);
        this.fieldChooser.setEnabled(false);
        new ComponentEnabler(this.buildFieldChooserEnablerModel(this.queryKeyListPanel), Collections.singleton(this.fieldChooser));
        jPanel2.add((Component)this.fieldChooser, gridBagConstraints);
        this.addHelpTopicId(jPanel2, this.helpTopicId() + ".field");
        Spacer spacer = new Spacer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)spacer, gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    private AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                RelationalDescriptorQueryKeysPropertiesPage.this.addNewQueryKey(objectListSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                RelationalDescriptorQueryKeysPropertiesPage.this.removeSelectedQueryKeys(CollectionTools.iterator((Object[])objectListSelectionModel.getSelectedValues()));
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                RelationalDescriptorQueryKeysPropertiesPage.this.renameSelectedQueryKey(objectListSelectionModel);
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1 && !((MWQueryKey)objectListSelectionModel.getSelectedValue()).isAutoGenerated();
            }

            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    private MWRelationalClassDescriptor descriptor() {
        return (MWRelationalClassDescriptor)this.getSelectionHolder().getValue();
    }

    private Iterator queryKeyNames() {
        return new TransformationIterator(this.descriptor().allQueryKeys()){

            protected Object transform(Object object) {
                return ((MWQueryKey)object).getName();
            }
        };
    }

    private ListValueModel buildSortedQueryKeysListValueModel() {
        return new SortedListValueModelAdapter(this.buildItemListValueModelAdapter());
    }

    private ListValueModel buildItemListValueModelAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildQueryKeysHolder(), "name");
    }

    private void addNewQueryKey(ObjectListSelectionModel objectListSelectionModel) {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("ADD_NEW_QUERYKEY"));
        builder.setTextFieldDescription(this.resourceRepository().getString("ENTER_NEW_QUERYKEY_NAME"));
        builder.setExistingNames(this.queryKeyNames());
        builder.setHelpTopicId("descriptor.queryKeys");
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        MWUserDefinedQueryKey mWUserDefinedQueryKey = this.descriptor().addQueryKey(newNameDialog.getNewName(), null);
        objectListSelectionModel.setSelectedValue(mWUserDefinedQueryKey);
    }

    private void renameSelectedQueryKey(ObjectListSelectionModel objectListSelectionModel) {
        MWUserDefinedQueryKey mWUserDefinedQueryKey = (MWUserDefinedQueryKey)objectListSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(this.queryKeyNames());
        builder.setOriginalName(mWUserDefinedQueryKey.getName());
        builder.setTextFieldDescription(this.resourceRepository().getString("RENAME_QUERYKEY_MESSAGE"));
        builder.setTitle(this.resourceRepository().getString("RENAME_QUERYKEY_TITLE", mWUserDefinedQueryKey.getName()));
        builder.setHelpTopicId("dialog.queryKeyRename");
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        String string = newNameDialog.getNewName();
        mWUserDefinedQueryKey.setName(string);
        objectListSelectionModel.setSelectedValue(mWUserDefinedQueryKey);
    }

    private void removeSelectedQueryKeys(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeSelectedQueryKey((MWQueryKey)iterator.next());
        }
    }

    private void removeSelectedQueryKey(MWQueryKey mWQueryKey) {
        if (mWQueryKey.isAutoGenerated()) {
            JOptionPane.showMessageDialog(this.currentWindow(), this.resourceRepository().getString("CANNOT_REMOVE_AUTOGENERATED"), this.resourceRepository().getString("QUERYKEY_REMOVE"), 2);
        } else {
            mWQueryKey.getDescriptor().removeQueryKey((MWUserDefinedQueryKey)mWQueryKey);
        }
    }

    private ListChooser buildDatabaseFieldChooser() {
        DefaultListChooser defaultListChooser = new DefaultListChooser(RelationalMappingComponentFactory.buildExtendedColumnComboBoxModel(this.buildFieldHolder(), this.getSelectionHolder()), this.getWorkbenchContextHolder(), RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder()), RelationalMappingComponentFactory.buildColumnChooserDialogBuilder());
        defaultListChooser.setRenderer(RelationalMappingComponentFactory.buildColumnListRenderer(this.getSelectionHolder(), this.resourceRepository()));
        return defaultListChooser;
    }

    private PropertyValueModel buildFieldHolder() {
        return new PropertyAspectAdapter(this.selectedQueryKeyHolder, "column"){

            protected Object getValueFromSubject() {
                return ((MWQueryKey)this.subject).getColumn();
            }

            protected void setValueOnSubject(Object object) {
                ((MWUserDefinedQueryKey)this.subject).setColumn((MWColumn)object);
            }
        };
    }

    private CollectionValueModel buildQueryKeysHolder() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "userDefinedQueryKeys"){

            protected Iterator getValueFromSubject() {
                return ((MWRelationalClassDescriptor)this.subject).allQueryKeys();
            }
        };
    }

    private ListCellRenderer buildAbstractQueryListCellRenderer() {
        return new AdaptableListCellRenderer(new QueryKeyCellRendererAdapter(this.resourceRepository()));
    }

    private ListSelectionListener buildListSelectionListener(final AddRemoveListPanel addRemoveListPanel) {
        return new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MWQueryKey mWQueryKey = (MWQueryKey)addRemoveListPanel.getSelectedValue();
                RelationalDescriptorQueryKeysPropertiesPage.this.selectedQueryKeyHolder.setValue(mWQueryKey);
                MWRelationalClassDescriptor mWRelationalClassDescriptor = (MWRelationalClassDescriptor)RelationalDescriptorQueryKeysPropertiesPage.this.getSelectionHolder().getValue();
                if (mWQueryKey == null || mWRelationalClassDescriptor == null) {
                    RelationalDescriptorQueryKeysPropertiesPage.this.fieldChooser.setEnabled(false);
                } else {
                    RelationalDescriptorQueryKeysPropertiesPage.this.fieldChooser.setEnabled(!mWRelationalClassDescriptor.isAggregateDescriptor());
                    RelationalDescriptorQueryKeysPropertiesPage.this.fieldChooser.setChoosable(!mWQueryKey.isAutoGenerated());
                }
            }
        };
    }

    private ValueModel buildFieldChooserEnablerModel(final AddRemoveListPanel addRemoveListPanel) {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                if ((MWQueryKey)addRemoveListPanel.getSelectedValue() == null) {
                    return Boolean.FALSE;
                }
                return !((MWRelationalClassDescriptor)this.subject).isAggregateDescriptor();
            }
        };
    }

    public void selectQueryKey(MWQueryKey mWQueryKey) {
        this.queryKeyListPanel.setSelectedValue(mWQueryKey, true);
    }
}

