/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.NumberFormat;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.Spacer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractProcedureInOutputArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.Combo;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class ValueInOutArgumentPane
extends AbstractSubjectPanel {
    public ValueInOutArgumentPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JButton jButton = new JButton(this.buildEditAction());
        jButton.setText(this.resourceRepository().getString("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_EDIT_BUTTON"));
        JTextField jTextField = new JTextField(this.buildArgumentValueDocument(), null, 20);
        JComponent jComponent = this.buildLabeledComponent("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_COLUMN", jTextField, jButton);
        jTextField.setEditable(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        JComponent jComponent2 = this.buildLabeledTextField("STORED_PROCEDURE_PROPERTIES_PAGE_OUTFIELD_NAME_COLUMN", this.buildOutFieldNameDocument());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)jComponent2, gridBagConstraints);
        JLabel jLabel = this.buildLabel("STORED_PROCEDURE_PROPERTIES_PAGE_JAVA_CLASS_TYPE_COLUMN");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(14, 0, 0, 2);
        this.add((Component)jLabel, gridBagConstraints);
        ClassChooserPanel classChooserPanel = ClassChooserTools.buildPanel(this.buildClassTransformer(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), this.getWorkbenchContextHolder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jLabel.setLabelFor(classChooserPanel);
        this.add((Component)classChooserPanel, gridBagConstraints);
    }

    private Action buildEditAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArgumentValueDialog argumentValueDialog = new ArgumentValueDialog(ValueInOutArgumentPane.this.getWorkbenchContext(), ValueInOutArgumentPane.this.getSubjectHolder());
                argumentValueDialog.show();
                if (argumentValueDialog.wasConfirmed()) {
                    ((MWAbstractProcedureArgument)ValueInOutArgumentPane.this.subject()).setArgumentValue(argumentValueDialog.getArgumentValue());
                }
            }
        };
    }

    private Document buildArgumentValueDocument() {
        return new DocumentAdapter(this.buildArgumentValueHolder());
    }

    private PropertyValueModel buildArgumentValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "argumentValue"){

            protected Object getValueFromSubject() {
                return ((MWAbstractProcedureArgument)ValueInOutArgumentPane.this.subject()).getArgumentValue();
            }

            protected void setValueOnSubject(Object object) {
                ((MWAbstractProcedureArgument)ValueInOutArgumentPane.this.subject()).setArgumentValue((String)object);
            }
        };
    }

    private Document buildOutFieldNameDocument() {
        return new DocumentAdapter(this.buildArgumentOutFieldNameAdapter());
    }

    private PropertyValueModel buildArgumentOutFieldNameAdapter() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "outFieldName"){

            protected Object getValueFromSubject() {
                return ((MWAbstractProcedureInOutputArgument)this.subject).getOutFieldName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWAbstractProcedureInOutputArgument)this.subject).setOutFieldName((String)object);
            }
        };
    }

    protected PropertyValueModel buildClassTransformer() {
        return new TransformationPropertyValueModel(this.buildClassNameHolder()){

            protected Object transform(Object object) {
                if (object == null || "".equals((String)object) || ValueInOutArgumentPane.this.subject() == null) {
                    return null;
                }
                return ((MWAbstractProcedureArgument)ValueInOutArgumentPane.this.subject()).typeNamed((String)object);
            }

            protected Object reverseTransform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((MWClass)object).fullName();
            }
        };
    }

    protected PropertyValueModel buildClassNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "fieldJavaClassName"){

            protected Object getValueFromSubject() {
                return ((MWAbstractProcedureArgument)this.subject).getFieldJavaClassName();
            }

            protected void setValueOnSubject(Object object) {
                ((MWAbstractProcedureArgument)this.subject).setFieldJavaClassName((String)object);
            }
        };
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            public MWClassRepository getClassRepository() {
                return ((MWModel)ValueInOutArgumentPane.this.subject()).getRepository();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArgumentValueDialog
    extends AbstractDialog {
        private JTextField argumentValueTextField;
        private Combo typeChooser;
        private ValueModel argumentHolder;

        private ArgumentValueDialog(WorkbenchContext workbenchContext, ValueModel valueModel) {
            super(workbenchContext);
            this.argumentHolder = valueModel;
        }

        @Override
        protected AbstractSubjectPanel buildMainPanel() {
            return new DialogPane(ValueInOutArgumentPane.this.getSubjectHolder(), this.getApplicationContext());
        }

        protected MWAbstractProcedureArgument argument() {
            return (MWAbstractProcedureArgument)this.argumentHolder.getValue();
        }

        protected String getInvalidInputMessageKey(Class clazz, List<String> list) {
            String string = clazz.getName();
            if (string.equals("java.lang.Boolean")) {
                return "BE_EITHER_TRUE_OR_FALSE";
            }
            if (string.equals("java.lang.Byte")) {
                return "BE_BETWEEN_0_AND_127";
            }
            if (string.equals("java.lang.Character")) {
                return "BE_SINGLE_CHARACTER";
            }
            if (string.equals("java.lang.Double")) {
                CollectionTools.addAll(list, (Object[])new String[]{NumberFormat.getInstance().format(Double.MIN_VALUE), NumberFormat.getInstance().format(Double.MAX_VALUE)});
                return "BE_BETWEEN_DOUBLE";
            }
            if (string.equals("java.lang.Float")) {
                CollectionTools.addAll(list, (Object[])new String[]{NumberFormat.getInstance().format(1.4E-45f), NumberFormat.getInstance().format(3.4028234663852886E38)});
                return "BE_BETWEEN_FLOAT";
            }
            if (string.equals("java.lang.Integer")) {
                CollectionTools.addAll(list, (Object[])new String[]{NumberFormat.getInstance().format(Integer.MIN_VALUE), NumberFormat.getInstance().format(Integer.MAX_VALUE)});
                return "BE_BETWEEN_INT";
            }
            if (string.equals("java.lang.Long")) {
                CollectionTools.addAll(list, (Object[])new String[]{NumberFormat.getInstance().format(Long.MIN_VALUE), NumberFormat.getInstance().format(Long.MAX_VALUE)});
                return "BE_BETWEEN_LONG";
            }
            if (string.equals("java.lang.Short")) {
                CollectionTools.addAll(list, (Object[])new String[]{NumberFormat.getInstance().format(-32768L), NumberFormat.getInstance().format(32767L)});
                return "BE_BETWEEN_SHORT";
            }
            if (string.equals("java.lang.String")) {
                return "BE_A_STRING";
            }
            if (string.equals("java.math.BigDecimal")) {
                return "CONTAINS_ONLY_DIGITS";
            }
            if (string.equals("java.math.BigInteger")) {
                return "CONTAINS_ONLY_DIGITS_AND";
            }
            if (string.equals("java.sql.Date")) {
                return "BE_IN_FORMAT1";
            }
            if (string.equals("java.sql.Time")) {
                return "BE_IN_FORMAT2";
            }
            if (string.equals("java.sql.Timestamp")) {
                return "BE_IN_FORMAT3";
            }
            if (string.equals("java.util.Date")) {
                return "BE_IN_FORMAT4";
            }
            if (string.equals("java.util.Calendar")) {
                return "BE_IN_FORMAT5";
            }
            if (clazz == byte[].class || clazz == Byte[].class) {
                return "BE_IN_FORMAT_BYTE_ARRAY";
            }
            if (clazz == char[].class || clazz == Character[].class) {
                return "BE_A_STRING";
            }
            return "ILLEGAL_FORMAT";
        }

        @Override
        protected String helpTopicId() {
            return "storedprocedure.arguments.value.editDialog";
        }

        @Override
        public boolean preConfirm() {
            try {
                this.argument().buildValueFromString((String)this.typeChooser.getSelectedItem(), this.argumentValueTextField.getText());
            }
            catch (ConversionException conversionException) {
                this.showInvalidConversionDialog(conversionException);
                return false;
            }
            return true;
        }

        public String getArgumentValue() {
            return this.argumentValueTextField.getText();
        }

        private void showInvalidConversionDialog(ConversionException conversionException) {
            Vector<String> vector = new Vector<String>();
            vector.add(conversionException.getClassToConvertTo().getName());
            JOptionPane.showMessageDialog(this.getWorkbenchContext().getCurrentWindow(), this.resourceRepository().getString(this.getInvalidInputMessageKey(conversionException.getClassToConvertTo(), vector), vector.toArray()), this.resourceRepository().getString("ILLEGAL_FORMAT"), 2);
        }

        private void updateOKButton() {
            boolean bl = this.argumentValueTextField.getText() != null && !this.argumentValueTextField.getText().equals("");
            this.getOKAction().setEnabled(bl);
        }

        private class DialogPane
        extends AbstractSubjectPanel {
            DialogPane(ValueModel valueModel, ApplicationContext applicationContext) {
                super(valueModel, applicationContext);
            }

            private ComboBoxModel buildValueTypeComboboxModel() {
                return new ComboBoxModelAdapter(this.buildValueTypeChooserValueModel(), this.buildValueTypeChooserPropertyAdapter());
            }

            private ListValueModel buildValueTypeChooserValueModel() {
                return new ListAspectAdapter(ArgumentValueDialog.this.argumentHolder){

                    protected ListIterator getValueFromSubject() {
                        return MWAbstractProcedureArgument.buildBasicTypesList().listIterator();
                    }
                };
            }

            private PropertyValueModel buildValueTypeChooserPropertyAdapter() {
                return new SimplePropertyValueModel();
            }

            protected void initializeLayout() {
                this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                ArgumentValueDialog.this.setTitle(this.resourceRepository().getString("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_EDIT_DIALOG_TITLE"));
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                ArgumentValueDialog.this.typeChooser = new Combo(this.buildValueTypeComboboxModel());
                JComponent jComponent = this.buildLabeledComponent("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_CLASS_COLUMN", ArgumentValueDialog.this.typeChooser);
                ArgumentValueDialog.this.typeChooser.setSelectedIndex(8);
                ArgumentValueDialog.this.typeChooser.setEditable(false);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 21;
                gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                this.add((Component)jComponent, gridBagConstraints);
                ArgumentValueDialog.this.argumentValueTextField = new JTextField(20);
                JComponent jComponent2 = this.buildLabeledComponent("STORED_PROCEDURE_PROPERTIES_PAGE_ARGUMENT_VALUE_COLUMN", ArgumentValueDialog.this.argumentValueTextField);
                ArgumentValueDialog.this.argumentValueTextField.getDocument().addDocumentListener(new CVDocumentListener());
                ArgumentValueDialog.this.argumentValueTextField.setColumns(20);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 21;
                gridBagConstraints.insets = new Insets(5, 0, 0, 0);
                this.add((Component)jComponent2, gridBagConstraints);
                Spacer spacer = new Spacer(-1);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 3;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                this.add((Component)spacer, gridBagConstraints);
                ArgumentValueDialog.this.updateOKButton();
            }
        }

        private class CVDocumentListener
        implements DocumentListener {
            private CVDocumentListener() {
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ArgumentValueDialog.this.updateOKButton();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                ArgumentValueDialog.this.updateOKButton();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ArgumentValueDialog.this.updateOKButton();
            }
        }
    }
}

