/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CheckBoxTableCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TableCellEditorAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.iterators.SingleElementListIterator;

final class SchemaNamespacesPanel
extends AbstractPropertiesPage {
    SchemaNamespacesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.buildBuiltInNamespacesPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.add((Component)this.buildTargetNamespacePanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.buildImportedNamespacesPanel(), gridBagConstraints);
    }

    private JPanel buildBuiltInNamespacesPanel() {
        return this.buildNamespacePanel(this.buildBuiltInNamespacesTableLabel(), this.buildBuiltInNamespacesTable());
    }

    private JLabel buildBuiltInNamespacesTableLabel() {
        return this.buildLabel("BUILT_IN_NAMESPACES_TABLE_LABEL");
    }

    private JTable buildBuiltInNamespacesTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.buildBuiltInNamespacesTableModel());
        jTable.getTableHeader().setReorderingAllowed(false);
        return jTable;
    }

    private TableModelAdapter buildBuiltInNamespacesTableModel() {
        return new TableModelAdapter(this.buildBuiltInNamespacesAdapter(), this.buildColumnAdapter());
    }

    private ListValueModel buildBuiltInNamespacesAdapter() {
        return new ListAspectAdapter(this.getSelectionHolder()){

            protected ListIterator getValueFromSubject() {
                return ((MWXmlSchema)this.subject).builtInNamespaces();
            }
        };
    }

    private JPanel buildTargetNamespacePanel() {
        return this.buildNamespacePanel(this.buildTargetNamespaceTableLabel(), this.buildTargetNamespaceTable());
    }

    private JLabel buildTargetNamespaceTableLabel() {
        return this.buildLabel("TARGET_NAMESPACE_TABLE_LABEL");
    }

    private JTable buildTargetNamespaceTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.buildTargetNamespaceTableModel());
        jTable.getTableHeader().setReorderingAllowed(false);
        return jTable;
    }

    private TableModelAdapter buildTargetNamespaceTableModel() {
        return new TableModelAdapter(this.buildTargetNamespaceAdapter(), this.buildColumnAdapter()){

            public boolean isCellEditable(int n, int n2) {
                if (n2 == 1 && "".equals(SchemaNamespacesPanel.this.schema().targetNamespace().getNamespaceUrl())) {
                    return false;
                }
                return super.isCellEditable(n, n2);
            }
        };
    }

    private ListValueModel buildTargetNamespaceAdapter() {
        return new ListAspectAdapter(this.getSelectionHolder()){

            protected ListIterator getValueFromSubject() {
                return new SingleElementListIterator((Object)((MWXmlSchema)this.subject).targetNamespace());
            }

            protected int sizeFromSubject() {
                return 1;
            }
        };
    }

    private JPanel buildImportedNamespacesPanel() {
        return this.buildNamespacePanel(this.buildImportedNamespacesTableLabel(), this.buildImportedNamespacesTable());
    }

    private JLabel buildImportedNamespacesTableLabel() {
        return this.buildLabel("IMPORTED_NAMESPACES_TABLE_LABEL");
    }

    private JTable buildImportedNamespacesTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.buildImportedNamespacesTableModel());
        jTable.getTableHeader().setReorderingAllowed(false);
        return jTable;
    }

    private TableModelAdapter buildImportedNamespacesTableModel() {
        return new TableModelAdapter(this.buildSortedImportedNamespacesAdapter(), this.buildColumnAdapter());
    }

    private ListValueModel buildSortedImportedNamespacesAdapter() {
        return new SortedListValueModelAdapter(this.buildUpdatingImportedNamespacesAdapter(), MWNamespace.COMPARATOR);
    }

    private ListValueModel buildUpdatingImportedNamespacesAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildImportedNamespacesAdapter(), "namespaceUrl");
    }

    private CollectionValueModel buildImportedNamespacesAdapter() {
        return new CollectionAspectAdapter(this.getSelectionHolder(), "namespaces"){

            protected Iterator getValueFromSubject() {
                return ((MWXmlSchema)this.subject).importedNamespaces();
            }
        };
    }

    private JPanel buildNamespacePanel(JLabel jLabel, JTable jTable) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jLabel.setLabelFor(jTable);
        JComponent jComponent = this.buildTablePanel(jTable);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        return jPanel;
    }

    private ColumnAdapter buildColumnAdapter() {
        return new NamespaceColumnAdapter(this.resourceRepository());
    }

    private JComponent buildTablePanel(JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(200);
        TableColumn tableColumn2 = jTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(50);
        TableColumn tableColumn3 = jTable.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(50);
        CheckBoxTableCellRenderer checkBoxTableCellRenderer = this.buildDeclaredRenderer();
        tableColumn3.setCellRenderer(checkBoxTableCellRenderer);
        tableColumn3.setCellEditor(this.buildDeclaredEditor(checkBoxTableCellRenderer));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jTable.getTableHeader(), "First");
        jPanel.add((Component)jTable, "Center");
        return new JScrollPane(jPanel, 21, 31);
    }

    private CheckBoxTableCellRenderer buildDeclaredRenderer() {
        return new CheckBoxTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                MWNamespace mWNamespace = (MWNamespace)((TableModelAdapter)jTable.getModel()).getModel().getItem(n);
                if (!mWNamespace.getNamespaceUrl().equals("")) {
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
                return null;
            }
        };
    }

    private TableCellEditor buildDeclaredEditor(CheckBoxTableCellRenderer checkBoxTableCellRenderer) {
        return new TableCellEditorAdapter(checkBoxTableCellRenderer){

            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                MWNamespace mWNamespace = (MWNamespace)((TableModelAdapter)jTable.getModel()).getModel().getItem(n);
                if (!mWNamespace.getNamespaceUrl().equals("")) {
                    return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
                }
                return null;
            }
        };
    }

    private MWXmlSchema schema() {
        return (MWXmlSchema)this.selection();
    }

    private static class NamespaceColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        private static final int COLUMN_COUNT = 3;
        private static final int URL_COLUMN = 0;
        private static final int PREFIX_COLUMN = 1;
        private static final int DECLARED_COLUMN = 2;

        NamespaceColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return this.resourceRepository.getString("URL_COLUMN_LABEL");
                }
                case 1: {
                    return this.resourceRepository.getString("PREFIX_COLUMN_LABEL");
                }
                case 2: {
                    return this.resourceRepository.getString("DECLARED_COLUMN_LABEL");
                }
            }
            return "";
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        public boolean isColumnEditable(int n) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWNamespace mWNamespace = (MWNamespace)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildUrlAdapter(mWNamespace), this.buildPrefixAdapter(mWNamespace), this.buildDeclaredAdapter(mWNamespace)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildUrlAdapter(MWNamespace mWNamespace) {
            return new PropertyAspectAdapter("namespaceUrl", (Model)mWNamespace){

                protected Object getValueFromSubject() {
                    return ((MWNamespace)this.subject).getNamespaceUrlForDisplay();
                }
            };
        }

        private PropertyValueModel buildPrefixAdapter(MWNamespace mWNamespace) {
            return new PropertyAspectAdapter("namespacePrefix", (Model)mWNamespace){

                protected Object getValueFromSubject() {
                    return ((MWNamespace)this.subject).getNamespacePrefix();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWNamespace)this.subject).setNamespacePrefixFromUser((String)object);
                }
            };
        }

        private PropertyValueModel buildDeclaredAdapter(MWNamespace mWNamespace) {
            return new PropertyAspectAdapter("declared", (Model)mWNamespace){

                protected Object getValueFromSubject() {
                    return new Boolean(((MWNamespace)this.subject).isDeclared());
                }

                protected void setValueOnSubject(Object object) {
                    ((MWNamespace)this.subject).setDeclared(((Boolean)object).booleanValue());
                }
            };
        }
    }
}

