/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaRootElementChooserDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.xml.SchemaValue;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class SchemaRootElementChooser
extends AbstractPanel {
    private SchemaValue schemaValue;
    private PropertyValueModel rootElementHolder;
    private RootElementDisplayStringValueModel rootElementDisplayStringHolder;

    public SchemaRootElementChooser(WorkbenchContextHolder workbenchContextHolder, SchemaValue schemaValue, PropertyValueModel propertyValueModel, JLabel jLabel) {
        super(workbenchContextHolder);
        this.initialize(schemaValue, propertyValueModel, jLabel);
    }

    private void initialize(SchemaValue schemaValue, PropertyValueModel propertyValueModel, JLabel jLabel) {
        this.schemaValue = schemaValue;
        this.rootElementHolder = propertyValueModel;
        this.rootElementDisplayStringHolder = this.buildRootElementDisplayStringHolder();
        this.initializeLayout(jLabel);
    }

    private RootElementDisplayStringValueModel buildRootElementDisplayStringHolder() {
        return new RootElementDisplayStringValueModel(this.rootElementHolder);
    }

    private void initializeLayout(JLabel jLabel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JTextField jTextField = this.buildTextField();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jTextField, gridBagConstraints);
        jTextField.putClientProperty("labeledBy", jLabel);
        JButton jButton = this.buildButton();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.addAlignRight(jButton);
        jLabel.setLabelFor(jButton);
        SwingComponentFactory.updateButtonAccessibleName(jLabel, jButton);
        this.add((Component)jButton, gridBagConstraints);
    }

    private JTextField buildTextField() {
        JTextField jTextField = new JTextField(this.buildRootElementDisplayStringDocument(), null, 1);
        jTextField.setEditable(false);
        jTextField.setEnabled(true);
        return jTextField;
    }

    private DocumentAdapter buildRootElementDisplayStringDocument() {
        return new DocumentAdapter(this.rootElementDisplayStringHolder);
    }

    private JButton buildButton() {
        JButton jButton = this.buildButton("SCHEMA_ROOT_ELEMENT_CHOOSER_BROWSE_BUTTON");
        jButton.addActionListener(this.buildBrowseAction());
        return jButton;
    }

    private ActionListener buildBrowseAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SchemaRootElementChooser.this.promptToSelectRootElement();
            }
        };
    }

    private void promptToSelectRootElement() {
        SchemaRootElementChooserDialog schemaRootElementChooserDialog = new SchemaRootElementChooserDialog(this.getWorkbenchContext(), this.schemaValue.schema(), this.rootElementHolder);
        schemaRootElementChooserDialog.show();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Iterator iterator = CollectionTools.iterator((Object[])this.getComponents());
        while (iterator.hasNext()) {
            ((Component)iterator.next()).setEnabled(bl);
        }
    }

    private class RootElementDisplayStringValueModel
    extends PropertyValueModelWrapper {
        private String displayString;
        private PropertyChangeListener propertyChangeListener;
        private MWNamespace namespace;

        private RootElementDisplayStringValueModel(PropertyValueModel propertyValueModel) {
            super(propertyValueModel);
        }

        protected void initialize() {
            super.initialize();
            this.propertyChangeListener = this.buildPropertyChangeListener();
        }

        private PropertyChangeListener buildPropertyChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    RootElementDisplayStringValueModel.this.displayStringChanged();
                }
            };
        }

        private MWElementDeclaration element() {
            return (MWElementDeclaration)this.valueHolder.getValue();
        }

        private void displayStringChanged() {
            Object object = this.getValue();
            this.synchronizeDisplayString();
            Object object2 = this.getValue();
            this.firePropertyChanged("value", object, object2);
        }

        private void synchronizeDisplayString() {
            this.displayString = this.element() == null ? SchemaRootElementChooser.this.resourceRepository().getString("SCHEMA_ROOT_ELEMENT_CHOOSER_NONE_SELECTED_TEXT") : this.buildDisplayString(this.element());
        }

        private String buildDisplayString(MWElementDeclaration mWElementDeclaration) {
            return mWElementDeclaration.qName();
        }

        private void engageNewElement() {
            if (this.element() != null) {
                this.namespace = this.element().getTargetNamespace();
                this.namespace.addPropertyChangeListener("namespacePrefix", this.propertyChangeListener);
            }
        }

        private void disengageOldElement() {
            if (this.namespace != null) {
                this.namespace.removePropertyChangeListener("namespacePrefix", this.propertyChangeListener);
                this.namespace = null;
            }
        }

        public Object getValue() {
            return this.displayString;
        }

        public void setValue(Object object) {
            throw new UnsupportedOperationException();
        }

        protected void engageValueHolder() {
            super.engageValueHolder();
            this.engageNewElement();
            this.synchronizeDisplayString();
        }

        protected void disengageValueHolder() {
            this.disengageOldElement();
            super.disengageValueHolder();
            this.synchronizeDisplayString();
        }

        protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
            this.disengageOldElement();
            this.engageNewElement();
            this.displayStringChanged();
        }
    }
}

