/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.HelpAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.NewDatabasePlatformRepositoryAction;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPluginResourceBundle;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.preferences.PlatformsPreferencesNode;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.repository.DatabasePlatformRepositoryNode;
import org.eclipse.persistence.tools.workbench.utility.SimpleStack;
import org.eclipse.persistence.tools.workbench.utility.Stack;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;

public final class PlatformsPlugin
implements Plugin {
    private Map propertiesPageCache;
    private static final String PLATFORMS_PREFERENCES_NODE = "platforms";
    public static final String VISIBLE_IN_PRODUCTION_PREFERENCE = "visible in production";
    public static final boolean VISIBLE_IN_PRODUCTION_PREFERENCE_DEFAULT = false;
    private static final String FILE_NAME_EXTENSION = ".dpr";
    private static final JMenuItem[] EMPTY_MENU_ITEMS = new JMenuItem[0];
    private static final PreferencesNode[] EMPTY_PREFERENCES_NODES = new PreferencesNode[0];

    public PlatformsPlugin() {
        this.initialize();
    }

    private void initialize() {
        this.propertiesPageCache = new HashMap();
    }

    public JMenuItem[] buildNewMenuItems(WorkbenchContext workbenchContext) {
        if (this.isVisibleIn(workbenchContext)) {
            return new JMenuItem[]{new JMenuItem(this.getNewDatabasePlatformRepositoryAction(this.wrap(workbenchContext)))};
        }
        return EMPTY_MENU_ITEMS;
    }

    public JMenuItem[] buildMigrateMenuItems(WorkbenchContext workbenchContext) {
        return EMPTY_MENU_ITEMS;
    }

    public ApplicationNode open(File file, WorkbenchContext workbenchContext) throws UnsupportedFileException, OpenException {
        if (!this.fileIsSupported(file)) {
            throw new UnsupportedFileException();
        }
        try {
            return this.buildRepositoryNode(new DatabasePlatformRepository(file), this.wrap(workbenchContext));
        }
        catch (Throwable throwable) {
            throw new OpenException(throwable);
        }
    }

    public ComponentContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarButtonGroupDescription();
    }

    public ComponentContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        return new MenuGroupDescription();
    }

    public PreferencesNode[] buildPreferencesNodes(PreferencesContext preferencesContext) {
        if (this.isVisibleIn(preferencesContext)) {
            return new PreferencesNode[]{new PlatformsPreferencesNode((PreferencesContext)this.wrap(preferencesContext))};
        }
        return EMPTY_PREFERENCES_NODES;
    }

    private boolean isVisibleIn(WorkbenchContext workbenchContext) {
        return this.isVisibleIn(workbenchContext.getApplicationContext());
    }

    private boolean isVisibleIn(ApplicationContext applicationContext) {
        return applicationContext.getApplication().isDevelopmentMode() || this.isVisibleInProduction(applicationContext.getPreferences().node(PLATFORMS_PREFERENCES_NODE));
    }

    private boolean isVisibleInProduction(Preferences preferences) {
        return preferences.getBoolean(VISIBLE_IN_PRODUCTION_PREFERENCE, false);
    }

    public boolean fileIsSupported(File file) {
        return FileTools.extension((File)file).equalsIgnoreCase(FILE_NAME_EXTENSION);
    }

    public FrameworkAction getNewDatabasePlatformRepositoryAction(WorkbenchContext workbenchContext) {
        return new NewDatabasePlatformRepositoryAction(this, workbenchContext);
    }

    public FrameworkAction getHelpAction(WorkbenchContext workbenchContext) {
        return new HelpAction(workbenchContext);
    }

    WorkbenchContext wrap(WorkbenchContext workbenchContext) {
        return workbenchContext.buildExpandedApplicationContextWorkbenchContext(this.wrap(workbenchContext.getApplicationContext()));
    }

    private ApplicationContext wrap(ApplicationContext applicationContext) {
        applicationContext = applicationContext.buildExpandedResourceRepositoryContext(PlatformsPluginResourceBundle.class, new PlatformsPluginIconResourceFileNameMap());
        return applicationContext.buildRedirectedPreferencesContext(PLATFORMS_PREFERENCES_NODE);
    }

    ApplicationNode buildRepositoryNode(DatabasePlatformRepository databasePlatformRepository, WorkbenchContext workbenchContext) {
        return new DatabasePlatformRepositoryNode(databasePlatformRepository, workbenchContext.getApplicationContext(), this);
    }

    Component getPropertiesPage(Class clazz) {
        Stack stack = this.getPropertiesPagesStack(clazz);
        return stack.isEmpty() ? null : (Component)stack.pop();
    }

    void releasePropertiesPage(Class clazz, Component component) {
        this.getPropertiesPagesStack(clazz).push((Object)component);
    }

    private Stack getPropertiesPagesStack(Class clazz) {
        Stack stack = (Stack)this.propertiesPageCache.get(clazz);
        if (stack == null) {
            stack = new SimpleStack();
            this.propertiesPageCache.put(clazz, stack);
        }
        return stack;
    }
}

