/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform;

import java.awt.Cursor;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.platform.DatabasePlatformNode;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

final class AddDatabaseTypeAction
extends AbstractFrameworkAction {
    public AddDatabaseTypeAction(WorkbenchContext workbenchContext) {
        super(workbenchContext);
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("ADD_DATABASE_TYPE");
        this.initializeIcon("ADD_DATABASE_TYPE");
        this.initializeToolTipText("ADD_DATABASE_TYPE.TOOL_TIP");
    }

    protected void execute() {
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
        NewNameDialog.Builder builder = this.buildNewNameDialogBuilder();
        ApplicationNode[] applicationNodeArray = this.selectedNodes();
        AbstractApplicationNode abstractApplicationNode = null;
        DatabaseType databaseType = null;
        int n = applicationNodeArray.length;
        while (n-- > 0) {
            DatabasePlatformNode databasePlatformNode = (DatabasePlatformNode)applicationNodeArray[n];
            DatabaseType databaseType2 = this.execute(databasePlatformNode.getDatabasePlatform(), builder);
            if (databaseType2 == null) continue;
            abstractApplicationNode = databasePlatformNode;
            databaseType = databaseType2;
        }
        if (abstractApplicationNode != null) {
            abstractApplicationNode.selectDescendantNodeForValue((Node)databaseType, this.navigatorSelectionModel());
        }
    }

    private NewNameDialog.Builder buildNewNameDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("ADD_DATABASE_TYPE_DIALOG_TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("ADD_DATABASE_TYPE_DIALOG_DESCRIPTION"));
        builder.setHelpTopicId("dialog.dbTypeAdd");
        builder.setComparisonIsCaseSensitive(true);
        return builder;
    }

    protected DatabaseType execute(DatabasePlatform databasePlatform, NewNameDialog.Builder builder) {
        builder.setExistingNames(this.existingTypeNames(databasePlatform));
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasConfirmed()) {
            return databasePlatform.addDatabaseType(newNameDialog.getNewName());
        }
        return null;
    }

    private Iterator existingTypeNames(DatabasePlatform databasePlatform) {
        return new TransformationIterator(databasePlatform.databaseTypes()){

            protected Object transform(Object object) {
                return ((DatabaseType)object).getName();
            }
        };
    }
}

