/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.EISLoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.XMLLoginAdapter;

public class DataSource {
    private static final int DATABASE_PLATFORM_ID = 1;
    private static final int EIS_PLATFORM_ID = 2;
    private static final int XML_PLATFORM_ID = 3;
    private static final int DEFAULT_PLATFORM_ID = 4;
    private int platformId;
    private String platformName;
    private String platformClassName;

    private DataSource() {
        this.platformClassName = null;
    }

    public DataSource(DatabasePlatform databasePlatform) {
        this.initializeDbDs(databasePlatform);
    }

    public DataSource(String string) {
        this.initializeEisDs(string);
    }

    public static DataSource buildXmlDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.initializeXmlDs();
        return dataSource;
    }

    public static String getClassNameForDatabasePlatform(DatabasePlatform databasePlatform) {
        return databasePlatform.getRuntimePlatformClassName();
    }

    public static String getClassNameForEisPlatform(String string) {
        return EisPlatformManager.instance().getRuntimePlatformClassNameForClass(string);
    }

    public static DataSource buildDefault() {
        DataSource dataSource = new DataSource();
        dataSource.initializeDefaultDs();
        return dataSource;
    }

    public static DataSource buildPreferedDataSourceFor(SCAdapter sCAdapter) {
        String string = sCAdapter.preferences().get("platform.database", "Oracle11");
        DatabasePlatform databasePlatform = DatabasePlatformRepository.getDefault().platformNamed(string);
        return new DataSource(databasePlatform);
    }

    private void initializeDbDs(DatabasePlatform databasePlatform) {
        this.platformId = 1;
        this.platformName = databasePlatform.getName();
        this.platformClassName = databasePlatform.getRuntimePlatformClassName();
    }

    private void initializeEisDs(String string) {
        this.platformId = 2;
        this.platformName = string;
        this.platformClassName = EisPlatformManager.instance().getRuntimePlatformClassNameFor(string);
    }

    private void initializeXmlDs() {
        this.platformId = 3;
        this.platformName = "xml-platform";
        this.platformClassName = "oracle.toplink.ox.platform.SAXPlatform";
    }

    private void initializeDefaultDs() {
        this.platformId = 4;
        this.platformName = "default-platform";
    }

    public boolean isDatabase() {
        return this.platformId == 1;
    }

    public boolean isEis() {
        return this.platformId == 2;
    }

    public boolean isXml() {
        return this.platformId == 3;
    }

    public boolean isDefault() {
        return this.platformId == 4;
    }

    public String getName() {
        return this.platformName;
    }

    public String getPlatformClassName() {
        return this.platformClassName;
    }

    LoginAdapter buildLoginAdapter(DatabaseSessionAdapter databaseSessionAdapter) {
        if (this.isXml()) {
            return new XMLLoginAdapter(databaseSessionAdapter);
        }
        if (this.isDatabase()) {
            return new DatabaseLoginAdapter(databaseSessionAdapter);
        }
        if (this.isEis()) {
            return new EISLoginAdapter(databaseSessionAdapter);
        }
        if (this.isDefault()) {
            return databaseSessionAdapter.buildDefaultLogin();
        }
        throw new IllegalArgumentException(this.platformName);
    }

    public String toString() {
        return this.getName();
    }
}

