/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.property.PropertyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.Property;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.PropertyAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequencingAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoginAdapter
extends SCAdapter
implements Property {
    public static final String PLATFORM_CLASS_PROPERTY = "platformClass";
    public static final String USER_NAME_PROPERTY = "userName";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String TABLE_QUALIFIER_PROPERTY = "tableQualifier";
    public static final String ENCRYPTION_CLASS_PROPERTY = "encryptionClass";
    public static final String EXTERNAL_TRANSACTION_CONTROLLER_PROPERTY = "externalTransactionController";
    public static final String EXTERNAL_CONNECTION_POOLING_PROPERTY = "externalConnectionPooling";
    public static final String DEFAULT_SEQUENCE_PROPERTY = "defaultSequence";
    private volatile SequencingAdapter sequencing;
    public static final String SEQUENCES_COLLECTION = "sequences";
    public static final String SEQUENCE_PREALLOCATION_SIZE_PROPERTY = "sequencePreallocationSize";
    public static final String SEQUENCE_TABLE_PROPERTY = "sequenceTable";
    public static final String SEQUENCE_NAME_FIELD_PROPERTY = "sequenceNameField";
    public static final String SEQUENCE_COUNTER_FIELD_PROPERTY = "sequenceCounterField";
    private volatile Collection properties;
    private Boolean savePassword;
    public static final String SAVE_PASSWORD_PROPERTY = "savePassword";
    private Boolean saveUserName;
    public static final String SAVE_USERNAME_PROPERTY = "saveUsername";

    LoginAdapter(SCAdapter sCAdapter, LoginConfig loginConfig) {
        super(sCAdapter, loginConfig);
    }

    protected LoginAdapter(SCAdapter sCAdapter) {
        super(sCAdapter);
    }

    LoginAdapter() {
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        if (this.sequencing != null) {
            list.add(this.sequencing);
        }
    }

    public SequenceAdapter setDefaultTableSequenceTable() {
        SequenceAdapter sequenceAdapter = this.sequencing.getDefaultSequence();
        SequenceAdapter sequenceAdapter2 = this.sequencing.setDefaultTableSequenceTable("Default", this.getSequencePreallocationSize());
        this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, sequenceAdapter, sequenceAdapter2);
        return sequenceAdapter2;
    }

    public SequenceAdapter setNativeSequencing() {
        SequenceAdapter sequenceAdapter = this.sequencing.getDefaultSequence();
        SequenceAdapter sequenceAdapter2 = this.sequencing.setNativeSequencing("Native", this.getSequencePreallocationSize());
        this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, sequenceAdapter, sequenceAdapter2);
        return sequenceAdapter2;
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
    }

    public void removeSequenceNamed(String string) {
        SequenceAdapter sequenceAdapter = this.sequencing.removeSequenceNamed(string);
        if (sequenceAdapter != null) {
            this.fireItemRemoved(SEQUENCES_COLLECTION, sequenceAdapter);
        }
    }

    public int getSequencePreallocationSize() {
        if (this.getDefaultSequence() == null) {
            return 50;
        }
        return this.sequencing.getDefaultSequencePreallocationSize();
    }

    public void setSequencePreallocationSize(int n) {
        int n2 = this.getSequencePreallocationSize();
        this.sequencing.setDefaultSequencePreallocationSize(n);
        this.firePropertyChanged(SEQUENCE_PREALLOCATION_SIZE_PROPERTY, n2, n);
    }

    public String getSequenceTable() {
        return this.sequencing.getTableSequenceTable();
    }

    public void setSequenceTable(String string) {
        String string2 = this.getSequenceTable();
        this.sequencing.setTableSequenceTable(string);
        this.firePropertyChanged(SEQUENCE_TABLE_PROPERTY, string2, string);
    }

    public String getSequenceNameField() {
        return this.sequencing.getTableSequenceNameField();
    }

    public void setSequenceNameField(String string) {
        String string2 = this.getSequenceNameField();
        this.sequencing.setTableSequenceNameField(string);
        this.firePropertyChanged(SEQUENCE_NAME_FIELD_PROPERTY, string2, string);
    }

    public String getSequenceCounterField() {
        return this.sequencing.getTableSequenceCounterField();
    }

    public void setSequenceCounterField(String string) {
        String string2 = this.getSequenceCounterField();
        this.sequencing.setTableSequenceCounterField(string);
        this.firePropertyChanged(SEQUENCE_COUNTER_FIELD_PROPERTY, string2, string);
    }

    public String getPlatformName() {
        if (this.getPlatformClass() == null) {
            return "Unknown Data Source";
        }
        String string = ClassTools.shortNameForClassNamed((String)this.getPlatformClass());
        string = string.replaceAll("Platform", "");
        return string;
    }

    protected abstract String getDefaultPlatformClassName();

    public String getPlatformClass() {
        return this.loginConfig().getPlatformClass();
    }

    public void setPlatformClass(String string) {
        String string2 = this.loginConfig().getPlatformClass();
        this.loginConfig().setPlatformClass(string);
        this.firePropertyChanged(PLATFORM_CLASS_PROPERTY, string2, string);
    }

    public String getUserName() {
        return this.loginConfig().getUsername();
    }

    public void setUserName(String string) {
        String string2 = this.loginConfig().getUsername();
        this.loginConfig().setUsername(string);
        this.firePropertyChanged(USER_NAME_PROPERTY, string2, string);
    }

    public String getPassword() {
        return this.loginConfig().getPassword();
    }

    public void setPassword(String string) {
        String string2 = this.loginConfig().getPassword();
        this.loginConfig().setPassword(string);
        this.firePropertyChanged(PASSWORD_PROPERTY, string2, string);
    }

    public Boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(Boolean bl) {
        Boolean bl2 = this.isSavePassword();
        this.savePassword = bl;
        this.firePropertyChanged(SAVE_PASSWORD_PROPERTY, bl2, bl);
        if (!this.isSavePassword().booleanValue()) {
            this.setPassword(null);
        }
    }

    public Boolean isSaveUsername() {
        return this.saveUserName;
    }

    public void setSaveUsername(Boolean bl) {
        Boolean bl2 = this.isSaveUsername();
        this.saveUserName = bl;
        this.firePropertyChanged(SAVE_USERNAME_PROPERTY, bl2, bl);
        if (!this.isSaveUsername().booleanValue()) {
            this.setUserName(null);
        }
    }

    public String getTableQualifier() {
        return this.loginConfig().getTableQualifier();
    }

    public void setTableQualifier(String string) {
        String string2 = this.loginConfig().getTableQualifier();
        this.loginConfig().setTableQualifier(string);
        this.firePropertyChanged(TABLE_QUALIFIER_PROPERTY, string2, string);
    }

    public String getEncryptionClass() {
        return this.loginConfig().getEncryptionClass();
    }

    public void setEncryptionClass(String string) {
        String string2 = this.loginConfig().getEncryptionClass();
        this.loginConfig().setEncryptionClass(string);
        this.firePropertyChanged(ENCRYPTION_CLASS_PROPERTY, string2, string);
    }

    public boolean usesExternalConnectionPooling() {
        return this.loginConfig().getExternalConnectionPooling();
    }

    public void setExternalConnectionPooling(boolean bl) {
        boolean bl2 = this.loginConfig().getExternalConnectionPooling();
        this.loginConfig().setExternalConnectionPooling(bl);
        this.firePropertyChanged(EXTERNAL_CONNECTION_POOLING_PROPERTY, bl2, bl);
    }

    public boolean usesExternalTransactionController() {
        return this.loginConfig().getExternalTransactionController();
    }

    public void setUsesExternalTransactionController(boolean bl) {
        boolean bl2 = this.loginConfig().getExternalTransactionController();
        this.loginConfig().setExternalTransactionController(bl);
        this.firePropertyChanged(EXTERNAL_TRANSACTION_CONTROLLER_PROPERTY, bl2, bl);
    }

    public void toString(StringBuffer stringBuffer) {
        String string = this.getPlatformClass();
        if (string == null) {
            stringBuffer.append("no platform");
        } else {
            stringBuffer.append(ClassTools.shortNameForClassNamed((String)string));
        }
    }

    @Override
    protected boolean isACleanConfig() {
        boolean bl = super.isACleanConfig();
        return bl && this.platformClassIsDefault();
    }

    protected boolean platformClassIsDefault() {
        return this.getDefaultPlatformClassName().equals(this.getPlatformClass());
    }

    @Override
    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        if (this.loginConfig().getEncryptedPassword() == null) {
            this.loginConfig().setPassword("");
        } else if (this.loginConfig().getPassword() != null && !this.loginConfig().getPassword().equals("")) {
            this.setSavePassword(Boolean.TRUE);
        }
        if (this.loginConfig().getUsername() != null && !this.loginConfig().getUsername().equals("")) {
            this.setSaveUsername(Boolean.TRUE);
        }
        if (this.loginConfig().getPlatformClass() == null) {
            this.loginConfig().setPlatformClass(this.getDefaultPlatformClassName());
        }
        this.sequencing = this.loginConfig().getSequencingConfig() == null ? this.buildSequencing() : (SequencingAdapter)this.adapt(((LoginConfig)object).getSequencingConfig());
        if (this.loginConfig().getPropertyConfigs() != null) {
            this.properties.addAll(this.adaptAll(this.loginConfig().getPropertyConfigs()));
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.properties = new Vector();
        this.savePassword = Boolean.FALSE;
        this.saveUserName = Boolean.FALSE;
    }

    @Override
    protected void initialize(Object object) {
        super.initialize(object);
        this.sequencing = this.buildSequencing();
    }

    public boolean usesNativeSequencing() {
        return this.sequencing.usesNativeSequencing();
    }

    boolean platformIsRdbms() {
        return false;
    }

    boolean platformIsEis() {
        return false;
    }

    boolean platformIsXml() {
        return false;
    }

    public boolean databaseDriverIsDriverManager() {
        return false;
    }

    public boolean databaseDriverIsDataSource() {
        return false;
    }

    private final LoginConfig loginConfig() {
        return (LoginConfig)this.getModel();
    }

    protected SequencingAdapter getSequencing() {
        return this.sequencing;
    }

    protected SequencingConfig getSequenceConfig() {
        return this.loginConfig().getSequencingConfig();
    }

    @Override
    public Iterator properties() {
        return this.getProperties().iterator();
    }

    @Override
    public int propertySize() {
        return this.getProperties().size();
    }

    private Collection getProperties() {
        return this.properties;
    }

    private Collection getPropertyConfigs() {
        if (this.loginConfig().getPropertyConfigs() == null) {
            this.loginConfig().setPropertyConfigs(new Vector());
        }
        return this.loginConfig().getPropertyConfigs();
    }

    @Override
    public PropertyAdapter addProperty(String string, String string2) {
        PropertyAdapter propertyAdapter = this.buildPropertyAdapter(string, string2);
        this.getPropertyConfigs().add(propertyAdapter.propertyConfig());
        this.addItemToCollection((Object)propertyAdapter, this.getProperties(), "property");
        return propertyAdapter;
    }

    protected SequencingAdapter buildSequencing() {
        SequencingAdapter sequencingAdapter = new SequencingAdapter(this);
        return sequencingAdapter;
    }

    private PropertyAdapter buildPropertyAdapter(String string, String string2) {
        return new PropertyAdapter((SCAdapter)this, this.buildPropertyConfig(string, string2));
    }

    private PropertyConfig buildPropertyConfig(String string, String string2) {
        PropertyConfig propertyConfig = new PropertyConfig();
        propertyConfig.setName(string);
        propertyConfig.setValue(string2);
        return propertyConfig;
    }

    @Override
    public void removeProperty(PropertyAdapter propertyAdapter) {
        this.getPropertyConfigs().remove(propertyAdapter.propertyConfig());
        this.removeItemFromCollection((Object)propertyAdapter, this.getProperties(), "property");
    }

    protected void removeAllProperties() {
        Vector vector = new Vector(this.properties);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.removeProperty((PropertyAdapter)((Object)iterator.next()));
        }
    }

    public boolean sequencingIsDefault() {
        return this.sequencing.isDefault();
    }

    public boolean sequencingIsNative() {
        return this.sequencing.isNative();
    }

    public boolean sequencingIsCustom() {
        return this.sequencing.isCustom();
    }

    public SequenceAdapter getDefaultSequence() {
        return this.sequencing.getDefaultSequence();
    }

    public ListIterator<SequenceAdapter> sequences() {
        return this.sequencing.sequences();
    }

    public SequenceAdapter removeSequence(SequenceAdapter sequenceAdapter) {
        this.sequencing.removeSequence(sequenceAdapter);
        this.fireListChanged(SEQUENCES_COLLECTION);
        return sequenceAdapter;
    }

    public SequenceAdapter addSequence(String string, SequenceType sequenceType) {
        SequenceAdapter sequenceAdapter = this.sequencing.addSequence(string, sequenceType);
        this.fireListChanged(SEQUENCES_COLLECTION);
        return sequenceAdapter;
    }

    public SequenceAdapter createAndSetDefaultSequence(String string, SequenceType sequenceType) {
        SequenceAdapter sequenceAdapter = this.getDefaultSequence();
        SequenceAdapter sequenceAdapter2 = this.sequencing.createAndSetDefaultSequence(string, sequenceType);
        this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, sequenceAdapter, sequenceAdapter2);
        return sequenceAdapter2;
    }

    public int sequencesSize() {
        return this.sequencing.sequencesSize();
    }

    public Iterator<String> sequenceNames() {
        return this.sequencing.sequenceNames();
    }
}

