/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.RootSCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionBrokerAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsProperties;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public final class TopLinkSessionsAdapter
extends RootSCAdapter {
    public static final String VERSION_PROPERTY = "version";
    private Collection sessions;
    public static final String SESSIONS_COLLECTION = "sessions";
    public static final String VERSION_9_0_4 = "9.0.4";
    public static final String VERSION_10g = "10g";
    private Collection managedSessions;
    private static final String CR = System.getProperty("line.separator");

    public TopLinkSessionsAdapter(SCSessionsProperties sCSessionsProperties, Preferences preferences, boolean bl) {
        super(sCSessionsProperties, preferences, bl);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        CollectionTools.addAll((Collection)list, (Iterator)this.sessionBrokers());
        CollectionTools.addAll((Collection)list, (Iterator)this.databaseSessions());
    }

    protected Object buildModel() {
        return new SessionConfigs();
    }

    protected void initialize() {
        super.initialize();
        this.sessions = new Vector();
        this.managedSessions = new Vector();
    }

    protected void initialize(Object object) {
        super.initialize(object);
        this.topLinkSessions().setVersion(Version.getVersion());
    }

    protected void initializeFromModel(Object object) {
        super.initializeFromModel(object);
        this.sessions.addAll(this.adaptAll(this.getSessionConfigs()));
        this.initializeBroker();
    }

    private void initializeBroker() {
        Iterator iterator = this.sessionBrokers();
        while (iterator.hasNext()) {
            SessionBrokerAdapter sessionBrokerAdapter = (SessionBrokerAdapter)iterator.next();
            Iterator iterator2 = sessionBrokerAdapter.sessionNames();
            while (iterator2.hasNext()) {
                sessionBrokerAdapter.internalAddSessionNamed((String)iterator2.next());
            }
        }
    }

    protected void postInitializationFromModel() {
        Iterator iterator = this.allSessions();
        while (iterator.hasNext()) {
            ((SCAdapter)((Object)iterator.next())).postInitializationFromModel();
        }
    }

    protected void preSaving() {
        Iterator iterator = this.allSessions();
        while (iterator.hasNext()) {
            ((SCAdapter)((Object)iterator.next())).preSaving();
        }
    }

    protected void postSaving() {
        Iterator iterator = this.allSessions();
        while (iterator.hasNext()) {
            ((SCAdapter)((Object)iterator.next())).postSaving();
        }
    }

    public String getVersion() {
        return this.topLinkSessions().getVersion();
    }

    void setVersion(String string) {
        String string2 = this.topLinkSessions().getVersion();
        this.topLinkSessions().setVersion(string);
        this.firePropertyChanged(VERSION_PROPERTY, string2, string);
    }

    public Collection getSessionsNames() {
        return this.getSessionsNames(this.sessions());
    }

    public Collection getManagedSessionsNames() {
        return this.getSessionsNames(this.managedSessions());
    }

    public Collection getAllSessionsNames() {
        return this.getSessionsNames(this.allSessions());
    }

    public Collection getDatabaseSessionsNames() {
        return this.getSessionsNames(this.databaseSessions());
    }

    Collection getSessionsNames(Iterator iterator) {
        return CollectionTools.collection((Iterator)new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((SessionAdapter)object).getName();
            }
        });
    }

    Iterator getNames(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ((SessionAdapter)object).getName();
            }
        };
    }

    public Iterator sessionNames() {
        return this.getNames(this.sessions());
    }

    public Iterator managedSessionNames() {
        return this.getNames(this.managedSessions());
    }

    public Iterator databaseSessionNames() {
        return this.getNames(this.databaseSessions());
    }

    public Iterator allSessionNames() {
        return this.getNames(this.allSessions());
    }

    public Iterator sessions() {
        return new CloneIterator(this.sessions);
    }

    public int sessionsSize() {
        return this.sessions.size();
    }

    public Iterator managedSessions() {
        return new CloneIterator(this.managedSessions);
    }

    public Iterator sessionBrokers() {
        return new FilteringIterator(this.sessions()){

            protected boolean accept(Object object) {
                return ((SessionAdapter)object).isBroker();
            }
        };
    }

    public Iterator sessionBrokerNames() {
        return this.getNames(this.sessionBrokers());
    }

    Iterator managedSessions(final SessionBrokerAdapter sessionBrokerAdapter) {
        return new FilteringIterator(this.managedSessions()){

            protected boolean accept(Object object) {
                return ((DatabaseSessionAdapter)object).getBroker() == sessionBrokerAdapter;
            }
        };
    }

    public int managedSessionsSize() {
        return this.managedSessions.size();
    }

    public Iterator databaseSessions() {
        return new FilteringIterator(this.sessions()){

            protected boolean accept(Object object) {
                return !((SessionAdapter)object).isBroker();
            }
        };
    }

    public int databaseSessionsSize() {
        return CollectionTools.collection((Iterator)this.databaseSessions()).size();
    }

    public Iterator allSessions() {
        return new CompositeIterator(this.sessions(), this.managedSessions());
    }

    private Collection getSessionConfigs() {
        return this.topLinkSessions().getSessionConfigs();
    }

    public SessionAdapter sessionNamed(String string) {
        Iterator iterator = this.sessions();
        while (iterator.hasNext()) {
            SessionAdapter sessionAdapter = (SessionAdapter)iterator.next();
            if (!string.equals(sessionAdapter.getName())) continue;
            return sessionAdapter;
        }
        return null;
    }

    public SessionAdapter databaseSessionNamed(String string) {
        SessionAdapter sessionAdapter = this.sessionNamed(string);
        if (sessionAdapter.isBroker()) {
            return null;
        }
        return sessionAdapter;
    }

    public DatabaseSessionAdapter managedSessionNamed(String string) {
        Iterator iterator = this.managedSessions();
        while (iterator.hasNext()) {
            DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)iterator.next();
            if (!string.equals(databaseSessionAdapter.getName())) continue;
            return databaseSessionAdapter;
        }
        return null;
    }

    private SessionAdapter addSession(SessionAdapter sessionAdapter) {
        sessionAdapter.markEntireConfigurationClean();
        this.getSessionConfigs().add(sessionAdapter.getModel());
        this.addItemToCollection(sessionAdapter, this.sessions, SESSIONS_COLLECTION);
        return sessionAdapter;
    }

    public void removeSession(SessionAdapter sessionAdapter) {
        this.getSessionConfigs().remove(sessionAdapter.getModel());
        this.removeItemFromCollection(sessionAdapter, this.sessions, SESSIONS_COLLECTION);
    }

    public void removeSessions(Collection collection) {
        this.getSessionConfigs().removeAll(this.modelObjectsFrom(collection));
        this.removeItemsFromCollection(collection, this.sessions, SESSIONS_COLLECTION);
    }

    public DatabaseSessionAdapter addDatabaseSessionNamed(String string, ServerPlatform serverPlatform, DataSource dataSource) {
        DatabaseSessionAdapter databaseSessionAdapter = new DatabaseSessionAdapter(this, string, serverPlatform, dataSource);
        return (DatabaseSessionAdapter)this.addSession(databaseSessionAdapter);
    }

    public ServerSessionAdapter addServerSessionNamed(String string, ServerPlatform serverPlatform, DataSource dataSource) {
        ServerSessionAdapter serverSessionAdapter = new ServerSessionAdapter(this, string, serverPlatform, dataSource);
        return (ServerSessionAdapter)this.addSession(serverSessionAdapter);
    }

    public SessionBrokerAdapter addSessionBrokerNamed(String string, ServerPlatform serverPlatform) {
        SessionBrokerAdapter sessionBrokerAdapter = new SessionBrokerAdapter(this, string, serverPlatform);
        return (SessionBrokerAdapter)this.addSession(sessionBrokerAdapter);
    }

    public void removeSessionNamed(String string) {
        this.removeSession(this.sessionNamed(string));
    }

    private final SessionConfigs topLinkSessions() {
        return (SessionConfigs)this.getModel();
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append(" [").append(CR);
        Iterator iterator = this.allSessions();
        while (iterator.hasNext()) {
            SessionAdapter sessionAdapter = (SessionAdapter)iterator.next();
            stringBuffer.append("\t\t");
            sessionAdapter.toString(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',').append(CR);
        }
        stringBuffer.append(" ] ");
    }

    DatabaseSessionAdapter addManagedSessionNamed(String string) {
        SessionAdapter sessionAdapter = this.sessionNamed(string);
        if (sessionAdapter == null) {
            throw new NoSuchElementException();
        }
        if (sessionAdapter.isBroker()) {
            throw new IllegalArgumentException(sessionAdapter.toString());
        }
        this.removeItemFromCollection(sessionAdapter, this.sessions, SESSIONS_COLLECTION);
        this.managedSessions.add(sessionAdapter);
        return (DatabaseSessionAdapter)sessionAdapter;
    }

    DatabaseSessionAdapter removeManagedSessionNamed(String string) {
        DatabaseSessionAdapter databaseSessionAdapter = this.managedSessionNamed(string);
        this.managedSessions.remove(databaseSessionAdapter);
        this.addItemToCollection(databaseSessionAdapter, this.sessions, SESSIONS_COLLECTION);
        return databaseSessionAdapter;
    }

    Collection removeManagedSessions(Collection collection) {
        this.managedSessions.removeAll(collection);
        this.addItemsToCollection(collection, this.sessions, SESSIONS_COLLECTION);
        return collection;
    }
}

