/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.tools.SessionCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class BrokerCreationDialog
extends AbstractValidatingDialog {
    private JCheckBox useServerPlatformCheckBox;
    private ComboBoxModel serverPlatformComboBoxModel;
    private String previousServerClassName;
    private JTextField nameTextField;
    private final PropertyValueModel stringHolder;
    private final PropertyValueModel serverPlatformHolder;
    private final CollectionValueModel itemHolder;
    private final ObjectListSelectionModel selectionModel;
    private final Collection sessionBrokerNames;

    BrokerCreationDialog(WorkbenchContext workbenchContext, CollectionValueModel collectionValueModel, ObjectListSelectionModel objectListSelectionModel, PropertyValueModel propertyValueModel, PropertyValueModel propertyValueModel2, Collection collection) {
        super(workbenchContext);
        this.stringHolder = propertyValueModel;
        this.serverPlatformHolder = propertyValueModel2;
        this.itemHolder = collectionValueModel;
        this.selectionModel = objectListSelectionModel;
        this.sessionBrokerNames = collection;
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    private Document buildNameDocumentAdapter() {
        return new DocumentAdapter(this.stringHolder);
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("BROKER_CREATION_DIALOG_TITLE"));
        boolean bl = ((Iterator)this.itemHolder.getValue()).hasNext();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel("BROKER_CREATION_DIALOG_NAME_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField(this.buildNameDocumentAdapter(), null, 20);
        this.nameTextField.getDocument().addDocumentListener(this.buildNameFieldDocumentListener());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.nameTextField);
        JPanel jPanel2 = this.buildServerPlatformPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.helpManager().addTopicID(jPanel2, this.helpTopicId() + ".serverPlatform");
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (bl) {
            this.buildSessionsList(jPanel);
        }
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".name");
        return jPanel;
    }

    private DocumentListener buildNameFieldDocumentListener() {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BrokerCreationDialog.this.updateOKAction();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                BrokerCreationDialog.this.updateOKAction();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    private ComboBoxModel buildServerPlatformComboBoxModel() {
        SimpleCollectionValueModel simpleCollectionValueModel = new SimpleCollectionValueModel(CollectionTools.vector((Iterator)this.serverPlatforms()));
        return new ComboBoxModelAdapter(simpleCollectionValueModel, this.serverPlatformHolder);
    }

    private Iterator serverPlatforms() {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
        String string = NullServerPlatformAdapter.instance().getServerClassName();
        sortedSet.remove(ClassTools.shortNameForClassNamed((String)string));
        return sortedSet.iterator();
    }

    boolean usesServerPlatform() {
        return this.useServerPlatformCheckBox.isSelected();
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                if (!bl) {
                    BrokerCreationDialog.this.previousServerClassName = (String)BrokerCreationDialog.this.serverPlatformComboBoxModel.getSelectedItem();
                    string = NullServerPlatformAdapter.instance().getServerClassName();
                    string = ClassTools.shortNameForClassNamed((String)string);
                } else {
                    if (BrokerCreationDialog.this.previousServerClassName == null) {
                        BrokerCreationDialog.this.previousServerClassName = "WebLogic_10_Platform";
                    }
                    string = BrokerCreationDialog.this.previousServerClassName;
                }
                BrokerCreationDialog.this.serverPlatformComboBoxModel.setSelectedItem(string);
            }
        };
    }

    private JPanel buildServerPlatformPanel() {
        this.useServerPlatformCheckBox = new JCheckBox();
        this.useServerPlatformCheckBox.setText(this.resourceRepository().getString("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setMnemonic(this.resourceRepository().getMnemonic("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        final JPanel jPanel = this.buildServerPlatformSubPane();
        jPanel.setEnabled(false);
        this.useServerPlatformCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                jPanel.setEnabled(jCheckBox.isSelected());
            }
        });
        this.updateServerPlatformWidgets();
        return new GroupBox(this.useServerPlatformCheckBox, (JComponent)jPanel);
    }

    private void updateServerPlatformWidgets() {
        boolean bl;
        String string = (String)this.serverPlatformComboBoxModel.getSelectedItem();
        boolean bl2 = bl = string != null;
        if (bl) {
            ServerPlatformAdapter serverPlatformAdapter = NullServerPlatformAdapter.instance();
            String string2 = ClassTools.shortNameForClassNamed((String)serverPlatformAdapter.getServerClassName());
            bl = !string.equals(string2);
        }
        this.useServerPlatformCheckBox.setSelected(bl);
    }

    private ListCellRenderer buildServerPlatformRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (object == null) {
                    return "";
                }
                return BrokerCreationDialog.this.resourceRepository().getString((String)object);
            }
        };
    }

    private JPanel buildServerPlatformSubPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel("SERVER_PLATFORM_COMBO_BOX", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        pane.add((Component)jLabel, gridBagConstraints);
        this.serverPlatformComboBoxModel = this.buildServerPlatformComboBoxModel();
        JComboBox jComboBox = new JComboBox(this.serverPlatformComboBoxModel);
        jComboBox.setRenderer(this.buildServerPlatformRenderer());
        String string = this.preferences().get("platform.server", null);
        jComboBox.setSelectedItem(string);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add(jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        return pane;
    }

    private void buildSessionsList(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = SwingComponentFactory.buildLabel("BROKER_CREATION_DIALOG_SESSIONS_LIST", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        CheckList checkList = new CheckList(this.itemHolder, (ListSelectionModel)this.selectionModel, this.buildLabelDecorator());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(1, 0, 0, 0);
        jPanel.add((Component)checkList, gridBagConstraints);
        jLabel.setLabelFor(checkList);
    }

    private CellRendererAdapter buildLabelDecorator() {
        return new SessionCellRendererAdapter(this.resourceRepository());
    }

    private void updateOKAction() {
        String string = this.nameTextField.getText().trim();
        boolean bl = string.length() > 0 && !this.sessionBrokerNames.contains(string);
        this.getOKAction().setEnabled(bl);
        if (bl) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("BROKER_CREATION_DIALOG_INVALID_NAME");
        }
    }

    private String buildUniqueSessionBrokerName() {
        String string = this.preferences().get("new name.broker", this.resourceRepository().getString("BROKER_CREATION_DIALOG_NEW_NAME"));
        return NameTools.uniqueNameFor((String)string, (Collection)this.sessionBrokerNames);
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.setText(this.buildUniqueSessionBrokerName());
        this.nameTextField.selectAll();
    }

    protected String helpTopicId() {
        return "dialog.sessionBrokerCreation";
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

