/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class RenameDialog
extends AbstractValidatingDialog {
    private JTextField nameTextField;
    private final Collection sessionNames;
    private final PropertyValueModel stringHolder;

    public RenameDialog(WorkbenchContext workbenchContext, PropertyValueModel propertyValueModel, Collection collection) {
        super(workbenchContext);
        this.stringHolder = propertyValueModel;
        this.sessionNames = collection;
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    private Document buildNameDocumentAdapter() {
        return new DocumentAdapter(this.stringHolder);
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("RENAME_DIALOG_TITLE"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("SESSION_NAME_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SESSION_NAME_LABEL"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("SESSION_NAME_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField(this.buildNameDocumentAdapter(), null, 20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                RenameDialog.this.updateOKAction();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RenameDialog.this.updateOKAction();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        this.helpManager().addTopicID(jPanel, this.helpTopicId() + ".name");
        return jPanel;
    }

    protected String getNewName() {
        return this.nameTextField.getText().trim();
    }

    private void updateOKAction() {
        String string = this.nameTextField.getText().trim();
        boolean bl = string.length() > 0 && !this.sessionNames.contains(string);
        this.getOKAction().setEnabled(bl);
        if (bl) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("SESSION_CREATION_DIALOG_INVALID_NAME");
        }
    }

    protected String helpTopicId() {
        return "dialog.renameSession";
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.selectAll();
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }
}

