/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

public final class SessionCreationDialog
extends AbstractValidatingDialog {
    private JTextField nameTextField;
    private Collection sessionNames;
    private JCheckBox useServerPlatformCheckBox;
    private ComboBoxModel serverPlatformComboBoxModel;
    private String previousServerClassName;
    private JRadioButton serverRadioButton;
    private JRadioButton databaseRadioButton;
    private JRadioButton relationalRadioButton;
    private JRadioButton xmlRadioButton;
    private JRadioButton eisRadioButton;
    private PropertyValueModel databasePlatformHolder;
    private ComboBoxModel j2cAdapterComboBoxModel;

    public SessionCreationDialog(WorkbenchContext workbenchContext, Collection collection) {
        super(workbenchContext);
        this.sessionNames = collection;
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("SESSION_CREATION_DIALOG_TITLE"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = this.buildSessionNamePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.helpManager().addTopicID(jPanel2, this.helpTopicId() + ".name");
        JPanel jPanel3 = this.buildServerPlatformPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.helpManager().addTopicID(jPanel3, this.helpTopicId() + ".serverPlatform");
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = this.buildDataSourcePanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.helpManager().addTopicID(jPanel4, this.helpTopicId() + ".datasource");
        jPanel.add((Component)jPanel4, gridBagConstraints);
        JPanel jPanel5 = this.buildSessionTypePanelPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jPanel5, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildSessionTypePanelPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SESSION_TYPE_LABEL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.serverRadioButton = new JRadioButton();
        this.serverRadioButton.setSelected(true);
        this.serverRadioButton.setText(this.resourceRepository().getString("SERVER_SESSION_RADIO_BUTTON"));
        this.serverRadioButton.setMnemonic(this.resourceRepository().getMnemonic("SERVER_SESSION_RADIO_BUTTON"));
        this.serverRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("SERVER_SESSION_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.serverRadioButton, gridBagConstraints);
        buttonGroup.add(this.serverRadioButton);
        this.databaseRadioButton = new JRadioButton();
        this.databaseRadioButton.setText(this.resourceRepository().getString("DATABASE_SESSION_RADIO_BUTTON"));
        this.databaseRadioButton.setMnemonic(this.resourceRepository().getMnemonic("DATABASE_SESSION_RADIO_BUTTON"));
        this.databaseRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("DATABASE_SESSION_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.databaseRadioButton, gridBagConstraints);
        buttonGroup.add(this.databaseRadioButton);
        return jPanel;
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                if (!bl) {
                    SessionCreationDialog.this.previousServerClassName = (String)SessionCreationDialog.this.serverPlatformComboBoxModel.getSelectedItem();
                    string = NullServerPlatformAdapter.instance().getServerClassName();
                    string = ClassTools.shortNameForClassNamed((String)string);
                } else {
                    if (SessionCreationDialog.this.previousServerClassName == null) {
                        SessionCreationDialog.this.previousServerClassName = "WebLogic_10_Platform";
                    }
                    string = SessionCreationDialog.this.previousServerClassName;
                }
                SessionCreationDialog.this.serverPlatformComboBoxModel.setSelectedItem(string);
            }
        };
    }

    private JPanel buildServerPlatformPanel() {
        this.useServerPlatformCheckBox = new JCheckBox();
        this.useServerPlatformCheckBox.setText(this.resourceRepository().getString("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setMnemonic(this.resourceRepository().getMnemonic("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        final JPanel jPanel = this.buildServerPlatformSubPane();
        jPanel.setEnabled(false);
        this.useServerPlatformCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JCheckBox jCheckBox = (JCheckBox)itemEvent.getSource();
                jPanel.setEnabled(jCheckBox.isSelected());
            }
        });
        this.updateServerPlatformWidgets();
        return new GroupBox(this.useServerPlatformCheckBox, (JComponent)jPanel);
    }

    private void updateServerPlatformWidgets() {
        boolean bl;
        String string = (String)this.serverPlatformComboBoxModel.getSelectedItem();
        boolean bl2 = bl = string != null;
        if (bl) {
            ServerPlatformAdapter serverPlatformAdapter = NullServerPlatformAdapter.instance();
            String string2 = ClassTools.shortNameForClassNamed((String)serverPlatformAdapter.getServerClassName());
            bl = !string.equals(string2);
        }
        this.useServerPlatformCheckBox.setSelected(bl);
    }

    private JPanel buildServerPlatformSubPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Pane pane = new Pane(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel("SERVER_PLATFORM_COMBO_BOX", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 0, 0);
        pane.add((Component)jLabel, gridBagConstraints);
        this.serverPlatformComboBoxModel = this.buildServerPlatformComboBoxModel();
        JComboBox jComboBox = new JComboBox(this.serverPlatformComboBoxModel);
        jComboBox.setRenderer(this.buildServerPlatformRenderer());
        String string = this.preferences().get("platform.server", null);
        if ("NoServerPlatform".equals(string)) {
            jComboBox.setSelectedItem(null);
        } else {
            jComboBox.setSelectedItem(string);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        pane.add(jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        return pane;
    }

    private ListCellRenderer buildServerPlatformRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                if (object == null) {
                    return "";
                }
                return SessionCreationDialog.this.resourceRepository().getString((String)object);
            }
        };
    }

    private JPanel buildSessionNamePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = SwingComponentFactory.buildLabel("SESSION_NAME_LABEL", this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.nameTextField = new JTextField(20);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        jLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                SessionCreationDialog.this.updateOKAction();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                SessionCreationDialog.this.updateOKAction();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                SessionCreationDialog.this.updateOKAction();
            }
        });
        return jPanel;
    }

    private JPanel buildDataSourcePanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = SwingTools.checkBoxIconWidth();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("DATASOURCE_LABEL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.relationalRadioButton = new JRadioButton();
        this.relationalRadioButton.setText(this.resourceRepository().getString("RELATIONAL_RADIO_BUTTON"));
        this.relationalRadioButton.setMnemonic(this.resourceRepository().getMnemonic("RELATIONAL_RADIO_BUTTON"));
        this.relationalRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("RELATIONAL_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.relationalRadioButton, gridBagConstraints);
        buttonGroup.add(this.relationalRadioButton);
        JPanel jPanel2 = this.buildRelationalPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.eisRadioButton = new JRadioButton();
        this.eisRadioButton.setText(this.resourceRepository().getString("EIS_RADIO_BUTTON"));
        this.eisRadioButton.setMnemonic(this.resourceRepository().getMnemonic("EIS_RADIO_BUTTON"));
        this.eisRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("EIS_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.eisRadioButton, gridBagConstraints);
        buttonGroup.add(this.eisRadioButton);
        JPanel jPanel3 = this.buildEisPanel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        this.xmlRadioButton = new JRadioButton();
        this.xmlRadioButton.setText(this.resourceRepository().getString("XML_RADIO_BUTTON"));
        this.xmlRadioButton.setMnemonic(this.resourceRepository().getMnemonic("XML_RADIO_BUTTON"));
        this.xmlRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("XML_RADIO_BUTTON"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)this.xmlRadioButton, gridBagConstraints);
        buttonGroup.add(this.xmlRadioButton);
        this.xmlRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SessionCreationDialog.this.databaseRadioButton.setSelected(true);
                SessionCreationDialog.this.serverRadioButton.setEnabled(!SessionCreationDialog.this.xmlRadioButton.isSelected());
            }
        });
        return jPanel;
    }

    private JPanel buildRelationalPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridBagLayout());
        final JLabel jLabel = SwingComponentFactory.buildLabel("DATABASE_PLATFORM_LABEL", this.resourceRepository());
        jLabel.setEnabled(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        accessibleTitledPanel.add((Component)jLabel, gridBagConstraints);
        String string = this.preferences().get("platform.database", "Oracle11");
        this.databasePlatformHolder = new SimplePropertyValueModel(DatabasePlatformRepository.getDefault().platformNamed(string));
        final JComboBox jComboBox = PlatformComponentFactory.buildPlatformChooser(this.databasePlatformHolder);
        jComboBox.setEnabled(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        accessibleTitledPanel.add((Component)jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        this.relationalRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jComboBox.setEnabled(SessionCreationDialog.this.relationalRadioButton.isSelected());
                jLabel.setEnabled(SessionCreationDialog.this.relationalRadioButton.isSelected());
            }
        });
        return accessibleTitledPanel;
    }

    private JPanel buildEisPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        AccessibleTitledPanel accessibleTitledPanel = new AccessibleTitledPanel(new GridBagLayout());
        final JLabel jLabel = new JLabel(this.resourceRepository().getString("EIS_PLATFORM_LABEL"));
        jLabel.setEnabled(false);
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("EIS_PLATFORM_LABEL"));
        jLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("EIS_PLATFORM_LABEL"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        accessibleTitledPanel.add((Component)jLabel, gridBagConstraints);
        this.j2cAdapterComboBoxModel = this.buildJ2CAdaptersComboBoxModel();
        final JComboBox jComboBox = new JComboBox(this.j2cAdapterComboBoxModel);
        jComboBox.setEnabled(false);
        String string = this.preferences().get("platform.eis", "AQPlatform");
        jComboBox.setSelectedItem(string);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        accessibleTitledPanel.add(jComboBox, gridBagConstraints);
        jLabel.setLabelFor(jComboBox);
        this.eisRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jComboBox.setEnabled(SessionCreationDialog.this.eisRadioButton.isSelected());
                jLabel.setEnabled(SessionCreationDialog.this.eisRadioButton.isSelected());
            }
        });
        return accessibleTitledPanel;
    }

    private void updateOKAction() {
        String string = this.nameTextField.getText().trim();
        boolean bl = string.length() > 0 && !this.sessionNames.contains(string);
        this.getOKAction().setEnabled(bl);
        if (bl) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("SESSION_CREATION_DIALOG_INVALID_NAME");
        }
    }

    private ComboBoxModel buildJ2CAdaptersComboBoxModel() {
        return new DefaultComboBoxModel(CollectionTools.vector((Iterator)this.supportedJ2CAdapters()));
    }

    private ComboBoxModel buildServerPlatformComboBoxModel() {
        return new DefaultComboBoxModel(CollectionTools.vector((Iterator)this.serverPlatforms()));
    }

    private Iterator serverPlatforms() {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
        String string = NullServerPlatformAdapter.instance().getServerClassName();
        sortedSet.remove(ClassTools.shortNameForClassNamed((String)string));
        return sortedSet.iterator();
    }

    public SessionAdapter addNewSessionTo(TopLinkSessionsAdapter topLinkSessionsAdapter) {
        ServerPlatform serverPlatform;
        String string = this.nameTextField.getText().trim();
        DataSource dataSource = this.relationalRadioButton.isSelected() ? new DataSource((DatabasePlatform)this.databasePlatformHolder.getValue()) : (this.eisRadioButton.isSelected() ? new DataSource((String)this.j2cAdapterComboBoxModel.getSelectedItem()) : DataSource.buildXmlDataSource());
        if (this.useServerPlatformCheckBox.isSelected()) {
            serverPlatform = new ServerPlatform((String)this.serverPlatformComboBoxModel.getSelectedItem());
        } else {
            String string2 = NullServerPlatformAdapter.instance().getServerClassName();
            serverPlatform = new ServerPlatform(ClassTools.shortNameForClassNamed((String)string2));
        }
        DatabaseSessionAdapter databaseSessionAdapter = this.serverRadioButton.isSelected() ? topLinkSessionsAdapter.addServerSessionNamed(string, serverPlatform, dataSource) : topLinkSessionsAdapter.addDatabaseSessionNamed(string, serverPlatform, dataSource);
        return databaseSessionAdapter;
    }

    private Iterator supportedJ2CAdapters() {
        SortedSet sortedSet = CollectionTools.sortedSet((Iterator)EisPlatformManager.instance().platformDisplayNames());
        return sortedSet.iterator();
    }

    private String buildUniqueSessionName() {
        String string = this.preferences().get("new name.session", this.resourceRepository().getString("SESSION_CREATION_DIALOG_NEW_SESSION_NAME"));
        return NameTools.uniqueNameFor((String)string, (Collection)this.sessionNames);
    }

    protected String helpTopicId() {
        return "dialog.sessionCreation";
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.setText(this.buildUniqueSessionName());
        this.nameTextField.selectAll();
        String string = this.preferences().get("data source type", "relational");
        this.relationalRadioButton.setSelected("relational".equals(string));
        this.eisRadioButton.setSelected("eis".equals(string));
        this.xmlRadioButton.setSelected("xml".equals(string));
    }
}

