/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionProjectlPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.ProjectTypeEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;

final class SessionProjectPane
extends AbstractSessionProjectlPane {
    SessionProjectPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    private ActionListener buildEditAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SessionProjectPane.this.edit();
            }
        };
    }

    protected JButton buildEditButton() {
        JButton jButton = this.buildButton("SESSION_PROJECT_EDIT_BUTTON");
        jButton.addActionListener(this.buildEditAction());
        return jButton;
    }

    protected PropertyValueModel buildPrimaryProjectNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "primaryProject"){

            protected Object getValueFromSubject() {
                DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject;
                return databaseSessionAdapter.getPrimaryProjectName();
            }
        };
    }

    protected JTextField buildPrimaryProjectTextField(Document document) {
        JTextField jTextField = super.buildPrimaryProjectTextField(document);
        jTextField.setEditable(false);
        return jTextField;
    }

    private void edit() {
        DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject();
        ProjectType projectType = new ProjectType(databaseSessionAdapter);
        ProjectTypeEditDialog projectTypeEditDialog = new ProjectTypeEditDialog(this.getWorkbenchContext(), this.resourceRepository().getString("PROJECT_TYPE_EDIT_DIALOG_TITLE_EDIT"), databaseSessionAdapter, projectType, "dialog.session.projectType");
        projectTypeEditDialog.setVisible(true);
    }

    private static class ProjectType
    extends AbstractModel
    implements ProjectTypeEditDialog.ProjectTypeUpdater {
        private DatabaseSessionAdapter databaseSession;
        private String projectName;
        private boolean projectTypeXml;
        public static final String PROJECT_CLASS_PROPERTY = "ProjectClass";
        public static final String PROJECT_TYPE_XML_PROPERTY = "projectTypeXml";
        public static final String PROJECT_XML_PROPERTY = "ProjectXml";

        public ProjectType(DatabaseSessionAdapter databaseSessionAdapter) {
            this.initialize(databaseSessionAdapter);
        }

        public void apply(boolean bl, String string) {
            if (bl) {
                this.databaseSession.addPrimaryProjectXmlNamed(string);
            } else {
                this.databaseSession.addPrimaryProjectClassNamed(string);
            }
        }

        public String getProjectName() {
            return this.projectName;
        }

        private void initialize(DatabaseSessionAdapter databaseSessionAdapter) {
            this.databaseSession = databaseSessionAdapter;
            this.projectTypeXml = databaseSessionAdapter.isPrimaryProjectXml();
            this.projectName = databaseSessionAdapter.getPrimaryProjectName();
        }

        public boolean isProjectXml() {
            return this.projectTypeXml;
        }
    }
}

