/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DefaultSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NativeSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.UnaryTableSequenceAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.AbstractLoginPropertiesPage;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.DefaultSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.NativeSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.NewSequenceDialog;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.TableSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.login.UnaryTableSequencePropertyPane;
import org.eclipse.persistence.tools.workbench.uitools.SwitcherPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CompositeCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.NullTransformer;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class SequencingPropertiesPage
extends AbstractLoginPropertiesPage {
    private DefaultSequencePropertyPane defaultSequencePane;
    private NativeSequencePropertyPane nativeSequencePane;
    private TableSequencePropertyPane tableSequencePane;
    private UnaryTableSequencePropertyPane unaryTableSequencePane;
    public static String CUSTOM_TABLE_SEQUENCE = "CustomTableSequence";
    public static String DEFAULT_TABLE_SEQUENCE = "DefaultTableSequence";
    public static String NATIVE_TABLE_SEQUENCE = "NativeTableSequence";

    public SequencingPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        AddRemoveListPanel addRemoveListPanel = this.buildSequenceListPane();
        PropertyValueModel propertyValueModel = addRemoveListPanel.getSelectedItemHolder();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        jPanel.add((Component)addRemoveListPanel, gridBagConstraints);
        this.defaultSequencePane = this.buildDefaultSequencePane(propertyValueModel);
        this.nativeSequencePane = this.buildNativeSequencePane(propertyValueModel);
        this.tableSequencePane = this.buildTableSequencePane(propertyValueModel);
        this.unaryTableSequencePane = this.buildUnaryTableSequencePane(propertyValueModel);
        SwitcherPanel switcherPanel = new SwitcherPanel(propertyValueModel, this.buildSequencePaneTransformer());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        jPanel.add((Component)switcherPanel, gridBagConstraints);
        this.addHelpTopicId(jPanel, "session.login.sequencing");
        return jPanel;
    }

    private Transformer buildSequencePaneTransformer() {
        return new Transformer(){

            public Component transform(Object object) {
                if (object == null) {
                    return null;
                }
                if (((SequenceAdapter)object).getType() == SequenceType.DEFAULT) {
                    return SequencingPropertiesPage.this.defaultSequencePane;
                }
                if (((SequenceAdapter)object).getType() == SequenceType.NATIVE) {
                    return SequencingPropertiesPage.this.nativeSequencePane;
                }
                if (((SequenceAdapter)object).getType() == SequenceType.TABLE) {
                    return SequencingPropertiesPage.this.tableSequencePane;
                }
                if (((SequenceAdapter)object).getType() == SequenceType.UNARY_TABLE) {
                    return SequencingPropertiesPage.this.unaryTableSequencePane;
                }
                return null;
            }
        };
    }

    private ValueModel buildTableSequenceHolder(ValueModel valueModel) {
        return new TransformationValueModel(valueModel){

            protected TableSequenceAdapter transformNonNull(Object object) {
                return ((SequenceAdapter)object).getType() == SequenceType.TABLE ? (TableSequenceAdapter)object : null;
            }
        };
    }

    private TableSequencePropertyPane buildTableSequencePane(ValueModel valueModel) {
        return new TableSequencePropertyPane(this.buildTableSequenceHolder(valueModel), this.getWorkbenchContextHolder());
    }

    private ValueModel buildUnaryTableSequenceHolder(ValueModel valueModel) {
        return new TransformationValueModel(valueModel){

            protected UnaryTableSequenceAdapter transformNonNull(Object object) {
                return ((SequenceAdapter)object).getType() == SequenceType.UNARY_TABLE ? (UnaryTableSequenceAdapter)object : null;
            }
        };
    }

    private UnaryTableSequencePropertyPane buildUnaryTableSequencePane(ValueModel valueModel) {
        return new UnaryTableSequencePropertyPane(this.buildUnaryTableSequenceHolder(valueModel), this.getWorkbenchContextHolder());
    }

    private ValueModel buildNativeSequenceHolder(ValueModel valueModel) {
        return new TransformationValueModel(valueModel){

            protected NativeSequenceAdapter transformNonNull(Object object) {
                return ((SequenceAdapter)object).getType() == SequenceType.NATIVE ? (NativeSequenceAdapter)object : null;
            }
        };
    }

    private NativeSequencePropertyPane buildNativeSequencePane(ValueModel valueModel) {
        return new NativeSequencePropertyPane(this.buildNativeSequenceHolder(valueModel), this.getWorkbenchContextHolder());
    }

    private ValueModel buildDefaultSequenceHolder(ValueModel valueModel) {
        return new TransformationValueModel(valueModel){

            protected DefaultSequenceAdapter transformNonNull(Object object) {
                return ((SequenceAdapter)object).getType() == SequenceType.DEFAULT ? (DefaultSequenceAdapter)object : null;
            }
        };
    }

    private DefaultSequencePropertyPane buildDefaultSequencePane(ValueModel valueModel) {
        return new DefaultSequencePropertyPane(this.buildDefaultSequenceHolder(valueModel), this.getWorkbenchContextHolder());
    }

    private AddRemoveListPanel buildSequenceListPane() {
        AddRemoveListPanel addRemoveListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildSequenceListAdapter(), this.buildSortedSequenceListHolder()){

            protected void updateRemoveButton(JButton jButton) {
                SequenceAdapter sequenceAdapter = (SequenceAdapter)this.getSelectionModel().getSelectedValue();
                jButton.setEnabled(sequenceAdapter != null && this.getSelectedValues().length == 1 && !sequenceAdapter.isTheDefaultSequence());
            }
        };
        addRemoveListPanel.setCellRenderer(this.buildSequenceListRenderer());
        return addRemoveListPanel;
    }

    private ListCellRenderer buildSequenceListRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(JList jList, Object object, int n, boolean bl, boolean bl2) {
                boolean bl3;
                SequenceAdapter sequenceAdapter = (SequenceAdapter)object;
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl4 = bl3 = !StringTools.stringIsEmpty((String)sequenceAdapter.getName());
                if (bl3) {
                    stringBuilder.append(sequenceAdapter.getName());
                } else if (!sequenceAdapter.isTheDefaultSequence()) {
                    stringBuilder.append(SequencingPropertiesPage.this.resourceRepository().getString("SEQUENCING_PANE_SEQUENCE_NO_NAME", n));
                } else {
                    stringBuilder.append(SequencingPropertiesPage.this.resourceRepository().getString("SEQUENCING_PANE_DEFAULT_SEQUENCE_TEXT"));
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("SEQUENCING_PANE_SEQUENCE_TYPE_");
                stringBuilder2.append(sequenceAdapter.getType().name());
                stringBuilder.append(' ');
                stringBuilder.append('(');
                stringBuilder.append(SequencingPropertiesPage.this.resourceRepository().getString(stringBuilder2.toString()));
                stringBuilder.append(')');
                if (bl3 && sequenceAdapter.isTheDefaultSequence()) {
                    stringBuilder.append(' ');
                    stringBuilder.append(SequencingPropertiesPage.this.resourceRepository().getString("SEQUENCING_PANE_DEFAULT_SEQUENCE_TEXT"));
                }
                return stringBuilder.toString();
            }
        };
    }

    private CollectionValueModel buildAllSequenceCollectionHolder() {
        SimpleCollectionValueModel simpleCollectionValueModel = new SimpleCollectionValueModel();
        simpleCollectionValueModel.addItem(this.buildSequenceCollectionHolder());
        simpleCollectionValueModel.addItem(this.buildDefaultSequenceCollectionHolder());
        return new CompositeCollectionValueModel(simpleCollectionValueModel, NullTransformer.instance());
    }

    private CollectionValueModel buildDefaultSequenceCollectionHolder() {
        return new PropertyCollectionValueModelAdapter(this.buildDefaultCollectionHolder());
    }

    private PropertyValueModel buildDefaultCollectionHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "defaultSequence"){

            protected SequenceAdapter getValueFromSubject() {
                return ((LoginAdapter)this.subject).getDefaultSequence();
            }
        };
    }

    private CollectionValueModel buildSequenceCollectionHolder() {
        return new ListCollectionValueModelAdapter(this.buildSequenceListHolder());
    }

    private ListValueModel buildSequenceListHolder() {
        return new ListAspectAdapter(this.getSelectionHolder(), "sequences"){

            protected ListIterator getValueFromSubject() {
                return ((LoginAdapter)this.subject).sequences();
            }

            protected int sizeFromSubject() {
                return ((LoginAdapter)this.subject).sequencesSize();
            }
        };
    }

    private ListValueModel buildSortedSequenceListHolder() {
        return new SortedListValueModelAdapter(this.buildAllSequenceCollectionHolder());
    }

    private LoginAdapter login() {
        return (LoginAdapter)this.selection();
    }

    private void editSequence(ObjectListSelectionModel objectListSelectionModel) {
        SequenceAdapter sequenceAdapter = (SequenceAdapter)objectListSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTextFieldDescription(this.resourceRepository().getString("SEQUENCING_PANE_EDIT_SEQUENCE_DIALOG_LABEL"));
        builder.setTitle(this.resourceRepository().getString("SEQUENCING_PANE_EDIT_SEQUENCE_DIALOG_TITLE"));
        builder.setHelpTopicId("dialog.sequence");
        builder.setExistingNames(this.login().sequenceNames());
        builder.setOriginalName(sequenceAdapter.getName());
        builder.setOriginalNameIsLegal(false);
        builder.setEmptyNameIsLegal(sequenceAdapter.isDefault());
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasConfirmed()) {
            String string = newNameDialog.getNewName().trim();
            sequenceAdapter.setName(string);
            objectListSelectionModel.setSelectedValue(sequenceAdapter);
        }
    }

    private void addSequence(ObjectListSelectionModel objectListSelectionModel) {
        NewSequenceDialog.NewSequenceBuilder newSequenceBuilder = new NewSequenceDialog.NewSequenceBuilder(this.resourceRepository());
        newSequenceBuilder.addExistingNames(this.login().sequenceNames());
        NewSequenceDialog newSequenceDialog = newSequenceBuilder.buildDialog(this.getWorkbenchContext());
        newSequenceDialog.show();
        if (newSequenceDialog.wasConfirmed()) {
            NewSequenceDialog.SequenceStateObject sequenceStateObject = (NewSequenceDialog.SequenceStateObject)newSequenceDialog.subject();
            SequenceAdapter sequenceAdapter = sequenceStateObject.isDefaultSequence() ? this.login().createAndSetDefaultSequence(sequenceStateObject.getName(), sequenceStateObject.getSequenceType()) : this.login().addSequence(sequenceStateObject.getName(), sequenceStateObject.getSequenceType());
            objectListSelectionModel.setSelectedValue(sequenceAdapter);
        }
    }

    private AddRemovePanel.Adapter buildSequenceListAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                SequencingPropertiesPage.this.addSequence(objectListSelectionModel);
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public String optionalButtonKey() {
                return "SEQUENCING_PANE_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                SequencingPropertiesPage.this.editSequence(objectListSelectionModel);
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                for (Object object : objectListSelectionModel.getSelectedValues()) {
                    SequencingPropertiesPage.this.login().removeSequence((SequenceAdapter)object);
                }
            }
        };
    }
}

