/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public class ComponentEnabler {
    private PropertyChangeListener booleanChangeListener;
    ValueModel booleanHolder;
    private Collection components;
    private boolean defaultValue;

    private ComponentEnabler() {
        this.initialize();
    }

    public ComponentEnabler(ValueModel valueModel, Component component) {
        this(valueModel, component, false);
    }

    public ComponentEnabler(ValueModel valueModel, Component component, boolean bl) {
        this(valueModel, new Component[]{component}, false);
    }

    public ComponentEnabler(ValueModel valueModel, Collection collection) {
        this(valueModel, collection, false);
    }

    public ComponentEnabler(ValueModel valueModel, Collection collection, boolean bl) {
        this();
        this.initialize(valueModel, collection, bl);
    }

    public ComponentEnabler(ValueModel valueModel, Component[] componentArray) {
        this(valueModel, CollectionTools.collection((Object[])componentArray), false);
    }

    public ComponentEnabler(ValueModel valueModel, Component[] componentArray, boolean bl) {
        this();
        this.initialize(valueModel, CollectionTools.collection((Object[])componentArray), bl);
    }

    public ComponentEnabler(ValueModel valueModel, Iterator iterator) {
        this(valueModel, CollectionTools.collection((Iterator)iterator), false);
    }

    public ComponentEnabler(ValueModel valueModel, Iterator iterator, boolean bl) {
        this();
        this.initialize(valueModel, CollectionTools.collection((Iterator)iterator), bl);
    }

    protected boolean booleanValue(Boolean bl) {
        return bl == null ? this.defaultValue : bl;
    }

    protected PropertyChangeListener buildBooleanChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ComponentEnabler.this.updateEnableState(ComponentEnabler.this.booleanValue((Boolean)ComponentEnabler.this.booleanHolder.getValue()));
            }

            public String toString() {
                return "boolean change listener";
            }
        };
    }

    protected Iterator components() {
        return this.components.iterator();
    }

    protected void initialize() {
        this.booleanChangeListener = this.buildBooleanChangeListener();
    }

    protected void initialize(ValueModel valueModel, Collection collection, boolean bl) {
        if (valueModel == null || collection == null) {
            throw new NullPointerException();
        }
        this.components = collection;
        this.defaultValue = bl;
        this.booleanHolder = valueModel;
        valueModel.addPropertyChangeListener("value", this.booleanChangeListener);
        this.updateEnableState(this.booleanValue((Boolean)valueModel.getValue()));
    }

    protected void updateEnableState(boolean bl) {
        Iterator iterator = this.components();
        while (iterator.hasNext()) {
            ((Component)iterator.next()).setEnabled(bl);
        }
    }
}

