/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.string.SimpleStringMatcher;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;
import org.eclipse.persistence.tools.workbench.utility.string.StringMatcher;

public class FilteringListPanel
extends JPanel {
    private Object[] completeList;
    StringConverter stringConverter;
    private JTextField textField;
    private JLabel textFieldLabel;
    private DocumentListener textFieldListener;
    private JList listBox;
    private JLabel listBoxLabel;
    private int maxListSize;
    private StringMatcher stringMatcher;
    private Object[] buffer;
    private static final Border TEXT_FIELD_LABEL_BORDER = BorderFactory.createEmptyBorder(0, 0, 5, 0);
    private static final Border LIST_BOX_LABEL_BORDER = BorderFactory.createEmptyBorder(5, 0, 5, 0);

    public FilteringListPanel(Object[] objectArray, Object object) {
        this(objectArray, object, StringConverter.DEFAULT_INSTANCE);
    }

    public FilteringListPanel(Object[] objectArray, Object object, StringConverter stringConverter) {
        super(new BorderLayout());
        this.completeList = objectArray;
        this.stringConverter = stringConverter;
        this.initialize(object);
    }

    private void initialize(Object object) {
        this.maxListSize = this.defaultMaxListSize();
        this.buffer = new Object[this.max()];
        this.textFieldListener = this.buildTextFieldListener();
        this.stringMatcher = this.buildStringMatcher();
        this.initializeLayout(object);
    }

    private int max() {
        if (this.maxListSize == -1) {
            return this.completeList.length;
        }
        return Math.min(this.maxListSize, this.completeList.length);
    }

    private DocumentListener buildTextFieldListener() {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                FilteringListPanel.this.filterList();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                FilteringListPanel.this.filterList();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FilteringListPanel.this.filterList();
            }

            public String toString() {
                return "text field listener";
            }
        };
    }

    private int defaultMaxListSize() {
        return -1;
    }

    private StringMatcher buildStringMatcher() {
        return new SimpleStringMatcher();
    }

    private void initializeLayout(Object object) {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.textFieldLabel = new JLabel();
        this.textFieldLabel.setBorder(TEXT_FIELD_LABEL_BORDER);
        jPanel.add((Component)this.textFieldLabel, "North");
        this.textField = new JTextField();
        this.textField.getDocument().addDocumentListener(this.textFieldListener);
        this.textFieldLabel.setLabelFor(this.textField);
        jPanel.add((Component)this.textField, "Center");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.listBoxLabel = new JLabel();
        this.listBoxLabel.setBorder(LIST_BOX_LABEL_BORDER);
        jPanel2.add((Component)this.listBoxLabel, "North");
        this.listBox = new JList();
        this.listBox.setDoubleBuffered(true);
        this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.max()));
        this.listBox.getSelectionModel().setSelectionMode(0);
        this.listBox.setPrototypeCellValue(this.prototypeCellValue());
        this.listBox.setPrototypeCellValue(null);
        this.listBox.setCellRenderer(this.buildDefaultCellRenderer());
        this.listBoxLabel.setLabelFor(this.listBox);
        JScrollPane jScrollPane = new JScrollPane(this.listBox);
        jScrollPane.getHorizontalScrollBar().setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jPanel2.add((Component)jScrollPane, "Center");
        this.listBox.setSelectedValue(object, true);
        this.textField.select(0, this.textField.getText().length());
        this.add((Component)jPanel2, "Center");
    }

    public Object getSelection() {
        return this.listBox.getSelectedValue();
    }

    public void setSelection(Object object) {
        this.listBox.setSelectedValue(object, true);
    }

    public Object[] getCompleteList() {
        return this.completeList;
    }

    public void setCompleteList(Object[] objectArray) {
        this.completeList = objectArray;
        if (this.buffer.length < this.max()) {
            this.buffer = new Object[this.max()];
        }
        this.filterList();
    }

    public int getMaxListSize() {
        return this.maxListSize;
    }

    public void setMaxListSize(int n) {
        this.maxListSize = n;
        if (this.buffer.length < this.max()) {
            this.buffer = new Object[this.max()];
        }
        this.filterList();
    }

    public StringConverter getStringConverter() {
        return this.stringConverter;
    }

    public void setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
        this.filterList();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JLabel getTextFieldLabel() {
        return this.textFieldLabel;
    }

    public void setTextFieldLabelText(String string) {
        this.textFieldLabel.setText(string);
    }

    public JList getListBox() {
        return this.listBox;
    }

    public void setListBoxCellRenderer(ListCellRenderer listCellRenderer) {
        this.listBox.setCellRenderer(listCellRenderer);
    }

    public JLabel getListBoxLabel() {
        return this.listBoxLabel;
    }

    public void setListBoxLabelText(String string) {
        this.listBoxLabel.setText(string);
    }

    public void setComponentsFont(Font font) {
        this.textFieldLabel.setFont(font);
        this.textField.setFont(font);
        this.listBoxLabel.setFont(font);
        this.listBox.setFont(font);
    }

    public StringMatcher getStringMatcher() {
        return this.stringMatcher;
    }

    public void setStringMatcher(StringMatcher stringMatcher) {
        this.stringMatcher = stringMatcher;
        this.filterList();
    }

    protected String prototypeCellValue() {
        return "==========> A_STRING_THAT_IS_DEFINITELY_LONGER_THAN_EVERY_STRING_IN_THE_LIST <==========";
    }

    protected ListCellRenderer buildDefaultCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object object) {
                return FilteringListPanel.this.stringConverter.convertToString(object);
            }
        };
    }

    synchronized void filterList() {
        this.filterList(this.textField.getText());
    }

    private void filterList(String string) {
        if (string.length() == 0) {
            this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.max()));
        } else {
            this.stringMatcher.setPatternString(string);
            int n = 0;
            int n2 = this.completeList.length;
            int n3 = this.max();
            for (int i = 0; i < n2; ++i) {
                if (this.stringMatcher.matches(this.stringConverter.convertToString(this.completeList[i]))) {
                    this.buffer[n++] = this.completeList[i];
                }
                if (n == n3) break;
            }
            this.listBox.setModel(this.buildPartialArrayListModel(this.buffer, n));
        }
        if (this.listBox.getModel().getSize() == 0) {
            this.listBox.getSelectionModel().clearSelection();
        } else {
            this.listBox.getSelectionModel().setAnchorSelectionIndex(0);
            this.listBox.getSelectionModel().setLeadSelectionIndex(0);
            this.listBox.ensureIndexIsVisible(0);
        }
    }

    private ListModel buildPartialArrayListModel(final Object[] objectArray, final int n) {
        return new AbstractListModel(){

            public int getSize() {
                return n;
            }

            public Object getElementAt(int n2) {
                return objectArray[n2];
            }
        };
    }
}

