/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModelWrapper;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Transformer;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class CompositeCollectionValueModel
extends CollectionValueModelWrapper {
    private Transformer transformer;
    private IdentityHashMap components;
    private IdentityHashMap collections;
    private CollectionChangeListener componentListener;
    private int size;
    private static final Transformer DISABLED_TRANSFORMER = new Transformer(){

        public Object transform(Object object) {
            throw new IllegalStateException("CompositeCollectionValueModel.transform(Object) was not implemented.");
        }

        public String toString() {
            return "Disabled Transformer";
        }
    };

    public CompositeCollectionValueModel(CollectionValueModel collectionValueModel) {
        this(collectionValueModel, DISABLED_TRANSFORMER);
    }

    public CompositeCollectionValueModel(CollectionValueModel collectionValueModel, Transformer transformer) {
        super(collectionValueModel);
        this.transformer = transformer;
    }

    public CompositeCollectionValueModel(ListValueModel listValueModel) {
        this(new ListCollectionValueModelAdapter(listValueModel));
    }

    public CompositeCollectionValueModel(ListValueModel listValueModel, Transformer transformer) {
        this(new ListCollectionValueModelAdapter(listValueModel), transformer);
    }

    protected void initialize() {
        super.initialize();
        this.components = new IdentityHashMap();
        this.collections = new IdentityHashMap();
        this.componentListener = this.buildComponentListener();
        this.size = 0;
    }

    protected CollectionChangeListener buildComponentListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                CompositeCollectionValueModel.this.componentItemsAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                CompositeCollectionValueModel.this.componentItemsRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                CompositeCollectionValueModel.this.componentCollectionChanged(collectionChangeEvent);
            }

            public String toString() {
                return "component listener";
            }
        };
    }

    public Object getValue() {
        return new CompositeIterator(this.buildCollectionsIterators());
    }

    protected Iterator buildCollectionsIterators() {
        return new TransformationIterator(this.collections.values().iterator()){

            protected Object transform(Object object) {
                return ((ArrayList)object).iterator();
            }
        };
    }

    public int size() {
        return this.size;
    }

    protected void engageModel() {
        super.engageModel();
        this.addComponentSources((Iterator)this.collectionHolder.getValue());
    }

    protected void disengageModel() {
        super.disengageModel();
        Iterator iterator = this.components.values().iterator();
        while (iterator.hasNext()) {
            ((CollectionValueModel)iterator.next()).removeCollectionChangeListener("value", this.componentListener);
        }
        this.components.clear();
        this.collections.clear();
        this.size = 0;
    }

    protected void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.addComponentSources(collectionChangeEvent.items());
    }

    protected void addComponentSources(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addComponentSource(iterator.next());
        }
    }

    protected void addComponentSource(Object object) {
        CollectionValueModel collectionValueModel = this.transform(object);
        if (this.components.put(object, collectionValueModel) != null) {
            throw new IllegalStateException("duplicate component: " + object);
        }
        collectionValueModel.addCollectionChangeListener("value", this.componentListener);
        ArrayList arrayList = new ArrayList(collectionValueModel.size());
        if (this.collections.put(collectionValueModel, arrayList) != null) {
            throw new IllegalStateException("duplicate collection: " + object);
        }
        this.addComponentItems(collectionValueModel, arrayList);
    }

    protected void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.removeComponentSources(collectionChangeEvent.items());
    }

    protected void removeComponentSources(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeComponentSource(iterator.next());
        }
    }

    protected void removeComponentSource(Object object) {
        CollectionValueModel collectionValueModel = (CollectionValueModel)this.components.remove(object);
        if (collectionValueModel == null) {
            throw new IllegalStateException("missing component: " + object);
        }
        collectionValueModel.removeCollectionChangeListener("value", this.componentListener);
        ArrayList arrayList = (ArrayList)this.collections.remove(collectionValueModel);
        if (arrayList == null) {
            throw new IllegalStateException("missing collection: " + object);
        }
        this.clearComponentItems(arrayList);
    }

    protected void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
        this.removeComponentSources(new ArrayList(this.components.keySet()).iterator());
        this.addComponentSources((Iterator)this.collectionHolder.getValue());
    }

    protected ArrayList getComponentCollection(CollectionValueModel collectionValueModel) {
        return (ArrayList)this.collections.get(collectionValueModel);
    }

    protected CollectionValueModel transform(Object object) {
        return (CollectionValueModel)this.transformer.transform(object);
    }

    protected void componentItemsAdded(CollectionChangeEvent collectionChangeEvent) {
        this.addComponentItems(collectionChangeEvent.items(), collectionChangeEvent.size(), (CollectionValueModel)collectionChangeEvent.getSource());
    }

    protected void addComponentItems(Iterator iterator, int n, CollectionValueModel collectionValueModel) {
        this.addComponentItems(iterator, n, this.getComponentCollection(collectionValueModel));
    }

    protected void addComponentItems(CollectionValueModel collectionValueModel, ArrayList arrayList) {
        this.addComponentItems((Iterator)collectionValueModel.getValue(), collectionValueModel.size(), arrayList);
    }

    protected void addComponentItems(Iterator iterator, int n, ArrayList arrayList) {
        this.size += n;
        arrayList.ensureCapacity(arrayList.size() + n);
        this.addItemsToCollection(iterator, arrayList, "value");
    }

    protected void componentItemsRemoved(CollectionChangeEvent collectionChangeEvent) {
        this.removeComponentItems(collectionChangeEvent.items(), collectionChangeEvent.size(), (CollectionValueModel)collectionChangeEvent.getSource());
    }

    protected void removeComponentItems(Iterator iterator, int n, CollectionValueModel collectionValueModel) {
        this.removeComponentItems(iterator, n, this.getComponentCollection(collectionValueModel));
    }

    protected void clearComponentItems(ArrayList arrayList) {
        this.removeComponentItems(((ArrayList)arrayList.clone()).iterator(), arrayList.size(), arrayList);
    }

    protected void removeComponentItems(Iterator iterator, int n, ArrayList arrayList) {
        this.size -= n;
        this.removeItemsFromCollection(iterator, arrayList, "value");
    }

    protected void componentCollectionChanged(CollectionChangeEvent collectionChangeEvent) {
        CollectionValueModel collectionValueModel = (CollectionValueModel)collectionChangeEvent.getSource();
        ArrayList arrayList = this.getComponentCollection(collectionValueModel);
        this.clearComponentItems(arrayList);
        this.addComponentItems(collectionValueModel, arrayList);
    }
}

