/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;

public abstract class PropertyValueModelWrapper
extends AbstractModel
implements PropertyValueModel {
    protected PropertyValueModel valueHolder;
    protected PropertyChangeListener valueChangeListener;

    protected PropertyValueModelWrapper(PropertyValueModel propertyValueModel) {
        if (propertyValueModel == null) {
            throw new NullPointerException();
        }
        this.valueHolder = propertyValueModel;
    }

    protected void initialize() {
        super.initialize();
        this.valueChangeListener = this.buildValueChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected PropertyChangeListener buildValueChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PropertyValueModelWrapper.this.valueChanged(propertyChangeEvent);
            }

            public String toString() {
                return "value change listener";
            }
        };
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.engageValueHolder();
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(propertyChangeListener);
        if (this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        super.removePropertyChangeListener(string, propertyChangeListener);
        if (string == "value" && this.hasNoPropertyChangeListeners("value")) {
            this.disengageValueHolder();
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueChangeListener);
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueChangeListener);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.valueHolder);
    }

    protected abstract void valueChanged(PropertyChangeEvent var1);
}

