/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListCollectionValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Range;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;

public class SortedListValueModelAdapter
extends CollectionListValueModelAdapter {
    protected Comparator comparator;

    public SortedListValueModelAdapter(CollectionValueModel collectionValueModel, Comparator comparator) {
        super(collectionValueModel);
        this.comparator = comparator;
    }

    public SortedListValueModelAdapter(CollectionValueModel collectionValueModel) {
        this(collectionValueModel, null);
    }

    public SortedListValueModelAdapter(ListValueModel listValueModel, Comparator comparator) {
        this(new ListCollectionValueModelAdapter(listValueModel), comparator);
    }

    public SortedListValueModelAdapter(ListValueModel listValueModel) {
        this(listValueModel, null);
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.sortList();
    }

    protected void postBuildList() {
        super.postBuildList();
        Collections.sort(this.list, this.comparator);
    }

    protected void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
        super.itemsAdded(collectionChangeEvent);
        this.sortList();
    }

    protected void sortList() {
        ArrayList arrayList = (ArrayList)this.list.clone();
        Collections.sort(this.list, this.comparator);
        Range range = CollectionTools.identityDiffRange((List)arrayList, (List)this.list);
        if (range.size > 0) {
            List list = arrayList.subList(range.start, range.end + 1);
            List list2 = this.list.subList(range.start, range.end + 1);
            this.fireItemsReplaced("value", range.start, list2, list);
        }
    }
}

