/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.adapters;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class PreferencesCollectionValueModel
extends AspectAdapter
implements CollectionValueModel {
    protected Map preferences;
    protected PreferenceChangeListener preferenceChangeListener;

    public PreferencesCollectionValueModel(Preferences preferences) {
        super(preferences);
    }

    public PreferencesCollectionValueModel(ValueModel valueModel) {
        super(valueModel);
    }

    protected void initialize() {
        super.initialize();
        this.preferences = new HashMap();
        this.preferenceChangeListener = this.buildPreferenceChangeListener();
    }

    protected PreferenceChangeListener buildPreferenceChangeListener() {
        return new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                PreferencesCollectionValueModel.this.preferenceChanged(preferenceChangeEvent.getKey(), preferenceChangeEvent.getNewValue());
            }

            public String toString() {
                return "preference change listener";
            }
        };
    }

    public synchronized Object getValue() {
        return this.preferences.values().iterator();
    }

    public void addItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addItem(iterator.next());
        }
    }

    public void removeItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeItem(iterator.next());
        }
    }

    public synchronized int size() {
        return this.preferences.size();
    }

    protected boolean hasListeners() {
        return this.hasAnyCollectionChangeListeners("value");
    }

    protected void fireAspectChange(Object object, Object object2) {
        this.fireCollectionChanged("value");
    }

    protected void engageNonNullSubject() {
        ((Preferences)this.subject).addPreferenceChangeListener(this.preferenceChangeListener);
        Iterator iterator = this.preferenceModels();
        while (iterator.hasNext()) {
            PreferencePropertyValueModel preferencePropertyValueModel = (PreferencePropertyValueModel)iterator.next();
            this.preferences.put(preferencePropertyValueModel.getKey(), preferencePropertyValueModel);
        }
    }

    protected void disengageNonNullSubject() {
        block2: {
            try {
                ((Preferences)this.subject).removePreferenceChangeListener(this.preferenceChangeListener);
            }
            catch (IllegalStateException illegalStateException) {
                if (illegalStateException.getMessage().equals("Node has been removed.")) break block2;
                throw illegalStateException;
            }
        }
        this.preferences.clear();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.subject);
    }

    protected Iterator preferenceModels() {
        Object[] objectArray;
        try {
            objectArray = ((Preferences)this.subject).keys();
        }
        catch (BackingStoreException backingStoreException) {
            throw new RuntimeException(backingStoreException);
        }
        return new TransformationIterator((Iterator)new ArrayIterator(objectArray)){

            protected Object transform(Object object) {
                return PreferencesCollectionValueModel.this.buildPreferenceModel((String)object);
            }
        };
    }

    protected PreferencePropertyValueModel buildPreferenceModel(String string) {
        return new PreferencePropertyValueModel(this.subjectHolder, string);
    }

    protected synchronized void preferenceChanged(String string, String string2) {
        if (string2 == null) {
            PreferencePropertyValueModel preferencePropertyValueModel = (PreferencePropertyValueModel)this.preferences.remove(string);
            this.fireItemRemoved("value", preferencePropertyValueModel);
        } else if (!this.preferences.containsKey(string)) {
            PreferencePropertyValueModel preferencePropertyValueModel = this.buildPreferenceModel(string);
            this.preferences.put(string, preferencePropertyValueModel);
            this.fireItemAdded("value", preferencePropertyValueModel);
        }
    }
}

