/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public abstract class PrimitiveListTreeModel
extends DefaultTreeModel {
    private ListValueModel listHolder;
    private ListChangeListener listChangeListener;

    private PrimitiveListTreeModel() {
        super(new DefaultMutableTreeNode(null, true));
        this.initialize();
    }

    public PrimitiveListTreeModel(ListValueModel listValueModel) {
        this();
        if (listValueModel == null) {
            throw new NullPointerException();
        }
        this.listHolder = listValueModel;
    }

    private void initialize() {
        this.listChangeListener = new PrimitiveListChangeListener();
    }

    protected abstract void primitiveChanged(int var1, Object var2);

    public void valueForPathChanged(TreePath treePath, Object object) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        int n = ((TreeNode)this.getRoot()).getIndex(treeNode);
        this.primitiveChanged(n, object);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.addListChangeListener("value", this.listChangeListener);
            this.synchronizeList();
        }
        super.addTreeModelListener(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        super.removeTreeModelListener(treeModelListener);
        if (this.getTreeModelListeners().length == 0) {
            this.listHolder.removeListChangeListener("value", this.listChangeListener);
        }
    }

    void synchronizeList() {
        this.clearList();
        this.buildList();
    }

    private void clearList() {
        int n = this.root.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(i));
        }
    }

    private void buildList() {
        Iterator iterator = (Iterator)this.listHolder.getValue();
        while (iterator.hasNext()) {
            this.addPrimitive(iterator.next());
        }
    }

    private void addPrimitive(Object object) {
        this.insertPrimitive(this.root.getChildCount(), object);
    }

    void insertPrimitive(int n, Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object, false);
        this.insertNodeInto(defaultMutableTreeNode, (MutableTreeNode)this.root, n);
    }

    void removeNode(int n) {
        this.removeNodeFromParent((MutableTreeNode)this.root.getChildAt(n));
    }

    void replacePrimitive(int n, Object object) {
        MutableTreeNode mutableTreeNode = (MutableTreeNode)this.root.getChildAt(n);
        mutableTreeNode.setUserObject(object);
        this.nodeChanged(mutableTreeNode);
    }

    private class PrimitiveListChangeListener
    implements ListChangeListener {
        private PrimitiveListChangeListener() {
        }

        public void itemsAdded(ListChangeEvent listChangeEvent) {
            int n = listChangeEvent.getIndex();
            ListIterator listIterator = listChangeEvent.items();
            while (listIterator.hasNext()) {
                PrimitiveListTreeModel.this.insertPrimitive(n++, listIterator.next());
            }
        }

        public void itemsRemoved(ListChangeEvent listChangeEvent) {
            for (int i = 0; i < listChangeEvent.size(); ++i) {
                PrimitiveListTreeModel.this.removeNode(listChangeEvent.getIndex());
            }
        }

        public void itemsReplaced(ListChangeEvent listChangeEvent) {
            int n = listChangeEvent.getIndex();
            ListIterator listIterator = listChangeEvent.items();
            while (listIterator.hasNext()) {
                PrimitiveListTreeModel.this.replacePrimitive(n++, listIterator.next());
            }
        }

        public void listChanged(ListChangeEvent listChangeEvent) {
            PrimitiveListTreeModel.this.synchronizeList();
        }
    }
}

