/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.cell;

import java.awt.Color;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.cell.LabeledTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.cell.TreeCellEditorAdapter;

public class SpinnerTreeCellRenderer
extends LabeledTreeCellRenderer
implements TreeCellEditorAdapter.Renderer {
    protected TreeCellEditorAdapter.ImmediateEditListener immediateEditListener;

    public SpinnerTreeCellRenderer(String string, Icon icon) {
        super(string, icon);
    }

    public SpinnerTreeCellRenderer(String string) {
        super(string);
    }

    public SpinnerTreeCellRenderer(Icon icon) {
        super(icon);
    }

    public SpinnerTreeCellRenderer() {
    }

    public SpinnerTreeCellRenderer(String string, SpinnerModel spinnerModel) {
        this(string);
        this.setModel(spinnerModel);
    }

    public SpinnerTreeCellRenderer(SpinnerModel spinnerModel) {
        this();
        this.setModel(spinnerModel);
    }

    protected JComponent buildComponent() {
        JSpinner jSpinner = new JSpinner();
        jSpinner.addChangeListener(this.buildChangeListener());
        return jSpinner;
    }

    private ChangeListener buildChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SpinnerTreeCellRenderer.this.immediateEditListener != null) {
                    SpinnerTreeCellRenderer.this.immediateEditListener.immediateEdit();
                }
            }
        };
    }

    protected JSpinner getSpinner() {
        return (JSpinner)this.component;
    }

    protected JComponent editor() {
        JComponent jComponent = this.getSpinner().getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            jComponent = ((JSpinner.DefaultEditor)jComponent).getTextField();
        }
        return jComponent;
    }

    protected void setForeground(Color color) {
        super.setForeground(color);
        this.editor().setForeground(color);
    }

    protected void setBackground(Color color) {
        super.setBackground(color);
        this.editor().setBackground(color);
    }

    protected void setValue(Object object) {
        this.getSpinner().setValue(object);
    }

    public Object getValue() {
        return this.getSpinner().getValue();
    }

    public void setImmediateEditListener(TreeCellEditorAdapter.ImmediateEditListener immediateEditListener) {
        this.immediateEditListener = immediateEditListener;
    }

    public void setModel(SpinnerModel spinnerModel) {
        this.getSpinner().setModel(spinnerModel);
    }

    protected void addActionListener(ActionListener actionListener) {
        JComponent jComponent = this.editor();
        if (!(jComponent instanceof JTextField)) {
            throw new UnsupportedOperationException(jComponent.getClass().getName());
        }
        ((JTextField)jComponent).addActionListener(actionListener);
    }
}

