/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.swing.CompositeIcon;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public class TriStateCheckBox
extends JCheckBox {
    private Icon checkIcon;
    public static TriStateBoolean PARTIALLY_SELECTED = TriStateBoolean.UNDEFINED;
    public static TriStateBoolean SELECTED = TriStateBoolean.TRUE;
    public static TriStateBoolean UNSELECTED = TriStateBoolean.FALSE;

    public TriStateCheckBox() {
        this((String)null);
    }

    public TriStateCheckBox(String string) {
        this(string, UNSELECTED);
    }

    public TriStateCheckBox(String string, Icon icon, TriStateBoolean triStateBoolean) {
        super(string, icon);
        this.initialize(triStateBoolean);
    }

    public TriStateCheckBox(String string, TriStateBoolean triStateBoolean) {
        this(string, null, triStateBoolean);
    }

    public TriStateBoolean getState() {
        return this.getTriStateModel().getState();
    }

    public TriStateButtonModel getTriStateModel() {
        return (TriStateButtonModel)super.getModel();
    }

    protected void initialize(TriStateBoolean triStateBoolean) {
        this.setOpaque(false);
        this.setModel(new TriStateButtonModel(this.getModel()));
        this.setState(triStateBoolean);
    }

    public boolean isPartiallySelected() {
        return this.getTriStateModel().isPartiallySelected();
    }

    public void setIcon(Icon icon) {
        this.setSecondaryIcon(icon);
    }

    public void setSecondaryIcon(Icon icon) {
        if (icon == null) {
            super.setIcon(this.checkIcon);
        } else {
            super.setIcon(new CompositeIcon(this.checkIcon, icon));
        }
    }

    public void setSelected(boolean bl) {
        this.setState(bl ? SELECTED : UNSELECTED);
    }

    public void setState(TriStateBoolean triStateBoolean) {
        this.getTriStateModel().setState(triStateBoolean);
    }

    public static class TriStateButtonModel
    implements ButtonModel {
        private final ButtonModel delegate;
        private TriStateBoolean selectionState;

        public TriStateButtonModel(ButtonModel buttonModel) {
            this.delegate = buttonModel;
            this.selectionState = TriStateBoolean.valueOf((boolean)buttonModel.isSelected());
        }

        public void addActionListener(ActionListener actionListener) {
            this.delegate.addActionListener(actionListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.delegate.addChangeListener(changeListener);
        }

        public void addItemListener(ItemListener itemListener) {
            this.delegate.addItemListener(itemListener);
        }

        public String getActionCommand() {
            return this.delegate.getActionCommand();
        }

        protected final ButtonModel getDelegate() {
            return this.delegate;
        }

        public int getMnemonic() {
            return this.delegate.getMnemonic();
        }

        public Object[] getSelectedObjects() {
            return this.delegate.getSelectedObjects();
        }

        protected TriStateBoolean getState() {
            return this.selectionState;
        }

        public boolean isArmed() {
            return this.delegate.isArmed();
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public boolean isPartiallySelected() {
            return this.getState() == PARTIALLY_SELECTED;
        }

        public boolean isPressed() {
            return this.delegate.isPressed();
        }

        public boolean isRollover() {
            return this.delegate.isRollover();
        }

        public boolean isSelected() {
            return this.delegate.isSelected();
        }

        protected void nextState() {
            TriStateBoolean triStateBoolean = this.getState();
            if (triStateBoolean == UNSELECTED) {
                this.setState(SELECTED);
            } else if (triStateBoolean == SELECTED) {
                this.setState(PARTIALLY_SELECTED);
            } else if (triStateBoolean == PARTIALLY_SELECTED) {
                this.setState(UNSELECTED);
            }
        }

        public void removeActionListener(ActionListener actionListener) {
            this.delegate.removeActionListener(actionListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.delegate.removeChangeListener(changeListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.delegate.removeItemListener(itemListener);
        }

        public void setActionCommand(String string) {
            this.delegate.setActionCommand(string);
        }

        public void setArmed(boolean bl) {
            this.delegate.setArmed(bl);
        }

        public void setEnabled(boolean bl) {
            this.delegate.setEnabled(bl);
        }

        public void setGroup(ButtonGroup buttonGroup) {
            this.delegate.setGroup(buttonGroup);
        }

        public void setMnemonic(int n) {
            this.delegate.setMnemonic(n);
        }

        public void setPressed(boolean bl) {
            if (this.isPressed() != bl && this.isEnabled()) {
                if (!bl && this.isArmed()) {
                    this.nextState();
                }
                boolean bl2 = this.isSelected();
                this.delegate.setPressed(bl);
                this.delegate.setSelected(bl2);
            }
        }

        public void setRollover(boolean bl) {
            this.delegate.setRollover(bl);
        }

        public void setSelected(boolean bl) {
            this.delegate.setSelected(bl);
        }

        protected void setState(TriStateBoolean triStateBoolean) {
            if (triStateBoolean == null) {
                triStateBoolean = PARTIALLY_SELECTED;
            }
            this.selectionState = triStateBoolean;
            if (triStateBoolean == PARTIALLY_SELECTED) {
                this.delegate.setSelected(false);
            } else {
                this.delegate.setSelected(triStateBoolean.booleanValue());
            }
        }
    }
}

