/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence.osgi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.osgi.ProviderTrackerCustomizer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
PersistenceProviderResolver {
    public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
    private BundleContext ctx;
    private ServiceTracker serviceTracker;
    private Map<String, PersistenceProvider> providers;

    public void start(BundleContext bundleContext) throws Exception {
        this.log("Persistence bundle starting...");
        this.ctx = bundleContext;
        ProviderTrackerCustomizer providerTrackerCustomizer = new ProviderTrackerCustomizer(this);
        this.serviceTracker = new ServiceTracker(this.ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)providerTrackerCustomizer);
        this.serviceTracker.open();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
        this.providers = new HashMap<String, PersistenceProvider>();
        ServiceReference[] serviceReferenceArray = null;
        try {
            serviceReferenceArray = this.ctx.getServiceReferences(PERSISTENCE_PROVIDER, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (serviceReferenceArray != null) {
            for (ServiceReference serviceReference : serviceReferenceArray) {
                this.addProvider(serviceReference);
            }
        }
        this.log("Persistence bundle started.");
    }

    PersistenceProvider addProvider(ServiceReference serviceReference) {
        PersistenceProvider persistenceProvider = (PersistenceProvider)this.ctx.getService(serviceReference);
        String string = this.getProviderName(serviceReference);
        this.providers.put(string, persistenceProvider);
        return persistenceProvider;
    }

    protected void removeProvider(ServiceReference serviceReference) {
        String string = this.getProviderName(serviceReference);
        this.providers.remove(string);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.log("Persistence bundle stopping...");
        this.serviceTracker.close();
        this.serviceTracker = null;
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(null);
        this.log("Persistence bundle stopped.");
    }

    public String getProviderName(ServiceReference serviceReference) {
        String string = (String)serviceReference.getProperty(PERSISTENCE_PROVIDER);
        if (string == null) {
            string = "PersistenceProvider-" + serviceReference.hashCode();
        }
        return string;
    }

    protected Map<String, PersistenceProvider> getProviders() {
        return this.providers;
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        return new ArrayList<PersistenceProvider>(this.getProviders().values());
    }

    private void log(String string) {
        System.out.println(string);
    }
}

