/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.LegacyProjectReadCallback;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsio.legacy.LegacyIOFacade;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.DefaultSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.SimpleSPIManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classfile.CFExternalClassRepositoryFactory;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;
import org.w3c.dom.Document;

class ProjectReader {
    private ProjectIOManager ioManager;
    private File file;
    private Preferences preferences;
    private FileNotFoundListener listener;
    private LegacyProjectReadCallback legacyProjectReadCallback;
    private Document document;
    private String schemaVersion;
    private static final String PROJECT_ROOT_ELEMENT_NAME_4_X = "BldrProject";
    private static final String SCHEMA_VERSION_ELEMENT_NAME_5_0 = "schemaVersion";
    private static final String SCHEMA_VERSION_ELEMENT_NAME_4_X = "version";
    private static final String SCHEMA_VERSION_7_0 = "7.0";
    private static final String SCHEMA_VERSION_6_0 = "6.0";
    private static final String SCHEMA_VERSION_5_X = "5";
    private static final String SCHEMA_VERSION_4_5 = "4.5";
    private static final String PRODUCT_VERSION_4_6 = "4.6";
    private static final String PRODUCT_VERSION_9_0_3 = "9.0.3";

    ProjectReader(ProjectIOManager projectIOManager, File file, Preferences preferences, FileNotFoundListener fileNotFoundListener, LegacyProjectReadCallback legacyProjectReadCallback) {
        this.ioManager = projectIOManager;
        this.file = file;
        this.preferences = preferences;
        this.listener = fileNotFoundListener;
        this.legacyProjectReadCallback = legacyProjectReadCallback;
    }

    MWProject read() {
        this.document = XMLTools.parse(this.file);
        this.schemaVersion = this.schemaVersion();
        if (this.schemaVersion.equals(SCHEMA_VERSION_7_0)) {
            return this.readProject();
        }
        return this.readLegacyProject();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.file);
    }

    private String schemaVersion() {
        org.w3c.dom.Node node = this.rootNode();
        org.w3c.dom.Node node2 = XMLTools.child(node, "schema-version");
        if (node2 == null) {
            node2 = XMLTools.child(node, SCHEMA_VERSION_ELEMENT_NAME_5_0);
        }
        if (node2 == null) {
            node2 = XMLTools.child(node, SCHEMA_VERSION_ELEMENT_NAME_4_X);
        }
        if (node2 == null) {
            throw new IllegalArgumentException();
        }
        return XMLTools.textContent(node2);
    }

    private org.w3c.dom.Node rootNode() {
        org.w3c.dom.Node node = XMLTools.child(this.document, "project");
        if (node == null) {
            node = XMLTools.child(this.document, PROJECT_ROOT_ELEMENT_NAME_4_X);
        }
        if (node == null) {
            throw new IllegalArgumentException();
        }
        return node;
    }

    private MWProject readProject() {
        MWProject mWProject;
        try {
            mWProject = (MWProject)this.readObject(this.file);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        ClassTools.invokeMethod((Object)mWProject, "setSaveDirectoryForIOManager", File.class, this.baseDirectory());
        this.injectSPIManager(mWProject, new DefaultSPIManager(this.preferences, mWProject.getName()));
        SubComponentReader[] subComponentReaderArray = this.buildSubComponentReaders(mWProject);
        for (int i = 0; i < subComponentReaderArray.length; ++i) {
            subComponentReaderArray[i].read();
        }
        mWProject.postProjectBuild();
        return mWProject;
    }

    private SubComponentReader[] buildSubComponentReaders(MWProject mWProject) {
        return new SubComponentReader[]{new SubComponentReader(mWProject.getClassRepository()), new SubComponentReader(mWProject.getMetaDataSubComponentContainer()), new SubComponentReader(mWProject.getDescriptorRepository())};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object readObject(File file) throws IOException {
        InputStream inputStream = null;
        Object object = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file));
            object = this.ioManager.getUnmarshaller().unmarshal(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return object;
    }

    File baseDirectory() {
        return this.file.getParentFile();
    }

    String defaultFileNameExtension() {
        return this.ioManager.defaultFileNameExtension();
    }

    String subDirectoryNameFor(Object object) {
        return this.ioManager.subDirectoryNameFor(object);
    }

    void fireFileNotFound(File file) {
        this.ioManager.fireFileNotFound(this.listener, file);
    }

    private void injectSPIManager(MWProject mWProject, SPIManager sPIManager) {
        ClassTools.invokeMethod((Object)mWProject, "setSPIManagerForIOManager", SPIManager.class, sPIManager);
    }

    private MWProject readLegacyProject() {
        if (!this.schemaVersion.startsWith(SCHEMA_VERSION_6_0)) {
            throw new IllegalStateException(this.schemaVersion);
        }
        this.legacyProjectReadCallback.checkLegacyRead(this.schemaVersion);
        MWProject mWProject = LegacyIOFacade.read60Project(this.file, this.preferences);
        mWProject.markEntireBranchDirty();
        mWProject.setIsLegacyProject(true);
        return mWProject;
    }

    private SPIManager buildSimpleSPIManager() {
        SimpleSPIManager simpleSPIManager = new SimpleSPIManager();
        simpleSPIManager.setExternalClassRepositoryFactory(CFExternalClassRepositoryFactory.instance());
        return simpleSPIManager;
    }

    private class SubComponentReader {
        private ProjectSubFileComponentContainer container;

        SubComponentReader(ProjectSubFileComponentContainer projectSubFileComponentContainer) {
            this.container = projectSubFileComponentContainer;
        }

        void read() {
            String string = ProjectReader.this.defaultFileNameExtension();
            String string2 = ProjectReader.this.subDirectoryNameFor(this.container);
            File file = new File(this.baseDirectory(), string2);
            Set set = CollectionTools.set(this.container.originalProjectSubFileComponentNames());
            Vector<MWModel> vector = new Vector<MWModel>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = FileTools.FILE_NAME_ENCODER.encode(string3);
                File file2 = new File(file, string4 + string);
                MWModel mWModel = (MWModel)this.readObject(file2);
                if (mWModel == null) {
                    ProjectReader.this.fireFileNotFound(file2);
                    iterator.remove();
                    continue;
                }
                mWModel.setParent((Node)((Object)this.container));
                vector.add(mWModel);
            }
            this.container.setProjectSubFileComponents(vector);
        }

        private File baseDirectory() {
            return ProjectReader.this.baseDirectory();
        }

        private Object readObject(File file) {
            try {
                return ProjectReader.this.readObject(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }
}

