/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.db;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKeyColumnPair;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWColumnPair
extends MWModel {
    private MWColumnHandle sourceColumnHandle;
    public static final String SOURCE_COLUMN_PROPERTY = "sourceColumn";
    private MWColumnHandle targetColumnHandle;
    public static final String TARGET_COLUMN_PROPERTY = "targetColumn";

    private MWColumnPair() {
    }

    MWColumnPair(MWReference mWReference, MWColumn mWColumn, MWColumn mWColumn2) {
        super(mWReference);
        this.sourceColumnHandle.setColumn(mWColumn);
        this.targetColumnHandle.setColumn(mWColumn2);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.sourceColumnHandle = new MWColumnHandle(this, this.buildSourceColumnScrubber());
        this.targetColumnHandle = new MWColumnHandle(this, this.buildTargetColumnScrubber());
    }

    public MWReference getReference() {
        return (MWReference)this.getParent();
    }

    public MWColumn getSourceColumn() {
        return this.sourceColumnHandle.getColumn();
    }

    public void setSourceColumn(MWColumn mWColumn) {
        if (mWColumn != null && mWColumn.getTable() != this.getReference().getSourceTable()) {
            throw new IllegalArgumentException();
        }
        MWColumn mWColumn2 = this.sourceColumnHandle.getColumn();
        this.sourceColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(SOURCE_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public MWColumn getTargetColumn() {
        return this.targetColumnHandle.getColumn();
    }

    public void setTargetColumn(MWColumn mWColumn) {
        if (mWColumn != null && mWColumn.getTable() != this.getReference().getTargetTable()) {
            throw new IllegalArgumentException();
        }
        MWColumn mWColumn2 = this.targetColumnHandle.getColumn();
        this.targetColumnHandle.setColumn(mWColumn);
        this.firePropertyChanged(TARGET_COLUMN_PROPERTY, mWColumn2, mWColumn);
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer(200);
        this.appendColumn(stringBuffer, this.getSourceColumn());
        stringBuffer.append('=');
        this.appendColumn(stringBuffer, this.getTargetColumn());
        return stringBuffer.toString();
    }

    private void appendColumn(StringBuffer stringBuffer, MWColumn mWColumn) {
        if (mWColumn != null) {
            stringBuffer.append(mWColumn.qualifiedName());
        }
    }

    boolean pairs(MWColumn mWColumn, MWColumn mWColumn2) {
        return this.getSourceColumn() == mWColumn && this.getTargetColumn() == mWColumn2;
    }

    public MWTable sourceTable() {
        return this.tableFrom(this.getSourceColumn());
    }

    public MWTable targetTable() {
        return this.tableFrom(this.getTargetColumn());
    }

    private MWTable tableFrom(MWColumn mWColumn) {
        return mWColumn == null ? null : mWColumn.getTable();
    }

    public void setSourceAndTargetColumns(MWColumn mWColumn, MWColumn mWColumn2) {
        this.setSourceColumn(mWColumn);
        this.setTargetColumn(mWColumn2);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.getSourceColumn() == null || this.getTargetColumn() == null) {
            list.add(this.buildProblem("0704", this.getReference().getName()));
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.sourceColumnHandle);
        list.add(this.targetColumnHandle);
    }

    private MWHandle.NodeReferenceScrubber buildSourceColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWColumnPair.this.setSourceColumn(null);
            }

            public String toString() {
                return "MWColumnPair.buildSourceColumnScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildTargetColumnScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWColumnPair.this.setTargetColumn(null);
            }

            public String toString() {
                return "MWColumnPair.buildTargetColumnScrubber()";
            }
        };
    }

    boolean matches(ExternalForeignKeyColumnPair externalForeignKeyColumnPair) {
        return this.getSourceColumn() == this.sourceColumn(externalForeignKeyColumnPair) && this.getTargetColumn() == this.targetColumn(externalForeignKeyColumnPair);
    }

    private MWColumn sourceColumn(ExternalForeignKeyColumnPair externalForeignKeyColumnPair) {
        return this.getReference().sourceColumn(externalForeignKeyColumnPair);
    }

    private MWColumn targetColumn(ExternalForeignKeyColumnPair externalForeignKeyColumnPair) {
        return this.getReference().targetColumn(externalForeignKeyColumnPair);
    }

    void configureRuntimeConstraint(ForeignKeyConstraint foreignKeyConstraint) {
        if (this.getSourceColumn() == null || this.getTargetColumn() == null) {
            return;
        }
        foreignKeyConstraint.addSourceField(this.getSourceColumn().getName());
        foreignKeyConstraint.addTargetField(this.getTargetColumn().getName());
    }

    public String displayString() {
        return this.getName();
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        this.printColumnNameOn(this.getSourceColumn(), stringBuffer);
        stringBuffer.append("=>");
        this.printColumnNameOn(this.getTargetColumn(), stringBuffer);
    }

    private void printColumnNameOn(MWColumn mWColumn, StringBuffer stringBuffer) {
        stringBuffer.append(mWColumn == null ? "null" : mWColumn.getName());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWColumnPair.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("sourceColumnHandle");
        xMLCompositeObjectMapping.setGetMethodName("getSourceColumnHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setSourceColumnHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping.setXPath("source-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName("targetColumnHandle");
        xMLCompositeObjectMapping2.setGetMethodName("getTargetColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setTargetColumnHandleForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWColumnHandle.class);
        xMLCompositeObjectMapping2.setXPath("target-column-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWColumnHandle getSourceColumnHandleForTopLink() {
        return this.sourceColumnHandle.getColumn() == null ? null : this.sourceColumnHandle;
    }

    private void setSourceColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildSourceColumnScrubber();
        this.sourceColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWColumnHandle getTargetColumnHandleForTopLink() {
        return this.targetColumnHandle.getColumn() == null ? null : this.targetColumnHandle;
    }

    private void setTargetColumnHandleForTopLink(MWColumnHandle mWColumnHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildTargetColumnScrubber();
        this.targetColumnHandle = mWColumnHandle == null ? new MWColumnHandle(this, nodeReferenceScrubber) : mWColumnHandle.setScrubber(nodeReferenceScrubber);
    }
}

