/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyAdditionException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAdvancedPropertyRemovalException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorAfterLoadingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorCopyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorEventsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorInstantiationPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWLockingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWInterfaceDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWAttributeHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTransformationMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class MWMappingDescriptor
extends MWDescriptor {
    private Collection mappings;
    public static final String MAPPINGS_COLLECTION = "mappings";
    private Collection inheritedAttributeHandles;
    public static final String INHERITED_ATTRIBUTES_COLLECTION = "inheritedAttributes";
    private MWHandle.NodeReferenceScrubber inheritedAttributeScrubber;
    private volatile MWInheritancePolicy inheritancePolicy;
    public static final String INHERITANCE_POLICY_PROPERTY = "inheritancePolicy";
    private volatile MWDescriptorPolicy copyPolicy;
    public static final String COPY_POLICY_PROPERTY = "copyPolicy";
    private volatile MWDescriptorPolicy eventsPolicy;
    public static final String EVENTS_POLICY_PROPERTY = "eventsPolicy";
    private volatile MWDescriptorPolicy afterLoadingPolicy;
    public static final String AFTER_LOADING_POLICY_PROPERTY = "afterLoadingPolicy";
    private volatile MWDescriptorPolicy instantiationPolicy;
    public static final String INSTANTIATION_POLICY_PROPERTY = "instantiationPolicy";

    protected MWMappingDescriptor() {
    }

    protected MWMappingDescriptor(MWProject mWProject, MWClass mWClass, String string) {
        super(mWProject, mWClass, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.mappings = new Vector();
        this.inheritedAttributeHandles = new Vector();
        this.inheritancePolicy = new MWNullInheritancePolicy(this);
        this.copyPolicy = new MWNullDescriptorPolicy(this);
        this.eventsPolicy = new MWNullDescriptorPolicy(this);
        this.afterLoadingPolicy = new MWNullDescriptorPolicy(this);
        this.instantiationPolicy = new MWNullDescriptorPolicy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.mappings;
        synchronized (collection) {
            list.addAll(this.mappings);
        }
        collection = this.inheritedAttributeHandles;
        synchronized (collection) {
            list.addAll(this.inheritedAttributeHandles);
        }
        list.add(this.inheritancePolicy);
        list.add(this.copyPolicy);
        list.add(this.eventsPolicy);
        list.add(this.afterLoadingPolicy);
        list.add(this.instantiationPolicy);
    }

    private MWHandle.NodeReferenceScrubber inheritedAttributeScrubber() {
        if (this.inheritedAttributeScrubber == null) {
            this.inheritedAttributeScrubber = this.buildInheritedAttributeScrubber();
        }
        return this.inheritedAttributeScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildInheritedAttributeScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWMappingDescriptor.this.removeInheritedAttributeHandle((MWAttributeHandle)mWHandle);
            }

            public String toString() {
                return "MWMappingDescriptor.buildInheritedAttributeScrubber()";
            }
        };
    }

    public MWClassRefreshPolicy buildMWClassRefreshPolicy() {
        return DefaultMWClassRefreshPolicy.instance();
    }

    protected MWDescriptorPolicy buildLockingPolicy() {
        return new MWNullDescriptorPolicy(this);
    }

    public boolean isReferencedBy(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((MWMappingDescriptor)iterator.next()).mappings();
            while (iterator2.hasNext()) {
                MWMapping mWMapping = (MWMapping)iterator2.next();
                if (!mWMapping.isReferenceMapping() || ((MWReferenceMapping)((Object)mWMapping)).getReferenceDescriptor() != this) continue;
                return true;
            }
        }
        return false;
    }

    public void addUnknownPrimaryKeyMapping(MWClassAttribute mWClassAttribute) {
        this.addDirectMapping(mWClassAttribute).setUsesMethodAccessing(false);
    }

    public MWQueryManager getQueryManager() {
        return this.getTransactionalPolicy().getQueryManager();
    }

    public MWCachingPolicy getCachingPolicy() {
        return this.getTransactionalPolicy().getCachingPolicy();
    }

    private void setCopyPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.copyPolicy;
        this.copyPolicy = mWDescriptorPolicy;
        this.firePropertyChanged(COPY_POLICY_PROPERTY, mWDescriptorPolicy2, this.copyPolicy);
    }

    public MWDescriptorPolicy getCopyPolicy() {
        return this.copyPolicy;
    }

    public void addCopyPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.copyPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(COPY_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setCopyPolicy(new MWDescriptorCopyPolicy(this));
    }

    public void removeCopyPolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.copyPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(COPY_POLICY_PROPERTY, "policy does not exist on descriptor");
        }
        this.copyPolicy.dispose();
        this.setCopyPolicy(new MWNullDescriptorPolicy(this));
    }

    public MWLockingPolicy getLockingPolicy() {
        return this.getTransactionalPolicy().getLockingPolicy();
    }

    public MWDescriptorPolicy getEventsPolicy() {
        return this.eventsPolicy;
    }

    protected void setEventsPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.eventsPolicy;
        this.eventsPolicy = mWDescriptorPolicy;
        this.firePropertyChanged(EVENTS_POLICY_PROPERTY, mWDescriptorPolicy2, this.eventsPolicy);
    }

    public void addEventsPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.eventsPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(EVENTS_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setEventsPolicy(new MWDescriptorEventsPolicy(this));
    }

    public void removeEventsPolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.eventsPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(EVENTS_POLICY_PROPERTY, "policy does not exist on descriptor");
        }
        this.eventsPolicy.dispose();
        this.setEventsPolicy(new MWNullDescriptorPolicy(this));
    }

    private void setAfterLoadingPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.afterLoadingPolicy;
        this.afterLoadingPolicy = mWDescriptorPolicy;
        this.firePropertyChanged(AFTER_LOADING_POLICY_PROPERTY, mWDescriptorPolicy2, this.afterLoadingPolicy);
    }

    public MWDescriptorPolicy getAfterLoadingPolicy() {
        return this.afterLoadingPolicy;
    }

    public void addAfterLoadingPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.afterLoadingPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(AFTER_LOADING_POLICY_PROPERTY, "Policy already exists on descriptor");
        }
        this.setAfterLoadingPolicy(new MWDescriptorAfterLoadingPolicy(this));
    }

    public void removeAfterLoadingPolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.afterLoadingPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(AFTER_LOADING_POLICY_PROPERTY, "policy does not exist on descriptor");
        }
        this.afterLoadingPolicy.dispose();
        this.setAfterLoadingPolicy(new MWNullDescriptorPolicy(this));
    }

    protected void setInstantiationPolicy(MWDescriptorPolicy mWDescriptorPolicy) {
        MWDescriptorPolicy mWDescriptorPolicy2 = this.instantiationPolicy;
        this.instantiationPolicy = mWDescriptorPolicy;
        this.firePropertyChanged(INSTANTIATION_POLICY_PROPERTY, mWDescriptorPolicy2, this.instantiationPolicy);
    }

    public MWDescriptorPolicy getInstantiationPolicy() {
        return this.instantiationPolicy;
    }

    public void addInstantiationPolicy() throws MWAdvancedPropertyAdditionException {
        if (this.instantiationPolicy.isActive()) {
            throw new MWAdvancedPropertyAdditionException(INSTANTIATION_POLICY_PROPERTY, "policy already exists on descriptor");
        }
        this.setInstantiationPolicy(new MWDescriptorInstantiationPolicy(this));
    }

    public void removeInstantiationPolicy() {
        if (!this.instantiationPolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(INSTANTIATION_POLICY_PROPERTY, "property does not exist on descriptor");
        }
        this.instantiationPolicy.dispose();
        this.setInstantiationPolicy(new MWNullDescriptorPolicy(this));
    }

    public boolean supportsReturningPolicy() {
        return false;
    }

    public MWDirectMapping addDirectMapping(MWClassAttribute mWClassAttribute) {
        MWDirectMapping mWDirectMapping = this.mappingFactory().createDirectMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWDirectMapping);
        return mWDirectMapping;
    }

    public MWDirectCollectionMapping addDirectCollectionMapping(MWClassAttribute mWClassAttribute) {
        MWDirectCollectionMapping mWDirectCollectionMapping = this.mappingFactory().createDirectCollectionMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping((MWMapping)((Object)mWDirectCollectionMapping));
        return mWDirectCollectionMapping;
    }

    public MWDirectMapMapping addDirectMapMapping(MWClassAttribute mWClassAttribute) {
        MWDirectMapMapping mWDirectMapMapping = this.mappingFactory().createDirectMapMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping((MWMapping)((Object)mWDirectMapMapping));
        return mWDirectMapMapping;
    }

    public MWTransformationMapping addTransformationMapping(MWClassAttribute mWClassAttribute) {
        MWTransformationMapping mWTransformationMapping = this.mappingFactory().createTransformationMapping(this, mWClassAttribute, mWClassAttribute.getName());
        this.addMapping(mWTransformationMapping);
        return mWTransformationMapping;
    }

    public abstract MWMappingFactory mappingFactory();

    public Iterator mappings() {
        return new CloneIterator(this.mappings);
    }

    public int mappingsSize() {
        return this.mappings.size();
    }

    public Iterator tableReferenceMappings() {
        return new FilteringIterator(this.mappings()){

            protected boolean accept(Object object) {
                return ((MWMapping)object).isTableReferenceMapping();
            }
        };
    }

    public void removeMappingForAttribute(MWClassAttribute mWClassAttribute) {
        MWMapping mWMapping = this.mappingForAttribute(mWClassAttribute);
        if (mWMapping != null) {
            this.removeMapping(mWMapping);
        } else {
            this.removeInheritedAttribute(mWClassAttribute);
        }
    }

    protected void addMapping(MWMapping mWMapping) {
        if (CollectionTools.contains(this.inheritedAttributes(), (Object)mWMapping.getInstanceVariable())) {
            mWMapping.setInherited(true);
        }
        this.addItemToCollection(mWMapping, this.mappings, MAPPINGS_COLLECTION);
    }

    public void removeMapping(MWMapping mWMapping) {
        this.removeNodeFromCollection(mWMapping, this.mappings, MAPPINGS_COLLECTION);
    }

    private void removeMappings(Collection collection) {
        CloneIterator cloneIterator = new CloneIterator(collection);
        while (cloneIterator.hasNext()) {
            this.removeMapping((MWMapping)cloneIterator.next());
        }
    }

    public MWMapping mappingForAttribute(MWClassAttribute mWClassAttribute) {
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (mWMapping.getInstanceVariable() != mWClassAttribute) continue;
            return mWMapping;
        }
        return null;
    }

    public MWMapping mappingNamed(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (!string.equals(mWMapping.getName())) continue;
            return mWMapping;
        }
        return null;
    }

    public Collection allWritableMappingsForField(MWDataField mWDataField) {
        Object object;
        ArrayList<MWMapping> arrayList = new ArrayList<MWMapping>();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (mWMapping.isReadOnly()) continue;
            object = new ArrayList();
            mWMapping.addWrittenFieldsTo((Collection)object);
            if (!object.contains(mWDataField)) continue;
            arrayList.add(mWMapping);
        }
        if (!this.writableMappingsForField(mWDataField).isEmpty() && !this.getInheritancePolicy().isRoot() && this.getInheritancePolicy().getParentDescriptor() != null) {
            for (MWMapping mWMapping : this.getInheritancePolicy().getParentDescriptor().writableMappingsForField(mWDataField)) {
                object = this.mappingNamed(mWMapping.getName());
                if (object != null) continue;
                arrayList.add(mWMapping);
            }
        }
        return arrayList;
    }

    public Collection writableMappingsForField(MWDataField mWDataField) {
        ArrayList<MWMapping> arrayList = new ArrayList<MWMapping>();
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            ArrayList arrayList2 = new ArrayList();
            mWMapping.addWrittenFieldsTo(arrayList2);
            if (!arrayList2.contains(mWDataField)) continue;
            arrayList.add(mWMapping);
        }
        return arrayList;
    }

    public Iterator attributes() {
        return new TransformationIterator(this.mappings()){

            protected Object transform(Object object) {
                return ((MWMapping)object).getInstanceVariable();
            }
        };
    }

    public void unmap() {
        super.unmap();
        ArrayList arrayList = new ArrayList(this.mappings);
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            this.removeItemFromCollection(mWMapping, this.mappings, MAPPINGS_COLLECTION);
        }
        this.getProject().descriptorUnmapped(arrayList);
    }

    protected void initializeFromMWMappingDescriptor(MWMappingDescriptor mWMappingDescriptor) {
        super.initializeFromMWMappingDescriptor(mWMappingDescriptor);
        Iterator iterator = mWMappingDescriptor.inheritedAttributes();
        while (iterator.hasNext()) {
            this.addInheritedAttribute((MWClassAttribute)iterator.next());
        }
        iterator = mWMappingDescriptor.mappings();
        while (iterator.hasNext()) {
            this.addMapping((MWMapping)iterator.next());
        }
        this.setAfterLoadingPolicy(mWMappingDescriptor.getAfterLoadingPolicy());
        this.setCopyPolicy(mWMappingDescriptor.getCopyPolicy());
        this.setEventsPolicy(mWMappingDescriptor.getEventsPolicy());
        this.setInheritancePolicy(mWMappingDescriptor.getInheritancePolicy());
        this.setInstantiationPolicy(mWMappingDescriptor.getInstantiationPolicy());
    }

    public void mapInheritedAttributesToClass(MWClass mWClass) throws ClassNotFoundException {
        ArrayList arrayList = new ArrayList();
        for (MWClass mWClass2 = this.getMWClass(); mWClass2 != mWClass && mWClass2.getSuperclass() != this.typeFor(Object.class); mWClass2 = mWClass2.getSuperclass()) {
            CollectionTools.addAll(arrayList, mWClass2.attributes());
        }
        for (MWClassAttribute mWClassAttribute : arrayList) {
            MWMapping mWMapping = this.mappingForAttribute(mWClassAttribute);
            if (mWMapping != null || CollectionTools.contains(this.inheritedAttributes(), (Object)mWClassAttribute)) continue;
            this.addInheritedAttribute(mWClassAttribute);
        }
    }

    public void mapInheritedAttributesToRootMinusOne() throws ClassNotFoundException {
        MWClass mWClass = this.getMWClass();
        while (mWClass.getSuperclass() != this.typeFor(Object.class)) {
            mWClass = mWClass.getSuperclass();
        }
        this.mapInheritedAttributesToClass(mWClass);
    }

    public void mapInheritedAttributesToSuperclass() throws ClassNotFoundException {
        this.mapInheritedAttributesToClass(this.getMWClass().getSuperclass());
    }

    public void removeInheritedAttributes() {
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            MWMapping mWMapping = (MWMapping)iterator.next();
            if (!mWMapping.isInherited()) continue;
            this.removeMapping(mWMapping);
        }
        iterator = this.inheritedAttributes();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    private Iterator inheritedAttributeHandles() {
        return new CloneIterator(this.inheritedAttributeHandles){

            protected void remove(Object object) {
                MWMappingDescriptor.this.removeInheritedAttributeHandle((MWAttributeHandle)object);
            }
        };
    }

    void removeInheritedAttributeHandle(MWAttributeHandle mWAttributeHandle) {
        this.inheritedAttributeHandles.remove(mWAttributeHandle);
        this.fireItemRemoved(INHERITED_ATTRIBUTES_COLLECTION, mWAttributeHandle.getAttribute());
    }

    public Iterator inheritedAttributes() {
        return new TransformationIterator(this.inheritedAttributeHandles()){

            protected Object transform(Object object) {
                return ((MWAttributeHandle)object).getAttribute();
            }
        };
    }

    public int inheritedAttributesSize() {
        return this.inheritedAttributeHandles.size();
    }

    public void addInheritedAttribute(MWClassAttribute mWClassAttribute) {
        this.inheritedAttributeHandles.add(new MWAttributeHandle(this, mWClassAttribute, this.inheritedAttributeScrubber()));
        this.fireItemAdded(INHERITED_ATTRIBUTES_COLLECTION, mWClassAttribute);
    }

    public void removeInheritedAttribute(MWClassAttribute mWClassAttribute) {
        Iterator iterator = this.inheritedAttributes();
        while (iterator.hasNext()) {
            if (iterator.next() != mWClassAttribute) continue;
            iterator.remove();
            return;
        }
        throw new IllegalArgumentException(mWClassAttribute.toString());
    }

    public void removeInheritedAttributes(Collection collection) {
        this.removeInheritedAttributes(collection.iterator());
    }

    public void removeInheritedAttributes(Iterator iterator) {
        while (iterator.hasNext()) {
            this.removeInheritedAttribute((MWClassAttribute)iterator.next());
        }
    }

    public MWClassAttribute inheritedAttributeNamed(String string) {
        Iterator iterator = this.inheritedAttributes();
        while (iterator.hasNext()) {
            MWClassAttribute mWClassAttribute = (MWClassAttribute)iterator.next();
            if (!mWClassAttribute.getName().equals(string)) continue;
            return mWClassAttribute;
        }
        return null;
    }

    public boolean containsInheritedAttributeNamed(String string) {
        return this.inheritedAttributeNamed(string) != null;
    }

    public void hierarchyChanged(MWClass mWClass) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object2 = this.mappings();
        while (object2.hasNext()) {
            object = (MWMapping)object2.next();
            if (!((MWMapping)object).isInherited() || this.getMWClass().isSubclassOf(((MWMapping)object).getInstanceVariable().getDeclaringType())) continue;
            arrayList.add(object);
        }
        this.removeMappings(arrayList);
        object2 = new ArrayList();
        object = this.inheritedAttributes();
        while (object.hasNext()) {
            MWClassAttribute mWClassAttribute = (MWClassAttribute)object.next();
            if (this.getMWClass().isSubclassOf(mWClassAttribute.getDeclaringType())) continue;
            object2.add(mWClassAttribute);
        }
        this.removeInheritedAttributes((Collection)object2);
    }

    public MWMapping replaceMapping(MWMapping mWMapping, MWMapping mWMapping2) {
        if (mWMapping == mWMapping2) {
            return mWMapping;
        }
        if (mWMapping == null) {
            this.addMapping(mWMapping2);
            return mWMapping2;
        }
        if (mWMapping2 == null) {
            this.removeMapping(mWMapping);
            return null;
        }
        this.removeItemFromCollection(mWMapping, this.mappings, MAPPINGS_COLLECTION);
        this.addMapping(mWMapping2);
        this.getProject().mappingReplaced(mWMapping, mWMapping2);
        return mWMapping2;
    }

    public MWInheritancePolicy getInheritancePolicy() {
        return this.inheritancePolicy;
    }

    public void addInheritancePolicy() {
        if (this.getInheritancePolicy().isActive()) {
            throw new MWAdvancedPropertyAdditionException(INHERITANCE_POLICY_PROPERTY, "Policy already exists on descriptor: ");
        }
        MWDescriptorInheritancePolicy mWDescriptorInheritancePolicy = this.buildInheritancePolicy();
        this.setInheritancePolicy(mWDescriptorInheritancePolicy);
        mWDescriptorInheritancePolicy.initializeParentDescriptor();
        if (mWDescriptorInheritancePolicy.getParentDescriptor() == null) {
            mWDescriptorInheritancePolicy.setIsRoot(true);
        }
        this.getInheritancePolicy().getRootDescriptor().getInheritancePolicy().buildClassIndicatorValues();
    }

    protected abstract MWDescriptorInheritancePolicy buildInheritancePolicy();

    public void removeInheritancePolicy() throws MWAdvancedPropertyRemovalException {
        if (!this.inheritancePolicy.isActive()) {
            throw new MWAdvancedPropertyRemovalException(INHERITANCE_POLICY_PROPERTY, "property does not exist on descriptor");
        }
        MWDescriptor mWDescriptor = this.getInheritancePolicy().getRootDescriptor();
        this.inheritancePolicy.dispose();
        this.setInheritancePolicy(new MWNullInheritancePolicy(this));
        mWDescriptor.getInheritancePolicy().buildClassIndicatorValues();
        this.inheritanceChanged();
    }

    protected void setInheritancePolicy(MWInheritancePolicy mWInheritancePolicy) {
        MWInheritancePolicy mWInheritancePolicy2 = this.inheritancePolicy;
        this.inheritancePolicy = mWInheritancePolicy;
        this.firePropertyChanged(INHERITANCE_POLICY_PROPERTY, mWInheritancePolicy2, mWInheritancePolicy);
    }

    public boolean canHaveInheritance() {
        return true;
    }

    public boolean hasDefinedInheritance() {
        MWInheritancePolicy mWInheritancePolicy = this.getInheritancePolicy();
        return mWInheritancePolicy.isRoot() || mWInheritancePolicy.getParentDescriptor() != null;
    }

    public boolean hasActiveInstantiationPolicy() {
        return this.getInstantiationPolicy().isActive();
    }

    void inheritanceChanged() {
        super.inheritanceChanged();
        this.inheritancePolicy.descriptorInheritanceChanged();
    }

    public Iterator mappingsIncludingInherited() {
        return new CloneListIterator(this.getMappingsIncludingInherited());
    }

    protected List getMappingsIncludingInherited() {
        Vector vector = new Vector();
        if (this.getInheritancePolicy().getParentDescriptor() != null) {
            vector.addAll(this.getInheritancePolicy().getParentDescriptor().getMappingsIncludingInherited());
        }
        vector.addAll(this.mappings);
        return vector;
    }

    public void implementorsChangedFor(MWInterfaceDescriptor mWInterfaceDescriptor) {
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            ((MWMapping)iterator.next()).implementorsChangedFor(mWInterfaceDescriptor);
        }
    }

    public Collection buildAggregateFieldNameGenerators() {
        return new ArrayList();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkMultipleMappingsWriteField(list);
        this.checkForDuplicateMethods(list);
    }

    protected void checkMultipleMappingsWriteField(List list) {
        MWMapping mWMapping;
        HashBag hashBag = new HashBag();
        HashMap<MWDataField, ArrayList<MWMapping>> hashMap = new HashMap<MWDataField, ArrayList<MWMapping>>();
        Iterator iterator = this.mappingsIncludingInherited();
        while (iterator.hasNext()) {
            mWMapping = (MWMapping)iterator.next();
            if (mWMapping.getParentDescriptor().getTransactionalPolicy().isReadOnly()) continue;
            ArrayList arrayList = new ArrayList();
            mWMapping.addWrittenFieldsTo(arrayList);
            for (MWDataField mWDataField : arrayList) {
                ArrayList<MWMapping> arrayList2 = (ArrayList<MWMapping>)hashMap.get(mWDataField);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<MWMapping>();
                    hashMap.put(mWDataField, arrayList2);
                }
                arrayList2.add(mWMapping);
            }
            hashBag.addAll(arrayList);
        }
        iterator = hashBag.uniqueIterator();
        while (iterator.hasNext()) {
            mWMapping = iterator.next();
            if (hashBag.count(mWMapping) <= 1) continue;
            list.add(this.buildMultipleMappingsWriteFieldProblem((Collection)hashMap.get(mWMapping), (MWDataField)((Object)mWMapping)));
        }
    }

    private Problem buildMultipleMappingsWriteFieldProblem(Collection collection, MWDataField mWDataField) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append('\"');
            stringBuffer.append(((MWMapping)iterator.next()).getName());
            stringBuffer.append('\"');
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return this.buildProblem(this.multipleMappingsWriteFieldProblemResourceStringKey(), stringBuffer.toString(), mWDataField.fieldName());
    }

    protected abstract String multipleMappingsWriteFieldProblemResourceStringKey();

    private void checkForDuplicateMethods(List list) {
        Iterator iterator = this.getMWClass().methods();
        while (iterator.hasNext()) {
            MWMethod mWMethod = (MWMethod)iterator.next();
            boolean bl = true;
            Iterator iterator2 = this.getMWClass().methods();
            while (iterator2.hasNext()) {
                MWMethod mWMethod2 = (MWMethod)iterator2.next();
                if (!mWMethod2.hasSameSignatureAs(mWMethod)) continue;
                if (bl) {
                    bl = false;
                    continue;
                }
                list.add(this.buildProblem("0210", mWMethod.signature()));
            }
        }
    }

    protected void automapInternal() {
        super.automapInternal();
        this.getInheritancePolicy().automap();
        this.automapMappings();
    }

    private void automapMappings() {
        Iterator iterator = this.mappings();
        while (iterator.hasNext()) {
            ((MWMapping)iterator.next()).automap();
        }
    }

    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor classDescriptor = super.buildRuntimeDescriptor();
        this.inheritancePolicy.adjustRuntimeDescriptor(classDescriptor);
        this.copyPolicy.adjustRuntimeDescriptor(classDescriptor);
        this.instantiationPolicy.adjustRuntimeDescriptor(classDescriptor);
        this.afterLoadingPolicy.adjustRuntimeDescriptor(classDescriptor);
        this.eventsPolicy.adjustRuntimeDescriptor(classDescriptor);
        Iterator iterator = this.getProject().interfaceDescriptorsThatImplement(this);
        while (iterator.hasNext()) {
            MWInterfaceDescriptor mWInterfaceDescriptor = (MWInterfaceDescriptor)iterator.next();
            classDescriptor.getInterfacePolicy().addParentInterfaceName(mWInterfaceDescriptor.getMWClass().getName());
        }
        iterator = this.orderedMappings();
        while (iterator.hasNext()) {
            classDescriptor.addMapping(((MWMapping)iterator.next()).runtimeMapping());
        }
        return classDescriptor;
    }

    private Iterator orderedMappings() {
        return CollectionTools.sort(new Vector(this.mappings), this.orderedMappingComparator()).iterator();
    }

    protected Comparator orderedMappingComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return 0;
            }
        };
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWMappingDescriptor.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWDescriptor.class);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(MAPPINGS_COLLECTION);
        xMLCompositeCollectionMapping.setGetMethodName("getMappingsForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setMappingsForTopLink");
        xMLCompositeCollectionMapping.setReferenceClass(MWMapping.class);
        xMLCompositeCollectionMapping.setXPath("mappings/mapping");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("inheritedAttributeHandles");
        xMLCompositeCollectionMapping2.setGetMethodName("getInheritedAttributeHandlesForTopLink");
        xMLCompositeCollectionMapping2.setSetMethodName("setInheritedAttributeHandlesForTopLink");
        xMLCompositeCollectionMapping2.setReferenceClass(MWAttributeHandle.class);
        xMLCompositeCollectionMapping2.setXPath("inherited-attribute-handles/attribute-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(INHERITANCE_POLICY_PROPERTY);
        xMLCompositeObjectMapping.setGetMethodName("getInheritancePolicyForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setInheritancePolicyForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorInheritancePolicy.class);
        xMLCompositeObjectMapping.setXPath("inheritance-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName(COPY_POLICY_PROPERTY);
        xMLCompositeObjectMapping2.setSetMethodName("setCopyPolicyForTopLink");
        xMLCompositeObjectMapping2.setGetMethodName("getCopyPolicyForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWDescriptorCopyPolicy.class);
        xMLCompositeObjectMapping2.setXPath("copy-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping3 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping3.setAttributeName(EVENTS_POLICY_PROPERTY);
        xMLCompositeObjectMapping3.setReferenceClass(MWDescriptorEventsPolicy.class);
        xMLCompositeObjectMapping3.setXPath("events-policy");
        xMLCompositeObjectMapping3.setSetMethodName("setEventsPolicyForTopLink");
        xMLCompositeObjectMapping3.setGetMethodName("getEventsPolicyForTopLink");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping4 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping4.setAttributeName(AFTER_LOADING_POLICY_PROPERTY);
        xMLCompositeObjectMapping4.setSetMethodName("setAfterLoadingPolicyForTopLink");
        xMLCompositeObjectMapping4.setGetMethodName("getAfterLoadingPolicyForTopLink");
        xMLCompositeObjectMapping4.setReferenceClass(MWDescriptorAfterLoadingPolicy.class);
        xMLCompositeObjectMapping4.setXPath("after-loading-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping4);
        XMLCompositeObjectMapping xMLCompositeObjectMapping5 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping5.setAttributeName(INSTANTIATION_POLICY_PROPERTY);
        xMLCompositeObjectMapping5.setReferenceClass(MWDescriptorInstantiationPolicy.class);
        xMLCompositeObjectMapping5.setGetMethodName("getInstantiationPolicyForTopLink");
        xMLCompositeObjectMapping5.setSetMethodName("setInstantiationPolicyForTopLink");
        xMLCompositeObjectMapping5.setXPath("instantiation-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping5);
        return xMLDescriptor;
    }

    private Collection getMappingsForTopLink() {
        return CollectionTools.sort((List)this.mappings);
    }

    private void setMappingsForTopLink(Collection collection) {
        this.mappings = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getInheritedAttributeHandlesForTopLink() {
        Collection collection = this.inheritedAttributeHandles;
        synchronized (collection) {
            return new TreeSet(this.inheritedAttributeHandles);
        }
    }

    private void setInheritedAttributeHandlesForTopLink(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((MWAttributeHandle)iterator.next()).setScrubber(this.inheritedAttributeScrubber());
        }
        this.inheritedAttributeHandles = collection;
    }

    private MWDescriptorInheritancePolicy getInheritancePolicyForTopLink() {
        return (MWDescriptorInheritancePolicy)this.inheritancePolicy.getPersistedPolicy();
    }

    protected void setInheritancePolicyForTopLink(MWDescriptorInheritancePolicy mWDescriptorInheritancePolicy) {
        this.inheritancePolicy = mWDescriptorInheritancePolicy == null ? new MWNullInheritancePolicy(this) : mWDescriptorInheritancePolicy;
    }

    private MWDescriptorCopyPolicy getCopyPolicyForTopLink() {
        return (MWDescriptorCopyPolicy)this.getCopyPolicy().getPersistedPolicy();
    }

    private void setCopyPolicyForTopLink(MWDescriptorCopyPolicy mWDescriptorCopyPolicy) {
        this.copyPolicy = mWDescriptorCopyPolicy == null ? new MWNullDescriptorPolicy(this) : mWDescriptorCopyPolicy;
    }

    private MWDescriptorEventsPolicy getEventsPolicyForTopLink() {
        return (MWDescriptorEventsPolicy)this.getEventsPolicy().getPersistedPolicy();
    }

    private void setEventsPolicyForTopLink(MWDescriptorEventsPolicy mWDescriptorEventsPolicy) {
        this.eventsPolicy = mWDescriptorEventsPolicy == null ? new MWNullDescriptorPolicy(this) : mWDescriptorEventsPolicy;
    }

    private MWDescriptorAfterLoadingPolicy getAfterLoadingPolicyForTopLink() {
        return (MWDescriptorAfterLoadingPolicy)this.afterLoadingPolicy.getPersistedPolicy();
    }

    private void setAfterLoadingPolicyForTopLink(MWDescriptorAfterLoadingPolicy mWDescriptorAfterLoadingPolicy) {
        this.afterLoadingPolicy = mWDescriptorAfterLoadingPolicy == null ? new MWNullDescriptorPolicy(this) : mWDescriptorAfterLoadingPolicy;
    }

    private MWDescriptorInstantiationPolicy getInstantiationPolicyForTopLink() {
        return (MWDescriptorInstantiationPolicy)this.instantiationPolicy.getPersistedPolicy();
    }

    private void setInstantiationPolicyForTopLink(MWDescriptorInstantiationPolicy mWDescriptorInstantiationPolicy) {
        this.instantiationPolicy = mWDescriptorInstantiationPolicy == null ? new MWNullDescriptorPolicy(this) : mWDescriptorInstantiationPolicy;
    }
}

