/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWHandle
implements MWNode {
    private MWNode parent;
    private NodeReferenceScrubber scrubber;
    private volatile boolean dirty = true;

    protected MWHandle() {
    }

    protected MWHandle(MWNode mWNode, NodeReferenceScrubber nodeReferenceScrubber) {
        this();
        this.setParent(mWNode);
        this.setScrubberInternal(nodeReferenceScrubber);
    }

    public final Node getParent() {
        return this.parent;
    }

    public final void setParent(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.parent = (MWNode)node;
    }

    public final Iterator children() {
        return NullIterator.instance();
    }

    public final void setChildBackpointers() {
    }

    public final boolean isDescendantOf(Node node) {
        return this == node || this.parent.isDescendantOf(node);
    }

    public final void addBranchReferencesTo(Collection collection) {
        Node node = this.node();
        if (node != null) {
            collection.add(new Node.SimpleReference(this, node));
        }
    }

    public final void addAllNodesTo(Collection collection) {
        collection.add(this);
    }

    public final boolean isDirtyBranch() {
        return this.dirty;
    }

    public final void markBranchDirty() {
        throw new IllegalStateException("handles shouldn't have children");
    }

    public final void markEntireBranchDirty() {
        this.markDirty();
    }

    public final void cascadeMarkEntireBranchClean() {
        this.dirty = false;
    }

    public final void markBranchCleanIfPossible() {
        throw new IllegalStateException("handles shouldn't have children");
    }

    private void markDirty() {
        this.dirty = true;
        this.parent.markBranchDirty();
    }

    public final ChangeNotifier getChangeNotifier() {
        return this.parent.getChangeNotifier();
    }

    public final void setChangeNotifier(ChangeNotifier changeNotifier) {
        throw new UnsupportedOperationException("Only root nodes implement #setChangeNotifier(ChangeNotifier): " + this);
    }

    public final Node.Validator getValidator() {
        return this.parent.getValidator();
    }

    public final void setValidator(Node.Validator validator) {
        throw new UnsupportedOperationException("Only root nodes implement #setValidator(Node.Validator): " + this);
    }

    public final ListIterator branchProblems() {
        return NullListIterator.instance();
    }

    public final boolean hasBranchProblems() {
        return false;
    }

    public final boolean containsBranchProblem(Problem problem) {
        return false;
    }

    public final void validateBranch() {
    }

    public final boolean validateBranchInternal() {
        return false;
    }

    public final void rebuildBranchProblems() {
    }

    public final void addBranchProblemsTo(List list) {
    }

    public final int branchProblemsSize() {
        return 0;
    }

    public final void clearAllBranchProblems() {
    }

    public final boolean clearAllBranchProblemsInternal() {
        return false;
    }

    public final MWNode getMWParent() {
        return this.parent;
    }

    public final MWProject getProject() {
        return this.getMWParent().getProject();
    }

    public final MWDatabase getDatabase() {
        return this.getProject().getDatabase();
    }

    public final MWClassRepository getRepository() {
        return this.getProject().getClassRepository();
    }

    public final MWClass typeNamed(String string) {
        return this.getRepository().typeNamedInternal(string);
    }

    public final MWClass typeFor(Class clazz) {
        return this.typeNamed(clazz.getName());
    }

    protected abstract Node node();

    public void nodeRenamed(Node node) {
        if (this.node() != null && this.node().isDescendantOf(node)) {
            this.markDirty();
        }
    }

    public final void nodeRemoved(Node node) {
        if (this.node() != null && this.node().isDescendantOf(node)) {
            this.scrubber.nodeReferenceRemoved(this.node(), this);
        }
    }

    public final void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
    }

    public final void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
    }

    public final void descriptorUnmapped(Collection collection) {
    }

    protected final void setScrubberInternal(NodeReferenceScrubber nodeReferenceScrubber) {
        if (nodeReferenceScrubber == null) {
            throw new NullPointerException();
        }
        this.scrubber = nodeReferenceScrubber;
    }

    public void resolveClassHandles() {
    }

    public void resolveDescriptorHandles() {
    }

    public void resolveMetadataHandles() {
    }

    public void resolveColumnHandles() {
    }

    public void resolveReferenceHandles() {
    }

    public void resolveMethodHandles() {
    }

    public void postProjectBuild() {
        if (this.scrubber == null) {
            throw new NullPointerException("This handle's 'scrubber' should have been set by its parent upon creation.");
        }
    }

    public final String displayString() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringTools.buildSimpleToStringOn(this, stringBuffer);
        stringBuffer.append(" (");
        this.toString(stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public abstract void toString(StringBuffer var1);

    public static interface NodeReferenceScrubber {
        public static final NodeReferenceScrubber NULL_INSTANCE = new NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
            }

            public String toString() {
                return "NullReferenceScrubber";
            }
        };

        public void nodeReferenceRemoved(Node var1, MWHandle var2);
    }
}

