/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWClassHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class DefaultingContainerClass
extends MWModel {
    private volatile boolean usesDefaultContainerClass;
    public static final String USES_DEFAULT_CONTAINER_CLASS_PROPERTY = "usesDefaultContainerClass";
    private MWClassHandle containerClassHandle;
    public static final String CONTAINER_CLASS_PROPERTY = "containerClass";

    private DefaultingContainerClass() {
    }

    DefaultingContainerClass(MWContainerPolicy mWContainerPolicy) {
        super(mWContainerPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.containerClassHandle = new MWClassHandle(this, this.buildContainerClassScrubber());
        this.usesDefaultContainerClass = true;
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.containerClassHandle);
    }

    private MWHandle.NodeReferenceScrubber buildContainerClassScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                DefaultingContainerClass.this.setContainerClass(null);
            }

            public String toString() {
                return "DefaultingContainerClass.buildContainerClassScrubber()";
            }
        };
    }

    private MWContainerPolicy getContainerPolicy() {
        return (MWContainerPolicy)this.getParent();
    }

    public boolean usesDefaultContainerClass() {
        return this.usesDefaultContainerClass;
    }

    public void setUseDefaultContainerClass(boolean bl) {
        if (bl == this.usesDefaultContainerClass) {
            return;
        }
        boolean bl2 = this.usesDefaultContainerClass;
        MWClass mWClass = this.getContainerClass();
        this.setUseDefaultContainerClassInternal(bl);
        if (this.usesDefaultContainerClass) {
            this.setContainerClassInternal(null);
        } else if (bl2) {
            this.setContainerClassInternal(mWClass);
        }
    }

    private void setUseDefaultContainerClassInternal(boolean bl) {
        boolean bl2 = this.usesDefaultContainerClass;
        this.usesDefaultContainerClass = bl;
        this.firePropertyChanged(USES_DEFAULT_CONTAINER_CLASS_PROPERTY, bl2, bl);
    }

    public MWClass getContainerClass() {
        if (this.usesDefaultContainerClass()) {
            return this.getContainerPolicy().defaultContainerClass();
        }
        return this.containerClassHandle.getType();
    }

    public void setContainerClass(MWClass mWClass) {
        this.setContainerClassInternal(mWClass);
        if (mWClass != null) {
            this.setUseDefaultContainerClassInternal(false);
        }
    }

    private void setContainerClassInternal(MWClass mWClass) {
        MWClass mWClass2 = this.getContainerClass();
        this.containerClassHandle.setType(mWClass);
        this.firePropertyChanged(CONTAINER_CLASS_PROPERTY, mWClass2, mWClass);
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkContainerClass(list);
    }

    private void checkContainerClass(List list) {
        if (this.getContainerClass() == null) {
            list.add(this.buildProblem("0470"));
        } else if (!this.getContainerClass().isInstantiable()) {
            list.add(this.buildProblem("0473"));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(DefaultingContainerClass.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(USES_DEFAULT_CONTAINER_CLASS_PROPERTY);
        xMLDirectMapping.setXPath("uses-default-container-class/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.FALSE);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("containerClassHandle");
        xMLCompositeObjectMapping.setSetMethodName("setContainerClassHandleForTopLink");
        xMLCompositeObjectMapping.setGetMethodName("getContainerClassHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWClassHandle.class);
        xMLCompositeObjectMapping.setXPath("container-class-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWClassHandle getContainerClassHandleForTopLink() {
        return this.containerClassHandle.getType() == null ? null : this.containerClassHandle;
    }

    private void setContainerClassHandleForTopLink(MWClassHandle mWClassHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildContainerClassScrubber();
        this.containerClassHandle = mWClassHandle == null ? new MWClassHandle(this, nodeReferenceScrubber) : mWClassHandle.setScrubber(nodeReferenceScrubber);
    }
}

