/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWQueryKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWQueryKeyHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWCollectionMapping;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWCollectionOrdering
extends MWModel {
    private volatile boolean ascending;
    public static final String ASCENDING_PROPERTY = "ascending";
    private MWQueryKeyHandle queryKeyHandle;
    public static final String QUERY_KEY_PROPERTY = "queryKey";

    private MWCollectionOrdering() {
    }

    MWCollectionOrdering(MWCollectionMapping mWCollectionMapping) {
        super(mWCollectionMapping);
    }

    public MWCollectionMapping getOwner() {
        return (MWCollectionMapping)this.getParent();
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.queryKeyHandle = new MWQueryKeyHandle(this, this.buildQueryKeyScrubber());
        this.ascending = true;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean bl) {
        boolean bl2 = this.ascending;
        this.ascending = bl;
        this.firePropertyChanged(ASCENDING_PROPERTY, bl2, bl);
    }

    public MWQueryKey getQueryKey() {
        return this.queryKeyHandle.getQueryKey();
    }

    public void setQueryKey(MWQueryKey mWQueryKey) {
        MWQueryKey mWQueryKey2 = this.getQueryKey();
        this.queryKeyHandle.setQueryKey(mWQueryKey);
        this.firePropertyChanged(QUERY_KEY_PROPERTY, mWQueryKey2, mWQueryKey);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryKeyHandle);
    }

    private MWHandle.NodeReferenceScrubber buildQueryKeyScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWCollectionOrdering.this.setQueryKey(null);
            }

            public String toString() {
                return "MWCollectionMapping.buildQueryKeyScrubber()";
            }
        };
    }

    public void descriptorUnmapped(Collection collection) {
        super.descriptorUnmapped(collection);
        for (MWMapping mWMapping : collection) {
            MWQueryKey mWQueryKey = mWMapping.getAutoGeneratedQueryKey();
            if (mWQueryKey == null || this.getQueryKey() != mWQueryKey) continue;
            this.setQueryKey(null);
            return;
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkQueryKey(list);
    }

    private void checkQueryKey(List list) {
        if (this.getQueryKey() == null) {
            list.add(this.buildProblem("0479"));
        }
    }

    public void adjustRuntimeMapping(CollectionMapping collectionMapping) {
        if (this.getQueryKey() != null) {
            if (this.isAscending()) {
                collectionMapping.addAscendingOrdering(this.getQueryKey().getName());
            } else {
                collectionMapping.addDescendingOrdering(this.getQueryKey().getName());
            }
        }
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.getQueryKey() != null) {
            stringBuffer.append(this.getQueryKey().getName());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWCollectionOrdering.class);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(ASCENDING_PROPERTY, "ascending/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.TRUE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("queryKeyHandle");
        xMLCompositeObjectMapping.setGetMethodName("getQueryKeyHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setQueryKeyHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWQueryKeyHandle.class);
        xMLCompositeObjectMapping.setXPath("query-key-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWQueryKeyHandle getQueryKeyHandleForTopLink() {
        return this.queryKeyHandle.getQueryKey() == null ? null : this.queryKeyHandle;
    }

    private void setQueryKeyHandleForTopLink(MWQueryKeyHandle mWQueryKeyHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildQueryKeyScrubber();
        this.queryKeyHandle = mWQueryKeyHandle == null ? new MWQueryKeyHandle(this, nodeReferenceScrubber) : mWQueryKeyHandle.setScrubber(nodeReferenceScrubber);
    }
}

