/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.meta;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.ProjectSubFileComponentContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.DefaultMWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureContainer;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureEvent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.ExternalClassLoadFailureListener;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassRepositoryFactory;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TreeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MWClassRepository
extends MWModel
implements ProjectSubFileComponentContainer {
    private Map types;
    private Map typeNames;
    private Set userTypes;
    public static final String USER_TYPES_COLLECTION = "userTypes";
    private Collection userTypeNames;
    private static final String USER_TYPE_NAMES_COLLECTION = "userTypeNames";
    private volatile ExternalClassRepository externalClassRepository;
    private List classpathEntries;
    public static final String CLASSPATH_ENTRIES_LIST = "classpathEntries";
    private static final Class[] CORE_KEYS = new Class[]{Object.class, List.class, Map.class, Collection.class, Set.class, ValueHolderInterface.class};
    private static Set coreClassNames;
    private static Map coreClassNamesLowerCase;
    private static final String SUB_DIRECTORY_NAME = "classes";
    private boolean persistLastRefresh;
    public static final String PERSIST_LAST_REFRESH_PREFERENCE = "last refresh";
    public static final boolean PERSIST_LAST_REFRESH_PREFERENCE_DEFAULT = true;

    private MWClassRepository() {
    }

    public MWClassRepository(MWProject mWProject) {
        super(mWProject);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    @Override
    protected void initialize(Node node) {
        super.initialize(node);
        this.types = new Hashtable();
        this.typeNames = new Hashtable();
        this.userTypes = Collections.synchronizedSet(new HashSet());
        this.classpathEntries = new Vector();
        this.userTypeNames = new HashSet();
        this.persistLastRefresh = true;
    }

    private void setTypes(Collection collection) {
        this.types = new Hashtable(collection.size());
        this.typeNames = new Hashtable(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addType((MWClass)iterator.next());
        }
        this.userTypes = Collections.synchronizedSet(new HashSet(collection));
    }

    private void addType(MWClass mWClass) {
        this.addType(mWClass.getName(), mWClass);
    }

    private void addType(String string, MWClass mWClass) {
        MWClass mWClass2 = this.types.put(string, mWClass);
        if (mWClass2 != null) {
            this.types.put(string, mWClass2);
            throw new IllegalArgumentException("duplicate types: " + mWClass2 + " vs. " + mWClass);
        }
        String string2 = this.typeNames.put(string.toLowerCase(), string);
        if (string2 != null) {
            this.types.remove(string);
            this.typeNames.put(string.toLowerCase(), string2);
            throw new IllegalArgumentException("type names cannot differ only by case: " + string2 + " vs. " + string);
        }
    }

    private void removeType(MWClass mWClass) {
        this.removeTypeNamed(mWClass.getName());
        this.removeUserType(mWClass);
    }

    private MWClass removeTypeNamed(String string) {
        Object v = this.typeNames.remove(string.toLowerCase());
        if (v == null) {
            throw new IllegalArgumentException("missing type name: " + string);
        }
        if (!v.equals(string)) {
            this.typeNames.put(string.toLowerCase(), v);
            throw new IllegalArgumentException("inconsistent type names: " + v + " vs. " + string);
        }
        MWClass mWClass = (MWClass)this.types.remove(string);
        if (mWClass == null) {
            this.typeNames.put(string.toLowerCase(), v);
            throw new IllegalArgumentException("missing type: " + string);
        }
        return mWClass;
    }

    public Iterator userTypes() {
        return new CloneIterator(this.userTypes);
    }

    public int userTypesSize() {
        return this.userTypes.size();
    }

    private void addUserType(MWClass mWClass) {
        this.addItemToCollection(mWClass, this.userTypes, USER_TYPES_COLLECTION);
    }

    private void removeUserType(MWClass mWClass) {
        this.removeItemFromCollection(mWClass, this.userTypes, USER_TYPES_COLLECTION);
    }

    private ExternalClassRepository getExternalClassRepository() {
        if (this.externalClassRepository == null) {
            this.externalClassRepository = this.buildExternalClassRepository();
        }
        return this.externalClassRepository;
    }

    private ExternalClassRepository buildExternalClassRepository() {
        return this.externalClassRepositoryFactory().buildClassRepository(this.buildExternalClassRepositoryClasspath());
    }

    public ListIterator classpathEntries() {
        return new CloneListIterator(this.classpathEntries);
    }

    public int classpathEntriesSize() {
        return this.classpathEntries.size();
    }

    public String getClasspathEntry(int n) {
        return (String)this.classpathEntries.get(n);
    }

    public void addClasspathEntry(int n, String string) {
        this.addItemToList(n, string, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
    }

    public void addClasspathEntry(String string) {
        this.addClasspathEntry(this.classpathEntriesSize(), string);
    }

    public void addClasspathEntries(int n, List list) {
        this.addItemsToList(n, list, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
    }

    public void addClasspathEntries(List list) {
        this.addClasspathEntries(this.classpathEntriesSize(), list);
    }

    public void addClasspathEntries(ListIterator listIterator) {
        this.addClasspathEntries(CollectionTools.list(listIterator));
    }

    public String removeClasspathEntry(int n) {
        String string = (String)this.removeItemFromList(n, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
        return string;
    }

    public List removeClasspathEntries(int n, int n2) {
        List list = this.removeItemsFromList(n, n2, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
        return list;
    }

    public String replaceClasspathEntry(int n, String string) {
        String string2 = (String)this.setItemInList(n, string, this.classpathEntries, CLASSPATH_ENTRIES_LIST);
        this.externalClassRepository = null;
        return string2;
    }

    private ExternalClassRepositoryFactory externalClassRepositoryFactory() {
        return this.getProject().getSPIManager().getExternalClassRepositoryFactory();
    }

    public Iterator externalClassDescriptions() {
        return new ArrayIterator(this.getExternalClassRepository().getClassDescriptions());
    }

    public Iterator externalReferenceClassDescriptions() {
        return this.referenceTypes(this.externalClassDescriptions());
    }

    private ExternalClassDescription externalClassDescriptionNamed(String string) {
        return this.getExternalClassRepository().getClassDescription(string);
    }

    Iterator externalClassDescriptionsNamed(final String string) {
        return new FilteringIterator(this.externalClassDescriptions()){

            public boolean accept(Object object) {
                return ((ExternalClassDescription)object).getName().equals(string);
            }

            public String toString() {
                return "MWClassRepository.externalClassDescriptionsNamed(String)";
            }
        };
    }

    public Iterator combinedTypes() {
        return new CompositeIterator((Iterator)new CloneIterator(this.userTypes), this.externalClassDescriptions());
    }

    public Iterator combinedReferenceTypes() {
        return this.referenceTypes(this.combinedTypes());
    }

    public Iterator uniqueCombinedTypes() {
        return this.uniqueTypes(this.combinedTypes());
    }

    public Iterator uniqueCombinedReferenceTypes() {
        return this.uniqueTypes(this.combinedReferenceTypes());
    }

    private Iterator uniqueTypes(Iterator iterator) {
        return new FilteringIterator(iterator){
            private Set usedNames;
            {
                this.usedNames = new HashSet(10000);
            }

            protected boolean accept(Object object) {
                return this.usedNames.add(((ClassDescription)object).getName());
            }

            public String toString() {
                return "MWClassRepository.uniqueTypes(Iterator)";
            }
        };
    }

    private Iterator referenceTypes(Iterator iterator) {
        return new FilteringIterator(iterator){

            protected boolean accept(Object object) {
                return !MWClass.nonReferenceClassNamesContains(((ClassDescription)object).getName());
            }

            public String toString() {
                return "MWClassRepository.referenceTypes(Iterator)";
            }
        };
    }

    File classpathBaseDirectory() {
        return this.getProject().getSaveDirectory();
    }

    private File[] buildExternalClassRepositoryClasspath() {
        List<String> list = MWClassRepository.buildCoreClassLocations();
        ArrayList<File> arrayList = new ArrayList<File>(this.classpathEntriesSize() + list.size());
        CollectionTools.addAll(arrayList, this.fullyQualifiedClasspathFiles());
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            arrayList.add(new File(listIterator.next()));
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private Iterator fullyQualifiedClasspathFiles() {
        return new TransformationIterator(this.classpathEntries()){

            protected Object transform(Object object) {
                File file = new File((String)object);
                if (!file.isAbsolute()) {
                    file = new File(MWClassRepository.this.classpathBaseDirectory(), file.getPath());
                }
                return file;
            }

            public String toString() {
                return "MWClassRepository.fullyQualifiedClasspathFiles()";
            }
        };
    }

    public Iterator fullyQualifiedClasspathEntries() {
        return new TransformationIterator(this.fullyQualifiedClasspathFiles()){

            protected Object transform(Object object) {
                return ((File)object).getAbsolutePath();
            }

            public String toString() {
                return "MWClassRepository.fullyQualifiedClasspathEntries()";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator subclassesOf(MWClass mWClass) {
        ArrayList<MWClass> arrayList = new ArrayList<MWClass>();
        Map map = this.types;
        synchronized (map) {
            for (MWClass mWClass2 : this.types.values()) {
                if (mWClass2.getSuperclass() != mWClass) continue;
                arrayList.add(mWClass2);
            }
        }
        return arrayList.iterator();
    }

    public Iterator allSubclassesOf(MWClass mWClass) {
        return new TreeIterator(mWClass){

            protected Iterator children(Object object) {
                return ((MWClass)object).subclasses();
            }

            public String toString() {
                return "MWClassRepository.allSubclassesOf(MWClass)";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWClass typeNamedIgnoreCase(String string) {
        Map map = this.types;
        synchronized (map) {
            return this.typeNamedIgnoreCase2(string);
        }
    }

    private MWClass typeNamedIgnoreCase2(String string) {
        if ((string = (String)this.typeNames.get(string.toLowerCase())) == null) {
            return null;
        }
        MWClass mWClass = (MWClass)this.types.get(string);
        return this.typeIsGarbage(mWClass) ? null : mWClass;
    }

    private boolean typeIsGarbage(MWClass mWClass) {
        Iterator iterator = this.getProject().branchReferences();
        while (iterator.hasNext()) {
            Node.Reference reference = (Node.Reference)iterator.next();
            if (!reference.getTarget().isDescendantOf(mWClass)) continue;
            return false;
        }
        this.removeType(mWClass);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MWClass typeNamedInternal(String string) {
        Map map = this.types;
        synchronized (map) {
            return this.typeNamedInternal2(string);
        }
    }

    private MWClass typeNamedInternal2(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        MWClass mWClass = (MWClass)this.types.get(string = string.trim());
        if (mWClass != null) {
            return mWClass;
        }
        boolean bl = this.checkTypeName(string);
        mWClass = new MWClass(this, string, bl);
        this.addType(string, mWClass);
        mWClass.initializeNameDependentState();
        if (bl) {
            this.buildCoreType(mWClass);
        }
        return mWClass;
    }

    private boolean checkTypeName(String string) {
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty type name");
        }
        if (ClassTools.classNamedIsArray(string)) {
            throw new IllegalArgumentException("use MWTypeDeclaration for array types");
        }
        if (MWClassRepository.coreClassNamesContains(string)) {
            return true;
        }
        String string2 = MWClassRepository.coreClassNameIgnoreCase(string);
        if (string2 != null) {
            throw new IllegalArgumentException("case-insensitive name collision with \"core\" type: " + string2);
        }
        return false;
    }

    public Iterator primitiveTypes() {
        return new TransformationIterator(MWClass.primitiveClassNames()){

            protected Object transform(Object object) {
                return MWClassRepository.this.typeNamedInternal((String)object);
            }

            public String toString() {
                return "MWClassRepository.primitiveTypes()";
            }
        };
    }

    public MWClass voidType() {
        return this.typeNamedInternal(MWClass.voidClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String string) {
        Classpath classpath;
        List list = this.classpathEntries;
        synchronized (list) {
            classpath = new Classpath(this.classpathEntries);
        }
        return new URLClassLoader(classpath.urls()).findResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Map map = this.types;
        synchronized (map) {
            list.addAll(this.types.values());
        }
    }

    void typeChanged(MWClass mWClass) {
        if (mWClass.isCoreType()) {
            return;
        }
        if (mWClass.isStub()) {
            this.removeUserType(mWClass);
        } else {
            this.addUserType(mWClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void typeRenamed(String string, String string2) {
        MWClass mWClass;
        if (this.checkTypeName(string2)) {
            throw new IllegalArgumentException("type cannot be renamed to a \"core\" type");
        }
        Map map = this.types;
        synchronized (map) {
            mWClass = this.removeTypeNamed(string);
            this.addType(string2, mWClass);
        }
        if (this.userTypes.contains(mWClass)) {
            this.fireCollectionChanged(USER_TYPE_NAMES_COLLECTION);
        }
    }

    void refreshType(MWClass mWClass) throws ExternalClassNotFoundException {
        this.refreshType(mWClass, DefaultMWClassRefreshPolicy.instance());
    }

    void refreshType(MWClass mWClass, MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException {
        ExternalClassDescription externalClassDescription = this.externalClassDescriptionNamed(mWClass.getName());
        if (externalClassDescription == null) {
            throw new ExternalClassNotFoundException(mWClass.getName());
        }
        mWClass.refresh(externalClassDescription.getExternalClass(), mWClassRefreshPolicy);
    }

    void refreshTypeMembers(MWClass mWClass, MWClassRefreshPolicy mWClassRefreshPolicy) throws ExternalClassNotFoundException {
        ExternalClassDescription externalClassDescription = this.externalClassDescriptionNamed(mWClass.getName());
        if (externalClassDescription == null) {
            throw new ExternalClassNotFoundException(mWClass.getName());
        }
        mWClass.refreshMembers(externalClassDescription.getExternalClass(), mWClassRefreshPolicy);
    }

    public void refreshExternalClassDescriptions() {
        this.externalClassRepository = null;
    }

    public void refreshTypeNamed(String string) throws ExternalClassNotFoundException {
        this.typeNamedInternal(string).refresh();
    }

    public void refreshTypeFor(ExternalClassDescription externalClassDescription) throws ExternalClassNotFoundException {
        this.typeNamedInternal(externalClassDescription.getName()).refresh(externalClassDescription.getExternalClass());
    }

    public void refreshTypesFor(Iterator iterator, ExternalClassLoadFailureListener externalClassLoadFailureListener) {
        while (iterator.hasNext()) {
            ExternalClassDescription externalClassDescription = (ExternalClassDescription)iterator.next();
            try {
                this.refreshTypeFor(externalClassDescription);
            }
            catch (ExternalClassNotFoundException externalClassNotFoundException) {
                externalClassLoadFailureListener.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, externalClassDescription.getName(), externalClassNotFoundException));
            }
        }
    }

    public ExternalClassLoadFailureContainer refreshTypesFor(Iterator iterator) {
        ExternalClassLoadFailureContainer externalClassLoadFailureContainer = new ExternalClassLoadFailureContainer();
        this.refreshTypesFor(iterator, externalClassLoadFailureContainer);
        return externalClassLoadFailureContainer;
    }

    public void refreshTypes(Iterator iterator, ExternalClassLoadFailureListener externalClassLoadFailureListener) {
        while (iterator.hasNext()) {
            MWClass mWClass = (MWClass)iterator.next();
            try {
                this.refreshType(mWClass);
            }
            catch (ExternalClassNotFoundException externalClassNotFoundException) {
                externalClassLoadFailureListener.externalClassLoadFailure(new ExternalClassLoadFailureEvent(this, mWClass.getName(), externalClassNotFoundException));
            }
        }
    }

    public ExternalClassLoadFailureContainer refreshTypes(Iterator iterator) {
        ExternalClassLoadFailureContainer externalClassLoadFailureContainer = new ExternalClassLoadFailureContainer();
        this.refreshTypes(iterator, externalClassLoadFailureContainer);
        return externalClassLoadFailureContainer;
    }

    private void buildCoreType(MWClass mWClass) {
        try {
            ExternalClassDescription externalClassDescription = this.externalClassDescriptionNamed(mWClass.getName());
            ExternalClass externalClass = externalClassDescription.getExternalClass();
            mWClass.refreshDeclaration(externalClass);
        }
        catch (ExternalClassNotFoundException externalClassNotFoundException) {
            throw new RuntimeException(mWClass.getName(), externalClassNotFoundException);
        }
    }

    void hierarchyChanged(MWClass mWClass) {
        Iterator iterator = this.allSubclassesOf(mWClass);
        while (iterator.hasNext()) {
            ((MWClass)iterator.next()).superclassesChanged();
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRemoved(node);
        }
    }

    @Override
    public void nodeRenamed(Node node) {
        if (node.isDescendantOf(this)) {
            super.nodeRenamed(node);
        }
    }

    @Override
    public void mappingReplaced(MWMapping mWMapping, MWMapping mWMapping2) {
    }

    @Override
    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
    }

    @Override
    public void descriptorUnmapped(Collection collection) {
    }

    @Override
    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.types.size());
        stringBuffer.append(" types/");
        stringBuffer.append(this.userTypes.size());
        stringBuffer.append(" user types");
    }

    @Override
    public Iterator projectSubFileComponents() {
        return this.userTypes();
    }

    @Override
    public void setProjectSubFileComponents(Collection collection) {
        this.setTypes(collection);
    }

    @Override
    public Iterator originalProjectSubFileComponentNames() {
        return this.userTypeNames.iterator();
    }

    @Override
    public void setOriginalProjectSubFileComponentNames(Collection collection) {
        this.userTypeNames = collection;
    }

    @Override
    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator iterator = this.children();
        while (iterator.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object object) {
        if (this.types.containsValue(object)) {
            return false;
        }
        return ((Node)object).isDirtyBranch();
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClassRepository.class);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(CLASSPATH_ENTRIES_LIST);
        xMLCompositeDirectCollectionMapping.setSetMethodName("setClasspathEntriesForTopLink");
        xMLCompositeDirectCollectionMapping.setGetMethodName("getClasspathEntriesForTopLink");
        xMLCompositeDirectCollectionMapping.setXPath("classpath-entries/entry/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping2 = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping2.setAttributeName(USER_TYPE_NAMES_COLLECTION);
        xMLCompositeDirectCollectionMapping2.setSetMethodName("setUserTypeNamesForTopLink");
        xMLCompositeDirectCollectionMapping2.setGetMethodName("getUserTypeNamesForTopLink");
        xMLCompositeDirectCollectionMapping2.useCollectionClass(HashSet.class);
        xMLCompositeDirectCollectionMapping2.setXPath("user-type-names/name/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping2);
        return xMLDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getUserTypeNamesForTopLink() {
        ArrayList<String> arrayList = new ArrayList<String>(this.userTypes.size());
        Set set = this.userTypes;
        synchronized (set) {
            Iterator iterator = this.userTypes.iterator();
            while (iterator.hasNext()) {
                arrayList.add(((MWClass)iterator.next()).getName());
            }
        }
        return CollectionTools.sort(arrayList, (Comparator)Collator.getInstance());
    }

    private void setUserTypeNamesForTopLink(Collection collection) {
        this.userTypeNames = collection;
    }

    private List getClasspathEntriesForTopLink() {
        ArrayList<String> arrayList = new ArrayList<String>(this.classpathEntries.size());
        Iterator iterator = this.classpathEntries.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((String)iterator.next()).replace('\\', '/'));
        }
        return arrayList;
    }

    private void setClasspathEntriesForTopLink(List list) {
        this.classpathEntries = this.convertToClasspathEntries(list);
    }

    private List convertToClasspathEntries(List list) {
        Vector<String> vector = new Vector<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            vector.add(new File((String)iterator.next()).getPath());
        }
        return vector;
    }

    @Override
    public void postProjectBuild() {
        super.postProjectBuild();
        this.configureImpliedStubInterfaces();
    }

    private void configureImpliedStubInterfaces() {
        Iterator iterator = this.types.values().iterator();
        while (iterator.hasNext()) {
            ((MWClass)iterator.next()).configureImpliedStubInterfaces();
        }
    }

    private boolean typeIsUserSupplied(MWClass mWClass) {
        if (mWClass.isStub()) {
            return false;
        }
        return !MWClassRepository.coreClassNamesContains(mWClass.getName());
    }

    public static Iterator coreClassNames() {
        return MWClassRepository.getCoreClassNames().iterator();
    }

    public static boolean coreClassNamesContains(String string) {
        return MWClassRepository.getCoreClassNames().contains(string);
    }

    private static synchronized Set getCoreClassNames() {
        if (coreClassNames == null) {
            coreClassNames = MWClassRepository.buildCoreClassNames();
        }
        return coreClassNames;
    }

    private static Set buildCoreClassNames() {
        HashSet hashSet = new HashSet(10000);
        CollectionTools.addAll(hashSet, MWClass.nonReferenceClassNames());
        List<String> list = MWClassRepository.buildCoreClassLocations();
        Classpath classpath = new Classpath(list);
        classpath.addClassNamesTo(hashSet);
        return hashSet;
    }

    private static List<String> buildCoreClassLocations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < CORE_KEYS.length; ++i) {
            String string = Classpath.locationFor(CORE_KEYS[i]);
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String coreClassNameIgnoreCase(String string) {
        return (String)MWClassRepository.getCoreClassNamesLowerCase().get(string.toLowerCase());
    }

    private static synchronized Map getCoreClassNamesLowerCase() {
        if (coreClassNamesLowerCase == null) {
            coreClassNamesLowerCase = MWClassRepository.buildCoreClassNamesLowerCase();
        }
        return coreClassNamesLowerCase;
    }

    private static Map buildCoreClassNamesLowerCase() {
        Set set = MWClassRepository.getCoreClassNames();
        HashMap<String, String> hashMap = new HashMap<String, String>(set.size());
        for (String string : set) {
            hashMap.put(string.toLowerCase(), string);
        }
        return hashMap;
    }

    public boolean isPersistLastRefresh() {
        return this.persistLastRefresh;
    }

    public void setPersistLastRefresh(boolean bl) {
        if (!bl) {
            Iterator iterator = this.userTypes();
            while (iterator.hasNext()) {
                ((MWClass)iterator.next()).markBranchDirty();
            }
        }
        this.persistLastRefresh = bl;
    }
}

