/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWDeleteQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWInsertQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStringQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWUpdateQuery;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public abstract class MWAbstractCustomQuery
extends MWModel
implements MWRelationalQuery {
    private volatile MWRelationalSpecificQueryOptions relationalOptions;

    protected MWAbstractCustomQuery() {
    }

    MWAbstractCustomQuery(MWQueryManager mWQueryManager) {
        super(mWQueryManager);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.relationalOptions = new MWRelationalSpecificQueryOptions(this);
        this.relationalOptions.setQueryFormatToSql();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.relationalOptions);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractCustomQuery.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWInsertQuery.class, (Object)"insert");
        inheritancePolicy.addClassIndicator(MWDeleteQuery.class, (Object)"delete");
        inheritancePolicy.addClassIndicator(MWUpdateQuery.class, (Object)"update");
        inheritancePolicy.addClassIndicator(MWCustomReadObjectQuery.class, (Object)"read-object");
        inheritancePolicy.addClassIndicator(MWCustomReadAllQuery.class, (Object)"read-all");
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("relationalOptions");
        xMLCompositeObjectMapping.setReferenceClass(MWRelationalSpecificQueryOptions.class);
        xMLCompositeObjectMapping.setXPath("relational-options");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    public void formatSetToEjbql() {
    }

    public void formatSetToSql() {
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this.relationalOptions;
    }

    public String getQueryFormatType() {
        return this.relationalOptions.getQueryFormatType();
    }

    public void setQueryFormatType(String string) {
        this.relationalOptions.setQueryFormatType(string);
    }

    public MWQueryFormat getQueryFormat() {
        return this.relationalOptions.getQueryFormat();
    }

    public void setSQLString(String string) {
        this.setQueryFormatType("sqlFormat");
        ((MWSQLQueryFormat)this.relationalOptions.getQueryFormat()).setQueryString(string);
    }

    public TriStateBoolean isCacheStatement() {
        return this.relationalOptions.isCacheStatement();
    }

    public void setCacheStatement(TriStateBoolean triStateBoolean) {
        this.relationalOptions.setCacheStatement(triStateBoolean);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.relationalOptions.isBindAllParameters();
    }

    public void setBindAllParameters(TriStateBoolean triStateBoolean) {
        this.relationalOptions.setBindAllParameters(triStateBoolean);
    }

    public boolean isPrepare() {
        return this.relationalOptions.isPrepare();
    }

    public void setPrepare(boolean bl) {
        this.relationalOptions.setPrepare(bl);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.relationalOptions.notifyExpressionsToRecalculateQueryables();
    }

    protected abstract DatabaseQuery buildRuntimeQuery();

    public void adjustFromRuntimeQuery(DatabaseQuery databaseQuery) {
        this.relationalOptions.adjustFromRuntime(databaseQuery);
    }

    public void adjustRuntimeQuery(DatabaseQuery databaseQuery) {
        this.relationalOptions.adjustRuntimeQuery(databaseQuery);
    }

    public boolean isContentEmpty() {
        MWQueryFormat mWQueryFormat = this.relationalOptions.getQueryFormat();
        if (mWQueryFormat.getType().equals("sqlFormat") || mWQueryFormat.getType().equals("ejbqlFormat")) {
            return StringTools.stringIsEmpty(((MWStringQueryFormat)mWQueryFormat).getQueryString());
        }
        if (mWQueryFormat.getType().equals("storedProcedure")) {
            return StringTools.stringIsEmpty(((MWStoredProcedureQueryFormat)mWQueryFormat).getProcedure().getName());
        }
        return true;
    }
}

