/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOption;
import org.eclipse.persistence.tools.workbench.mappingsmodel.TopLinkOptionSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalSpecificQueryOptions;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractRelationalReadQuery
extends MWAbstractReadQuery
implements MWRelationalReadQuery {
    private volatile CacheUsageModel cacheUsage;
    private static TopLinkOptionSet cacheUsageOptions;
    private volatile InMemoryQueryIndirectionPolicyModel inMemoryQueryIndirectionPolicy;
    private static TopLinkOptionSet inMemoryQueryIndirectionPolicyOptions;
    private volatile MWRelationalSpecificQueryOptions relationalOptions;
    private List joinedItems;
    public static final String JOINED_ITEMS_LIST = "joinedItems";

    public static synchronized TopLinkOptionSet cacheUsageOptions() {
        if (cacheUsageOptions == null) {
            ArrayList<CacheUsageModel> arrayList = new ArrayList<CacheUsageModel>();
            arrayList.add(new CacheUsageModel("Undefined", "UNDEFINED_CACHE_USAGE_OPTION", -1));
            arrayList.add(new CacheUsageModel("Do Not Check Cache", "DO_NOT_CHECK_CACHE_OPTION", 0));
            arrayList.add(new CacheUsageModel("Check Cache by Exact Primary Key", "CHECK_CACHE_BY_EXACT_PRIMARY_KEY_OPTION", 1));
            arrayList.add(new CacheUsageModel("Check Cache by Primary Key", "CHECK_CACHE_BY_PRIMARY_KEY_OPTION", 2));
            arrayList.add(new CacheUsageModel("Check Cache Then Database", "CHECK_CACHE_THEN_DATABASE_OPTION", 3));
            arrayList.add(new CacheUsageModel("Check Cache Only", "CHECK_CACHE_ONLY_OPTION", 4));
            arrayList.add(new CacheUsageModel("Conform Results in Unit of Work", "CONFORM_RESULTS_IN_UNIT_OF_WORK_OPTION", 5));
            cacheUsageOptions = new TopLinkOptionSet(arrayList);
        }
        return cacheUsageOptions;
    }

    public static synchronized TopLinkOptionSet inMemoryQueryIndirectionPolicyOptions() {
        if (inMemoryQueryIndirectionPolicyOptions == null) {
            ArrayList<InMemoryQueryIndirectionPolicyModel> arrayList = new ArrayList<InMemoryQueryIndirectionPolicyModel>();
            arrayList.add(new InMemoryQueryIndirectionPolicyModel("Throw Indirection Exception", "THROW_INDIRECTION_EXCEPTION_OPTION", 0));
            arrayList.add(new InMemoryQueryIndirectionPolicyModel("Trigger Indirection", "TRIGGER_INDIRECTION_OPTION", 1));
            arrayList.add(new InMemoryQueryIndirectionPolicyModel("Ignore Exception Return Conformed", "IGNORE_EXCEPTION_RETURN_CONFORMED_OPTION", 2));
            arrayList.add(new InMemoryQueryIndirectionPolicyModel("Ignore Exception Return Not Conformed", "IGNORE_EXCEPTION_RETURN_NOT_CONFORMED_OPTION", 3));
            inMemoryQueryIndirectionPolicyOptions = new TopLinkOptionSet(arrayList);
        }
        return inMemoryQueryIndirectionPolicyOptions;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWAbstractRelationalReadQuery.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWAbstractReadQuery.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("cacheUsage");
        xMLDirectMapping.setXPath("cache-usage/text()");
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        MWAbstractRelationalReadQuery.cacheUsageOptions().addConversionValuesForTopLinkTo(objectTypeConverter);
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDirectMapping.setNullValue((Object)MWAbstractRelationalReadQuery.cacheUsageOptions().topLinkOptionForMWModelOption("Undefined"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName("inMemoryQueryIndirectionPolicy");
        xMLDirectMapping2.setXPath("in-memory-query-indirection-policy/text()");
        ObjectTypeConverter objectTypeConverter2 = new ObjectTypeConverter();
        MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().addConversionValuesForTopLinkTo(objectTypeConverter2);
        xMLDirectMapping2.setConverter((Converter)objectTypeConverter2);
        xMLDirectMapping2.setNullValue((Object)MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().topLinkOptionForMWModelOption("Throw Indirection Exception"));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("relationalOptions");
        xMLCompositeObjectMapping.setReferenceClass(MWRelationalSpecificQueryOptions.class);
        xMLCompositeObjectMapping.setXPath("relational-options");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(JOINED_ITEMS_LIST);
        xMLCompositeCollectionMapping.setReferenceClass(MWOrderingItem.class);
        xMLCompositeCollectionMapping.setXPath("joins/joined-item");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLDescriptor;
    }

    MWAbstractRelationalReadQuery() {
    }

    MWAbstractRelationalReadQuery(MWRelationalQueryManager mWRelationalQueryManager, String string) {
        super(mWRelationalQueryManager, string);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.inMemoryQueryIndirectionPolicy = (InMemoryQueryIndirectionPolicyModel)MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().topLinkOptionForMWModelOption("Throw Indirection Exception");
        this.joinedItems = new Vector();
        this.cacheUsage = (CacheUsageModel)MWAbstractRelationalReadQuery.cacheUsageOptions().topLinkOptionForMWModelOption("Undefined");
    }

    protected void initialize(String string) {
        super.initialize(string);
        this.relationalOptions = new MWRelationalSpecificQueryOptions(this);
        this.setDefaultQueryFormat();
    }

    private void setDefaultQueryFormat() {
        if (this.isTopLinkReservedFinder()) {
            this.relationalOptions.setQueryFormatToAutoGenerated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.relationalOptions);
        List list2 = this.joinedItems;
        synchronized (list2) {
            list.addAll(this.joinedItems);
        }
    }

    public void initializeFrom(MWRelationalQuery mWRelationalQuery) {
        super.initializeFrom(mWRelationalQuery);
        this.getRelationalOptions().initializeFrom(mWRelationalQuery.getRelationalOptions());
    }

    public void initializeFrom(MWReadQuery mWReadQuery) {
        super.initializeFrom(mWReadQuery);
        this.initializeFrom((MWRelationalQuery)((Object)mWReadQuery));
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this.relationalOptions;
    }

    public CacheUsageModel getCacheUsage() {
        return this.cacheUsage;
    }

    private CacheUsageModel getCacheUsageFromTopLinkModelOption(int n) {
        ListIterator listIterator = MWAbstractRelationalReadQuery.cacheUsageOptions().toplinkOptions();
        while (listIterator.hasNext()) {
            CacheUsageModel cacheUsageModel = (CacheUsageModel)listIterator.next();
            if ((Integer)cacheUsageModel.getTopLinkModelOption() != n) continue;
            return cacheUsageModel;
        }
        return null;
    }

    public void setCacheUsage(CacheUsageModel cacheUsageModel) {
        CacheUsageModel cacheUsageModel2 = this.cacheUsage;
        this.cacheUsage = cacheUsageModel;
        this.firePropertyChanged("cacheUsage", cacheUsageModel2, this.cacheUsage);
    }

    public void setCacheUsage(String string) {
        this.setCacheUsage((CacheUsageModel)MWAbstractRelationalReadQuery.cacheUsageOptions().topLinkOptionForMWModelOption(string));
    }

    private void setCacheUsage(ObjectLevelReadQuery objectLevelReadQuery) {
        this.setCacheUsage(this.getCacheUsageFromTopLinkModelOption(objectLevelReadQuery.getCacheUsage()));
    }

    public InMemoryQueryIndirectionPolicyModel getInMemoryQueryIndirectionPolicy() {
        return this.inMemoryQueryIndirectionPolicy;
    }

    public void setInMemoryQueryIndirectionPolicy(InMemoryQueryIndirectionPolicyModel inMemoryQueryIndirectionPolicyModel) {
        InMemoryQueryIndirectionPolicyModel inMemoryQueryIndirectionPolicyModel2 = this.inMemoryQueryIndirectionPolicy;
        this.inMemoryQueryIndirectionPolicy = inMemoryQueryIndirectionPolicyModel;
        this.firePropertyChanged("inMemoryQueryIndirectionPolicy", inMemoryQueryIndirectionPolicyModel2, this.inMemoryQueryIndirectionPolicy);
    }

    public void setInMemoryQueryIndirectionPolicy(String string) {
        this.setInMemoryQueryIndirectionPolicy((InMemoryQueryIndirectionPolicyModel)MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().topLinkOptionForMWModelOption(string));
    }

    private void setInMemoryQueryIndirectionPolicy(ObjectLevelReadQuery objectLevelReadQuery) {
        int n = objectLevelReadQuery.getInMemoryQueryIndirectionPolicy().getPolicy();
        ListIterator listIterator = MWAbstractRelationalReadQuery.inMemoryQueryIndirectionPolicyOptions().toplinkOptions();
        while (listIterator.hasNext()) {
            InMemoryQueryIndirectionPolicyModel inMemoryQueryIndirectionPolicyModel = (InMemoryQueryIndirectionPolicyModel)listIterator.next();
            if ((Integer)inMemoryQueryIndirectionPolicyModel.getTopLinkModelOption() != n) continue;
            this.setInMemoryQueryIndirectionPolicy(inMemoryQueryIndirectionPolicyModel);
        }
    }

    public MWJoinedItem addJoinedItem(MWQueryable mWQueryable) {
        if (mWQueryable == null) {
            throw new NullPointerException();
        }
        MWJoinedItem mWJoinedItem = new MWJoinedItem(this, mWQueryable);
        this.addJoinedItem(mWJoinedItem);
        return mWJoinedItem;
    }

    public MWJoinedItem addJoinedItem(Iterator iterator) {
        MWJoinedItem mWJoinedItem = new MWJoinedItem(this, iterator);
        this.addJoinedItem(mWJoinedItem);
        return mWJoinedItem;
    }

    public MWJoinedItem addJoinedItem(Iterator iterator, Iterator iterator2) {
        MWJoinedItem mWJoinedItem = new MWJoinedItem(this, iterator, iterator2);
        this.addJoinedItem(mWJoinedItem);
        return mWJoinedItem;
    }

    public MWJoinedItem addJoinedItem(int n, Iterator iterator, Iterator iterator2) {
        MWJoinedItem mWJoinedItem = new MWJoinedItem(this, iterator, iterator2);
        this.addJoinedItem(n, mWJoinedItem);
        return mWJoinedItem;
    }

    private void addJoinedItem(MWJoinedItem mWJoinedItem) {
        this.addJoinedItem(this.joinedItemsSize(), mWJoinedItem);
    }

    private void addJoinedItem(int n, MWJoinedItem mWJoinedItem) {
        this.addItemToList(n, mWJoinedItem, this.joinedItems, JOINED_ITEMS_LIST);
    }

    public void removeJoinedItem(MWJoinedItem mWJoinedItem) {
        this.removeJoinedItem(this.joinedItems.indexOf(mWJoinedItem));
    }

    public void removeJoinedItem(int n) {
        this.removeItemFromList(n, this.joinedItems, JOINED_ITEMS_LIST);
    }

    public ListIterator joinedItems() {
        return new CloneListIterator(this.joinedItems);
    }

    public int joinedItemsSize() {
        return this.joinedItems.size();
    }

    public int indexOfJoinedItem(MWJoinedItem mWJoinedItem) {
        return this.joinedItems.indexOf(mWJoinedItem);
    }

    public void moveJoinedItemUp(MWJoinedItem mWJoinedItem) {
        int n = this.indexOfJoinedItem(mWJoinedItem);
        this.removeJoinedItem(n);
        this.addJoinedItem(n - 1, mWJoinedItem);
    }

    public void moveJoinedItemDown(MWJoinedItem mWJoinedItem) {
        int n = this.indexOfJoinedItem(mWJoinedItem);
        this.removeJoinedItem(n);
        this.addJoinedItem(n + 1, mWJoinedItem);
    }

    public String getQueryFormatType() {
        return this.relationalOptions.getQueryFormatType();
    }

    public void setQueryFormatType(String string) {
        this.relationalOptions.setQueryFormatType(string);
    }

    public MWQueryFormat getQueryFormat() {
        return this.relationalOptions.getQueryFormat();
    }

    public TriStateBoolean isCacheStatement() {
        return this.relationalOptions.isCacheStatement();
    }

    public void setCacheStatement(TriStateBoolean triStateBoolean) {
        this.relationalOptions.setCacheStatement(triStateBoolean);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.relationalOptions.isBindAllParameters();
    }

    public void setBindAllParameters(TriStateBoolean triStateBoolean) {
        this.relationalOptions.setBindAllParameters(triStateBoolean);
    }

    public boolean isPrepare() {
        return this.relationalOptions.isPrepare();
    }

    public void setPrepare(boolean bl) {
        this.relationalOptions.setPrepare(bl);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        this.relationalOptions.notifyExpressionsToRecalculateQueryables();
    }

    public DatabaseQuery runtimeQuery() {
        ObjectLevelReadQuery objectLevelReadQuery = (ObjectLevelReadQuery)super.runtimeQuery();
        this.getCacheUsage().setMWOptionOnTopLinkObject(objectLevelReadQuery);
        this.getInMemoryQueryIndirectionPolicy().setMWOptionOnTopLinkObject(objectLevelReadQuery);
        this.getRelationalOptions().adjustRuntimeQuery((DatabaseQuery)objectLevelReadQuery);
        ListIterator listIterator = this.joinedItems();
        while (listIterator.hasNext()) {
            ((MWJoinedItem)listIterator.next()).adjustRuntimeQuery(objectLevelReadQuery);
        }
        return objectLevelReadQuery;
    }

    public void adjustFromRuntime(ObjectLevelReadQuery objectLevelReadQuery) {
        super.adjustFromRuntime(objectLevelReadQuery);
        this.setCacheUsage(objectLevelReadQuery);
        this.setInMemoryQueryIndirectionPolicy(objectLevelReadQuery);
        this.getRelationalOptions().adjustFromRuntime((DatabaseQuery)objectLevelReadQuery);
    }

    public static class InMemoryQueryIndirectionPolicyModel
    extends TopLinkOption {
        public InMemoryQueryIndirectionPolicyModel(String string, String string2, int n) {
            super(string, string2, new Integer(n));
        }

        public void setMWOptionOnTopLinkObject(Object object) {
            ((ObjectLevelReadQuery)object).getInMemoryQueryIndirectionPolicy().setPolicy(((Integer)this.getTopLinkModelOption()).intValue());
        }
    }

    public static class CacheUsageModel
    extends TopLinkOption {
        public CacheUsageModel(String string, String string2, int n) {
            super(string, string2, new Integer(n));
        }

        public void setMWOptionOnTopLinkObject(Object object) {
            ((ObjectLevelReadQuery)object).setCacheUsage(((Integer)this.getTopLinkModelOption()).intValue());
        }
    }
}

