/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCompoundExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpression;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWLiteralArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWNullArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryParameterArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryableArgumentParent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Undoable;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWBasicExpression
extends MWExpression
implements MWQueryableArgumentParent {
    private volatile MWQueryableArgument firstArgument;
    public static final String FIRST_ARUGMENT_PROPERTY = "firstArgument";
    private volatile MWArgument secondArgument;
    public static final String SECOND_ARGUMENT_PROPERTY = "secondArgument";
    public static final String EQUAL = "EQUAL";
    public static final String EQUALS_IGNORE_CASE = "EQUALS IGNORE CASE";
    public static final String GREATER_THAN = "GREATER THAN";
    public static final String GREATER_THAN_EQUAL = "GREATER THAN EQUAL";
    public static final String LESS_THAN = "LESS THAN";
    public static final String LESS_THAN_EQUAL = "LESS THAN EQUAL";
    public static final String LIKE = "LIKE";
    public static final String LIKE_IGNORE_CASE = "LIKE IGNORE CASE";
    public static final String NOT_EQUAL = "NOT EQUAL";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String IS_NULL = "IS NULL";
    public static final String NOT_NULL = "NOT NULL";

    protected MWBasicExpression() {
    }

    MWBasicExpression(MWCompoundExpression mWCompoundExpression, String string) {
        super(mWCompoundExpression, string);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.firstArgument);
        list.add(this.secondArgument);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.firstArgument = this.createDefaultQueryableArgument();
        this.secondArgument = this.createDefaultLiteralArgument();
    }

    private MWTableDescriptor getOwningDescriptor() {
        return (MWTableDescriptor)this.getParentQuery().getOwningDescriptor();
    }

    MWQueryableArgument createDefaultQueryableArgument() {
        MWQueryable mWQueryable = this.getOwningDescriptor().firstQueryable();
        return new MWQueryableArgument((MWQueryableArgumentParent)this, mWQueryable);
    }

    void recalculateQueryables() {
        this.getFirstArgument().recalculateQueryables();
        this.getSecondArgument().recalculateQueryables();
    }

    public String displayString() {
        String string = this.getFirstArgument().displayString() + " " + this.getOperatorType();
        string = string + " " + this.getSecondArgument().displayString();
        return string;
    }

    public MWQueryableArgument getFirstArgument() {
        return this.firstArgument;
    }

    public String getIndex() {
        return this.getParentCompoundExpression().getIndex() + Integer.toString(this.getParentCompoundExpression().getIndexOf(this)) + ".";
    }

    public MWQuery getParentQuery() {
        return this.getParentCompoundExpression().getParentQuery();
    }

    public MWCompoundExpression getParentCompoundExpression() {
        return (MWCompoundExpression)this.getParent();
    }

    public MWCompoundExpression getRootCompoundExpression() {
        return this.getParentCompoundExpression().getRootCompoundExpression();
    }

    public MWArgument getSecondArgument() {
        return this.secondArgument;
    }

    private void setSecondArgument(MWArgument mWArgument) {
        if (this.operatorIsUnary(this.getOperatorType()) && !(mWArgument instanceof MWNullArgument)) {
            return;
        }
        MWArgument mWArgument2 = this.getSecondArgument();
        this.secondArgument = mWArgument;
        this.firePropertyChanged(SECOND_ARGUMENT_PROPERTY, mWArgument2, this.getSecondArgument());
        this.getRootCompoundExpression().propertyChanged(this, SECOND_ARGUMENT_PROPERTY, mWArgument2, mWArgument);
    }

    public void setSecondArgumentToLiteral() {
        if (this.getSecondArgument().getType() != "literal") {
            this.setSecondArgument(this.createDefaultLiteralArgument());
        }
    }

    public void setSecondArgumentToParameter() {
        if (this.getSecondArgument().getType() != "parameter") {
            this.setSecondArgument(this.createDefaultQueryParameterArgument());
        }
    }

    public void setSecondArgumentToQueryable() {
        if (this.getSecondArgument().getType() != "queryKey") {
            this.setSecondArgument(this.createDefaultQueryableArgument());
        }
    }

    private MWLiteralArgument createDefaultLiteralArgument() {
        return new MWLiteralArgument(this);
    }

    private MWQueryParameterArgument createDefaultQueryParameterArgument() {
        MWQueryParameter mWQueryParameter = null;
        if (this.getParentQuery().parametersSize() > 0) {
            mWQueryParameter = this.getParentQuery().getParameter(0);
        }
        return new MWQueryParameterArgument(this, mWQueryParameter);
    }

    public void clearExpressions() {
    }

    public void undoChange(String string, Object object, Object object2) {
        super.undoChange(string, object, object2);
        if (string == FIRST_ARUGMENT_PROPERTY) {
            this.setFirstArgument((MWQueryableArgument)object);
        }
        if (string == SECOND_ARGUMENT_PROPERTY) {
            this.setSecondArgument((MWArgument)object);
        }
    }

    public void propertyChanged(Undoable undoable, String string, Object object, Object object2) {
        this.getRootCompoundExpression().propertyChanged(undoable, string, object, object2);
    }

    protected void setFirstArgument(MWQueryableArgument mWQueryableArgument) {
        MWQueryableArgument mWQueryableArgument2 = this.getFirstArgument();
        this.firstArgument = mWQueryableArgument;
        this.firePropertyChanged(FIRST_ARUGMENT_PROPERTY, mWQueryableArgument2, this.getFirstArgument());
        this.getRootCompoundExpression().propertyChanged(this, FIRST_ARUGMENT_PROPERTY, mWQueryableArgument2, mWQueryableArgument);
    }

    private boolean operatorIsUnary(String string) {
        return string == IS_NULL || string == NOT_NULL;
    }

    private boolean operatorTypeHasChangedBetweenBinaryAndUnary(String string, String string2) {
        if (!this.operatorIsUnary(string)) {
            return this.operatorIsUnary(string2);
        }
        return !this.operatorIsUnary(string2);
    }

    public void setOperatorType(String string) {
        String string2 = this.getOperatorType();
        super.setOperatorType(string);
        if (this.operatorTypeHasChangedBetweenBinaryAndUnary(string2, string)) {
            if (this.operatorIsUnary(string)) {
                this.setSecondArgument(new MWNullArgument(this));
            } else {
                this.setSecondArgumentToLiteral();
            }
        }
        if (this.operatorIsStringType()) {
            this.getSecondArgument().operatorTypeChanged();
        }
    }

    public boolean operatorIsStringType() {
        return this.getOperatorType() == EQUALS_IGNORE_CASE || this.getOperatorType() == LIKE || this.getOperatorType() == LIKE_IGNORE_CASE || this.getOperatorType() == NOT_LIKE;
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkReferenceMappingQueryableChosenWithoutUnaryOperatorChosen(list);
    }

    public void addQueryableNullProblemTo(List list) {
        list.add(this.queryableNullProblem());
    }

    private Problem queryableNullProblem() {
        String string = this.getParentQuery().getName();
        String string2 = this.getIndex();
        return this.buildProblem("0249", string2, string);
    }

    public Problem queryableInvalidProblem(MWQueryable mWQueryable) {
        return this.buildProblem("0250", mWQueryable.displayString(), this.getParentQuery().signature());
    }

    public boolean isQueryableValid(MWQueryable mWQueryable) {
        return mWQueryable.isValidForQueryExpression();
    }

    private void checkReferenceMappingQueryableChosenWithoutUnaryOperatorChosen(List list) {
        if (this.checkIfNonLeafQueryableChosenWithoutOperatorIsNullOrNotNull() != null) {
            String string = this.getParentQuery().getName();
            String string2 = this.checkIfNonLeafQueryableChosenWithoutOperatorIsNullOrNotNull().getIndex();
            list.add(this.buildProblem("0251", string2, string));
        }
    }

    private MWBasicExpression checkIfNonLeafQueryableChosenWithoutOperatorIsNullOrNotNull() {
        MWQueryableArgument mWQueryableArgument = this.getFirstArgument();
        if (mWQueryableArgument.getQueryableArgumentElement().getQueryable() != null && mWQueryableArgument.getQueryableArgumentElement().getQueryable().allowsChildren() && this.getOperatorType() != IS_NULL && this.getOperatorType() != NOT_NULL) {
            return this;
        }
        return null;
    }

    public void toString(StringBuffer stringBuffer) {
        super.toString(stringBuffer);
        stringBuffer.append("firstArgument = ");
        stringBuffer.append(this.getFirstArgument());
        stringBuffer.append(", operator = ");
        stringBuffer.append(this.getOperatorType());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWBasicExpression.class);
        xMLDescriptor.getInheritancePolicy().setParentClass(MWExpression.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(FIRST_ARUGMENT_PROPERTY);
        xMLCompositeObjectMapping.setReferenceClass(MWQueryableArgument.class);
        xMLCompositeObjectMapping.setXPath("first-argument");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName(SECOND_ARGUMENT_PROPERTY);
        xMLCompositeObjectMapping2.setReferenceClass(MWArgument.class);
        xMLCompositeObjectMapping2.setXPath("second-argument");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    Expression buildRuntimeExpression(ExpressionBuilder expressionBuilder) {
        Expression expression = this.getFirstArgument().runtimeExpression(expressionBuilder);
        Expression expression2 = this.getSecondArgument().runtimeExpression(expressionBuilder);
        if (this.getOperatorType() == EQUAL) {
            return expression.equal(expression2);
        }
        if (this.getOperatorType() == GREATER_THAN) {
            return expression.greaterThan(expression2);
        }
        if (this.getOperatorType() == GREATER_THAN_EQUAL) {
            return expression.greaterThanEqual(expression2);
        }
        if (this.getOperatorType() == LESS_THAN) {
            return expression.lessThan(expression2);
        }
        if (this.getOperatorType() == LESS_THAN_EQUAL) {
            return expression.lessThanEqual(expression2);
        }
        if (this.getOperatorType() == NOT_EQUAL) {
            return expression.notEqual(expression2);
        }
        if (this.getOperatorType() == EQUALS_IGNORE_CASE) {
            return expression.equalsIgnoreCase(expression2);
        }
        if (this.getOperatorType() == LIKE) {
            return expression.like(expression2);
        }
        if (this.getOperatorType() == LIKE_IGNORE_CASE) {
            return expression.likeIgnoreCase(expression2);
        }
        if (this.getOperatorType() == NOT_LIKE) {
            return expression.notLike(expression2);
        }
        if (this.getOperatorType() == IS_NULL) {
            return expression.isNull();
        }
        if (this.getOperatorType() == NOT_NULL) {
            return expression.notNull();
        }
        throw new IllegalStateException("Operator type: " + this.getOperatorType() + " is not supported");
    }

    static MWBasicExpression convertFromRuntime(MWCompoundExpression mWCompoundExpression, Expression expression) {
        ExpressionOperator expressionOperator = expression.getOperator();
        String string = EQUAL;
        if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(4))) {
            string = EQUAL;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(5))) {
            string = NOT_EQUAL;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(7))) {
            string = LESS_THAN;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(8))) {
            string = LESS_THAN_EQUAL;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(9))) {
            string = GREATER_THAN;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(10))) {
            string = GREATER_THAN_EQUAL;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(11))) {
            string = LIKE;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(12))) {
            string = NOT_LIKE;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(17))) {
            string = IS_NULL;
        } else if (expressionOperator == ExpressionOperator.getOperator((Integer)new Integer(18))) {
            string = NOT_NULL;
        }
        MWBasicExpression mWBasicExpression = new MWBasicExpression(mWCompoundExpression, string);
        if (string == NOT_NULL || string == IS_NULL) {
            Expression expression2 = ((FunctionExpression)expression).getBaseExpression();
            mWBasicExpression.setFirstArgument(MWQueryableArgument.convertFromRuntime(mWBasicExpression, (QueryKeyExpression)expression2));
        } else {
            Expression expression3 = ((RelationExpression)expression).getFirstChild();
            if (expression3.isFunctionExpression()) {
                expression3 = ((FunctionExpression)expression3).getBaseExpression();
                if (mWBasicExpression.getOperatorType() == EQUAL) {
                    mWBasicExpression.setOperatorType(EQUALS_IGNORE_CASE);
                } else {
                    mWBasicExpression.setOperatorType(LIKE_IGNORE_CASE);
                }
            }
            mWBasicExpression.setFirstArgument(MWQueryableArgument.convertFromRuntime(mWBasicExpression, (QueryKeyExpression)expression3));
            Expression expression4 = ((RelationExpression)expression).getSecondChild();
            if (expression4.isFunctionExpression()) {
                expression4 = ((FunctionExpression)expression4).getBaseExpression();
            }
            if (expression4.isQueryKeyExpression()) {
                mWBasicExpression.setSecondArgument(MWQueryableArgument.convertFromRuntime(mWBasicExpression, (QueryKeyExpression)expression4));
            } else if (expression4.isConstantExpression()) {
                mWBasicExpression.setSecondArgument(MWLiteralArgument.convertFromRuntime(mWBasicExpression, (ConstantExpression)expression4));
            } else if (expression4.isParameterExpression()) {
                mWBasicExpression.setSecondArgument(MWQueryParameterArgument.convertFromRuntime(mWBasicExpression, (ParameterExpression)expression4));
            }
        }
        return mWBasicExpression;
    }
}

