/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAutoGeneratedQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWEJBQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWExpressionQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWSQLQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStoredProcedureQueryFormat;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalSpecificQueryOptions
extends MWModel
implements MWRelationalQuery {
    private volatile TriStateBoolean cacheStatement;
    private volatile TriStateBoolean bindAllParameters;
    private volatile boolean prepare;
    private volatile MWQueryFormat queryFormat;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWRelationalSpecificQueryOptions.class);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("queryFormat");
        xMLCompositeObjectMapping.setReferenceClass(MWQueryFormat.class);
        xMLCompositeObjectMapping.setXPath("format");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping("bindAllParameters", "getBindAllParametersForTopLink", "setBindAllParametersForTopLink", "bind-all-parameters/text()");
        xMLDirectMapping.setNullValue(null);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("cacheStatement", "getCacheStatementForTopLink", "setCacheStatementForTopLink", "cache-statement/text()");
        xMLDirectMapping2.setNullValue(null);
        ((XMLDirectMapping)xMLDescriptor.addDirectMapping("prepare", "prepare/text()")).setNullValue((Object)Boolean.TRUE);
        return xMLDescriptor;
    }

    private MWRelationalSpecificQueryOptions() {
    }

    MWRelationalSpecificQueryOptions(MWRelationalQuery mWRelationalQuery) {
        super(mWRelationalQuery);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.cacheStatement = TriStateBoolean.UNDEFINED;
        this.bindAllParameters = TriStateBoolean.TRUE;
        this.prepare = true;
        this.queryFormat = new MWExpressionQueryFormat(this);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.queryFormat);
    }

    public MWAbstractQuery getQuery() {
        return (MWAbstractQuery)this.getParent();
    }

    void initializeFrom(MWRelationalSpecificQueryOptions mWRelationalSpecificQueryOptions) {
        this.setCacheStatement(mWRelationalSpecificQueryOptions.isCacheStatement());
        this.setBindAllParameters(mWRelationalSpecificQueryOptions.isBindAllParameters());
        this.setPrepare(mWRelationalSpecificQueryOptions.isPrepare());
        this.setQueryFormat(mWRelationalSpecificQueryOptions.getQueryFormat());
        this.getQueryFormat().setParent(this);
    }

    public TriStateBoolean isBindAllParameters() {
        return this.bindAllParameters;
    }

    public void setBindAllParameters(TriStateBoolean triStateBoolean) {
        TriStateBoolean triStateBoolean2 = this.isBindAllParameters();
        this.bindAllParameters = triStateBoolean;
        this.firePropertyChanged("bindAllParameters", triStateBoolean2, triStateBoolean);
    }

    public TriStateBoolean isCacheStatement() {
        return this.cacheStatement;
    }

    public void setCacheStatement(TriStateBoolean triStateBoolean) {
        TriStateBoolean triStateBoolean2 = this.isCacheStatement();
        this.cacheStatement = triStateBoolean;
        this.firePropertyChanged("cacheStatement", triStateBoolean2, triStateBoolean);
    }

    public boolean isPrepare() {
        return this.prepare;
    }

    public void setPrepare(boolean bl) {
        boolean bl2 = this.isPrepare();
        this.prepare = bl;
        this.firePropertyChanged("prepare", bl2, bl);
    }

    public MWQueryFormat getQueryFormat() {
        return this.queryFormat;
    }

    public String getQueryFormatType() {
        return this.queryFormat.getType();
    }

    public void setQueryFormatType(String string) {
        String string2 = this.getQueryFormatType();
        if (string2 == string) {
            return;
        }
        if (string == "expressionFormat") {
            this.setQueryFormatToExpression();
        } else if (string == "autoGenerateFormat") {
            this.setQueryFormatToAutoGenerated();
        } else if (string == "sqlFormat") {
            this.setQueryFormatToSql();
        } else if (string == "ejbqlFormat") {
            this.setQueryFormatToEjbql();
        } else if (string == "storedProcedure") {
            this.setQueryFormatToStoredProcedure();
        } else {
            throw new IllegalArgumentException("queryFormatType must be set to : MWQuery.EXPRESSION_FORMAT, MWQuery.AUTO_GENERATED_FORMAT, MWQuery.SQL_FORMAT, MWQuery.STORED_PROCEDURE_FORMAT, or MWQuery.EJBQL_FORMAT");
        }
        this.firePropertyChanged("queryFormatType", string2, this.getQueryFormatType());
    }

    private void setDefaultQueryFormat() {
        this.setQueryFormat(new MWExpressionQueryFormat(this));
    }

    MWAutoGeneratedQueryFormat setQueryFormatToAutoGenerated() {
        MWAutoGeneratedQueryFormat mWAutoGeneratedQueryFormat = new MWAutoGeneratedQueryFormat(this);
        this.setQueryFormat(mWAutoGeneratedQueryFormat);
        return mWAutoGeneratedQueryFormat;
    }

    void setQueryFormatToEjbql() {
        MWEJBQLQueryFormat mWEJBQLQueryFormat = new MWEJBQLQueryFormat(this);
        this.setQueryFormat(mWEJBQLQueryFormat);
        ((MWRelationalQuery)this.getParent()).formatSetToEjbql();
    }

    void setQueryFormatToExpression() {
        MWExpressionQueryFormat mWExpressionQueryFormat = new MWExpressionQueryFormat(this);
        this.setQueryFormat(mWExpressionQueryFormat);
    }

    void setQueryFormatToStoredProcedure() {
        MWStoredProcedureQueryFormat mWStoredProcedureQueryFormat = new MWStoredProcedureQueryFormat(this);
        this.setQueryFormat(mWStoredProcedureQueryFormat);
    }

    void setQueryFormatToSql() {
        MWSQLQueryFormat mWSQLQueryFormat = new MWSQLQueryFormat(this);
        this.setQueryFormat(mWSQLQueryFormat);
        ((MWRelationalQuery)this.getParent()).formatSetToSql();
    }

    private void setQueryFormat(MWQueryFormat mWQueryFormat) {
        this.queryFormat = mWQueryFormat;
    }

    public void notifyExpressionsToRecalculateQueryables() {
        if (this.getQueryFormat().getExpression() != null) {
            this.getQueryFormat().getExpression().recalculateQueryables();
        }
    }

    public MWRelationalSpecificQueryOptions getRelationalOptions() {
        return this;
    }

    public void formatSetToEjbql() {
    }

    public void formatSetToSql() {
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkCachesStatementButDoesNotBindParameters(list);
    }

    private void checkCachesStatementButDoesNotBindParameters(List list) {
        if (this.isCacheStatement().isTrue()) {
            if (this.isBindAllParameters().isUndefined()) {
                MWRelationalProject mWRelationalProject = (MWRelationalProject)this.getProject();
                if (!((MWRelationalProjectDefaultsPolicy)mWRelationalProject.getDefaultsPolicy()).shouldQueriesBindAllParameters()) {
                    list.add(this.buildProblem("0241", this.getQuery().getName()));
                }
            } else if (this.isBindAllParameters().isFalse()) {
                list.add(this.buildProblem("0241", this.getQuery().getName()));
            }
        }
    }

    void adjustRuntimeQuery(DatabaseQuery databaseQuery) {
        databaseQuery.setShouldPrepare(this.isPrepare());
        if (!this.isBindAllParameters().isUndefined()) {
            databaseQuery.setShouldBindAllParameters(this.isBindAllParameters().booleanValue());
        }
        if (!this.isCacheStatement().isUndefined()) {
            databaseQuery.setShouldCacheStatement(this.isCacheStatement().booleanValue());
        }
        this.getQueryFormat().convertToRuntime(databaseQuery);
    }

    public void adjustFromRuntime(DatabaseQuery databaseQuery) {
        this.setPrepare(databaseQuery.shouldPrepare());
        if (!databaseQuery.shouldIgnoreBindAllParameters()) {
            this.setBindAllParameters(new TriStateBoolean(databaseQuery.shouldBindAllParameters()));
        } else {
            this.setBindAllParameters(TriStateBoolean.UNDEFINED);
        }
        if (!databaseQuery.shouldIgnoreCacheStatement()) {
            this.setCacheStatement(new TriStateBoolean(databaseQuery.shouldCacheStatement()));
        } else {
            this.setCacheStatement(TriStateBoolean.UNDEFINED);
        }
        this.setDefaultQueryFormat();
        if (databaseQuery.getSQLString() != null) {
            this.setQueryFormatToSql();
        } else if (databaseQuery.getEJBQLString() != null) {
            this.setQueryFormatToEjbql();
        }
        this.getQueryFormat().convertFromRuntime(databaseQuery);
    }

    private Boolean getBindAllParametersForTopLink() {
        return this.bindAllParameters.getValue();
    }

    void setBindAllParametersForTopLink(Boolean bl) {
        this.bindAllParameters = new TriStateBoolean(bl);
    }

    private Boolean getCacheStatementForTopLink() {
        return this.cacheStatement.getValue();
    }

    private void setCacheStatementForTopLink(Boolean bl) {
        this.cacheStatement = new TriStateBoolean(bl);
    }
}

