/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.opti.AttrImpl;
import org.apache.xerces.impl.xs.opti.ElementImpl;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.impl.xs.opti.SchemaDOMParser;
import org.apache.xerces.impl.xs.opti.SchemaParsingConfig;
import org.apache.xerces.util.URI;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSException;
import org.apache.xerces.xs.XSModel;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaClassPathReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaFileReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.oxm.schema.XMLSchemaURLReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWNominative;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.QName;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ClasspathResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.FileResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.ResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.resource.UrlResourceSpecification;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamespace;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchemaRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;
import org.w3c.dom.NamedNodeMap;

public final class MWXmlSchema
extends MWModel
implements MWNominative {
    public static final int INFINITY = 0x7FFFFFF8;
    private boolean shouldUseDefaultNamespace;
    public static final String SHOULD_USE_DEFAULT_NAMESPACE = "shouldUseDefaultNamespace";
    private String defaultNamespaceUrl;
    public static final String DEFAULT_NAMESPACE_URL = "defaultNamespaceUrl";
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile ResourceSpecification schemaSource;
    public static final String SCHEMA_SOURCE_PROPERTY = "schemaSource";
    private volatile String targetNamespaceUrl;
    private Collection declaredNamespaces;
    public static final String NAMESPACES_COLLECTION = "namespaces";
    private List builtInNamespaces;

    public static MWXmlSchema createFromFile(MWXmlSchemaRepository mWXmlSchemaRepository, String string, String string2) {
        MWXmlSchema mWXmlSchema = new MWXmlSchema(mWXmlSchemaRepository, string);
        mWXmlSchema.setSchemaSource(new FileResourceSpecification(mWXmlSchema, string2));
        return mWXmlSchema;
    }

    public static MWXmlSchema createFromUrl(MWXmlSchemaRepository mWXmlSchemaRepository, String string, String string2) {
        MWXmlSchema mWXmlSchema = new MWXmlSchema(mWXmlSchemaRepository, string);
        mWXmlSchema.setSchemaSource(new UrlResourceSpecification(mWXmlSchema, string2));
        return mWXmlSchema;
    }

    public static MWXmlSchema createFromClasspath(MWXmlSchemaRepository mWXmlSchemaRepository, String string, String string2) {
        MWXmlSchema mWXmlSchema = new MWXmlSchema(mWXmlSchemaRepository, string);
        mWXmlSchema.setSchemaSource(new ClasspathResourceSpecification(mWXmlSchema, string2));
        return mWXmlSchema;
    }

    private MWXmlSchema() {
    }

    private MWXmlSchema(MWModel mWModel) {
        super(mWModel);
    }

    private MWXmlSchema(MWModel mWModel, String string) {
        this(mWModel);
        this.initialize(string);
    }

    protected void initialize() {
        super.initialize();
        this.initializeBuiltInNamespaces();
    }

    private void initializeBuiltInNamespaces() {
        this.builtInNamespaces = new Vector();
        this.builtInNamespaces.add(MWNamespace.xsdNamespace(this));
        this.builtInNamespaces.add(MWNamespace.xsiNamespace(this));
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.targetNamespaceUrl = "";
        this.defaultNamespaceUrl = "";
        this.shouldUseDefaultNamespace = false;
        this.declaredNamespaces = new HashBag();
    }

    private void initialize(String string) {
        this.name = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.schemaSource);
        Collection collection = this.declaredNamespaces;
        synchronized (collection) {
            list.addAll(this.declaredNamespaces);
        }
        collection = this.builtInNamespaces;
        synchronized (collection) {
            list.addAll(this.builtInNamespaces);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.name;
        this.name = string;
        if (this.attributeValueHasChanged(string2, string)) {
            try {
                this.schemaRepository().schemaRenamed(string2, string, this);
            }
            catch (RuntimeException runtimeException) {
                this.name = string2;
                throw runtimeException;
            }
            this.firePropertyChanged(NAME_PROPERTY, string2, string);
            this.getProject().nodeRenamed(this);
        }
    }

    public ResourceSpecification getSchemaSource() {
        return this.schemaSource;
    }

    private void setSchemaSource(ResourceSpecification resourceSpecification) {
        ResourceSpecification resourceSpecification2 = this.schemaSource;
        this.schemaSource = resourceSpecification;
        this.firePropertyChanged(SCHEMA_SOURCE_PROPERTY, resourceSpecification2, resourceSpecification);
    }

    public void setFileSchemaLocation(String string) {
        this.setSchemaSource(new FileResourceSpecification(this, string));
    }

    public void setUrlSchemaLocation(String string) {
        this.setSchemaSource(new UrlResourceSpecification(this, string));
    }

    public void setClasspathSchemaLocation(String string) {
        this.setSchemaSource(new ClasspathResourceSpecification(this, string));
    }

    public String targetNamespaceUrl() {
        return this.targetNamespaceUrl;
    }

    public void setTargetNamespaceUrl(String string) {
        this.targetNamespaceUrl = string;
        if ("".equals(this.defaultNamespaceUrl)) {
            this.defaultNamespaceUrl = this.targetNamespaceUrl;
        }
    }

    public Iterator declaredNamespaces() {
        return this.declaredNamespaces.iterator();
    }

    private MWNamespace declaredNamespace(String string) {
        Iterator iterator = this.declaredNamespaces();
        while (iterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)iterator.next();
            if (!mWNamespace.getNamespaceUrl().equals(string)) continue;
            return mWNamespace;
        }
        return null;
    }

    private MWNamespace addDeclaredNamespace(String string) {
        MWNamespace mWNamespace = new MWNamespace(this);
        this.addDeclaredNamespace(mWNamespace);
        return mWNamespace;
    }

    private void addDeclaredNamespace(MWNamespace mWNamespace) {
        this.declaredNamespaces.add(mWNamespace);
        this.fireItemAdded(NAMESPACES_COLLECTION, mWNamespace);
    }

    private void removeDeclaredNamespace(MWNamespace mWNamespace) {
        this.declaredNamespaces.remove(mWNamespace);
        this.fireItemRemoved(NAMESPACES_COLLECTION, mWNamespace);
        this.getProject().nodeRemoved(mWNamespace);
    }

    public MWNamespace targetNamespace() {
        return this.declaredNamespace(this.targetNamespaceUrl());
    }

    public Iterator importedNamespaces() {
        return new FilteringIterator(this.declaredNamespaces()){

            protected boolean accept(Object object) {
                return !((MWNamespace)object).isTargetNamespace();
            }
        };
    }

    public ListIterator builtInNamespaces() {
        return this.builtInNamespaces.listIterator();
    }

    private MWNamespace builtInNamespace(String string) {
        ListIterator listIterator = this.builtInNamespaces();
        while (listIterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)listIterator.next();
            if (!mWNamespace.getNamespaceUrl().equals(string)) continue;
            return mWNamespace;
        }
        return null;
    }

    public MWXmlSchemaRepository schemaRepository() {
        return (MWXmlSchemaRepository)this.getParent();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }

    private Iterator namespaces() {
        return new CompositeIterator(this.declaredNamespaces(), (Iterator)this.builtInNamespaces());
    }

    public String namespaceUrlForPrefix(String string) {
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)iterator.next();
            if (!string.equals(mWNamespace.getNamespacePrefix())) continue;
            return mWNamespace.getNamespaceUrl();
        }
        return "";
    }

    public String namespacePrefixForUrl(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        return this.namespaceForUrl(string).getNamespacePrefix();
    }

    public MWNamespace namespaceForUrl(String string) {
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)iterator.next();
            if (!mWNamespace.getNamespaceUrl().equals(string)) continue;
            return mWNamespace;
        }
        return null;
    }

    public int attributeCount() {
        int n = 0;
        Iterator iterator = this.declaredNamespaces();
        while (iterator.hasNext()) {
            n += ((MWNamespace)iterator.next()).attributeCount();
        }
        return n;
    }

    public MWAttributeDeclaration attribute(String string) {
        return this.attribute(this.targetNamespaceUrl, string);
    }

    public MWAttributeDeclaration attribute(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(string).attribute(string2);
    }

    public int elementCount() {
        int n = 0;
        Iterator iterator = this.declaredNamespaces();
        while (iterator.hasNext()) {
            n += ((MWNamespace)iterator.next()).elementCount();
        }
        return n;
    }

    public MWElementDeclaration element(String string) {
        return this.element(this.targetNamespaceUrl, string);
    }

    public MWElementDeclaration element(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(string).element(string2);
    }

    public int typeCount() {
        int n = 0;
        Iterator iterator = this.declaredNamespaces();
        while (iterator.hasNext()) {
            n += ((MWNamespace)iterator.next()).typeCount();
        }
        return n;
    }

    public MWComplexTypeDefinition complexType(String string) {
        return this.complexType(this.targetNamespaceUrl, string);
    }

    public MWComplexTypeDefinition complexType(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(string).complexType(string2);
    }

    public Iterator complexTypes() {
        return new CompositeIterator(this.complexTypeIterators());
    }

    private Iterator complexTypeIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            protected Object transform(Object object) {
                return ((MWNamespace)object).complexTypes();
            }
        };
    }

    public MWSimpleTypeDefinition simpleType(String string) {
        return this.simpleType(this.targetNamespaceUrl, string);
    }

    public MWSimpleTypeDefinition simpleType(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(string).simpleType(string2);
    }

    public Iterator simpleTypes() {
        return new CompositeIterator(this.simpleTypeIterators());
    }

    private Iterator simpleTypeIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            protected Object transform(Object object) {
                return ((MWNamespace)object).simpleTypes();
            }
        };
    }

    public int modelGroupDefinitionCount() {
        int n = 0;
        Iterator iterator = this.declaredNamespaces();
        while (iterator.hasNext()) {
            n += ((MWNamespace)iterator.next()).modelGroupDefinitionsCount();
        }
        return n;
    }

    public MWModelGroupDefinition modelGroupDefinition(String string) {
        return this.modelGroupDefinition(this.targetNamespaceUrl, string);
    }

    public MWModelGroupDefinition modelGroupDefinition(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = this.targetNamespaceUrl();
        }
        return this.namespaceForUrl(string).modelGroupDefinition(string2);
    }

    public MWModelGroup modelGroup(String string) {
        return this.modelGroup(this.targetNamespaceUrl, string);
    }

    public MWModelGroup modelGroup(String string, String string2) {
        if (string == null || "".equals(string)) {
            string = this.targetNamespaceUrl();
        }
        return this.modelGroupDefinition(string, string2).getModelGroup();
    }

    public Iterator structuralComponents() {
        return new CompositeIterator(this.structuralComponentIterators());
    }

    private Iterator structuralComponentIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            protected Object transform(Object object) {
                return ((MWNamespace)object).structuralComponents();
            }
        };
    }

    public Iterator contextComponents() {
        return new CompositeIterator(this.contextComponentIterators());
    }

    private Iterator contextComponentIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            protected Object transform(Object object) {
                return ((MWNamespace)object).contextComponents();
            }
        };
    }

    public Iterator rootElements() {
        return new CompositeIterator(this.rootElementIterators());
    }

    private Iterator rootElementIterators() {
        return new TransformationIterator(this.declaredNamespaces()){

            protected Object transform(Object object) {
                return ((MWNamespace)object).elements();
            }
        };
    }

    public MWNamedSchemaComponent component(QName qName) {
        if (qName.getComponentType() == "attribute") {
            return this.attribute(qName.getNamespaceURI(), qName.getLocalName());
        }
        if (qName.getComponentType() == "element") {
            return this.element(qName.getNamespaceURI(), qName.getLocalName());
        }
        if (qName.getComponentType() == "complex-type") {
            return this.complexType(qName.getNamespaceURI(), qName.getLocalName());
        }
        if (qName.getComponentType() == "group") {
            return this.modelGroupDefinition(qName.getNamespaceURI(), qName.getLocalName());
        }
        return null;
    }

    public void reload() throws ResourceException {
        URI uRI = this.schemaSource.validResourceURI();
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        XSModel xSModel = null;
        XMLInputSource xMLInputSource = new XMLInputSource(null, uRI.toString(), null);
        SchemaDOMParser schemaDOMParser = new SchemaDOMParser((XMLParserConfiguration)new SchemaParsingConfig());
        try {
            xSModel = xMLSchemaLoader.loadURI(uRI.toString());
            schemaDOMParser.parse(xMLInputSource);
        }
        catch (Throwable throwable) {
            if (throwable instanceof XSException) {
                throw (XSException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        SchemaDOM schemaDOM = (SchemaDOM)schemaDOMParser.getDocument2();
        this.reload(xSModel, schemaDOM);
        this.fireStateChanged();
        ((MWXmlProject)this.getProject()).schemaChanged(SchemaChange.schemaStructureChange(this));
        this.reloadSchemaPrefixes(schemaDOM);
    }

    private void reload(XSModel xSModel, SchemaDOM schemaDOM) {
        Collection collection = CollectionTools.collection(this.declaredNamespaces());
        this.reloadTargetNamespace(xSModel, schemaDOM, collection);
        StringList stringList = xSModel.getNamespaces();
        for (int i = 0; i < stringList.getLength(); ++i) {
            String string = stringList.item(i);
            if (string == null || string.equals(this.targetNamespaceUrl()) || string.equals("http://www.w3.org/2001/XMLSchema")) continue;
            this.reloadImportedNamespace(xSModel, schemaDOM, string, collection);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeDeclaredNamespace((MWNamespace)iterator.next());
        }
        this.resolveReferences();
    }

    private void reloadTargetNamespace(XSModel xSModel, SchemaDOM schemaDOM, Collection collection) {
        String string = "";
        String string2 = schemaDOM.getDocumentElement().getAttribute("targetNamespace");
        if (string2 != null && string2 != "") {
            string = string2;
        }
        MWNamespace mWNamespace = this.targetNamespace();
        this.setTargetNamespaceUrl(string);
        this.reloadNamespace(xSModel, schemaDOM, mWNamespace, string, collection);
        mWNamespace = this.targetNamespace();
        if (mWNamespace.getNamespacePrefix().equals("")) {
            mWNamespace.setDeclared(false);
        }
    }

    private void reloadImportedNamespace(XSModel xSModel, SchemaDOM schemaDOM, String string, Collection collection) {
        MWNamespace mWNamespace = this.declaredNamespace(string);
        this.reloadNamespace(xSModel, schemaDOM, mWNamespace, string, collection);
    }

    private void reloadNamespace(XSModel xSModel, SchemaDOM schemaDOM, MWNamespace mWNamespace, String string, Collection collection) {
        if (mWNamespace == null) {
            mWNamespace = this.addDeclaredNamespace(string);
        } else {
            collection.remove(mWNamespace);
        }
        mWNamespace.reload(xSModel, schemaDOM, string);
    }

    private void reloadSchemaPrefixes(SchemaDOM schemaDOM) {
        ElementImpl elementImpl = (ElementImpl)schemaDOM.getDocumentElement();
        NamedNodeMap namedNodeMap = elementImpl.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            MWNamespace mWNamespace;
            AttrImpl attrImpl = (AttrImpl)namedNodeMap.item(i);
            String string = attrImpl.getLocalName();
            String string2 = attrImpl.getValue();
            String string3 = attrImpl.getNamespaceURI();
            if (string3 != "http://www.w3.org/2000/xmlns/" || string == "xmlns" || (mWNamespace = this.namespaceForUrl(string2)) == null) continue;
            mWNamespace.setNamespacePrefixFromSchemaDoc(string);
        }
    }

    public void resolveReferences() {
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            ((MWNamespace)iterator.next()).resolveReferences();
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkRequiredNamespacePrefix(list);
        this.checkDuplicateNamespacePrefix(list);
        this.checkSpacesinNamespacePrefix(list);
    }

    private void checkSpacesinNamespacePrefix(List list) {
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)iterator.next();
            if ("".equals(mWNamespace.getNamespaceUrl()) || !StringTools.contains(mWNamespace.getNamespacePrefix(), " ", '\u0000')) continue;
            list.add(this.buildProblem("0802", mWNamespace.getNamespaceUrlForDisplay()));
        }
    }

    private void checkRequiredNamespacePrefix(List list) {
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)iterator.next();
            if ("".equals(mWNamespace.getNamespaceUrl()) || !"".equals(mWNamespace.getNamespacePrefix()) || mWNamespace.getNamespaceUrl().equals(this.defaultNamespaceUrl)) continue;
            list.add(this.buildProblem("0800", mWNamespace.getNamespaceUrlForDisplay()));
        }
    }

    private void checkDuplicateNamespacePrefix(List list) {
        String string;
        HashBag hashBag = new HashBag();
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            string = ((MWNamespace)iterator.next()).getNamespacePrefix();
            if ("".equals(string)) continue;
            hashBag.add(string);
        }
        iterator = hashBag.uniqueIterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (hashBag.count(string) <= 1) continue;
            list.add(this.buildProblem("0801", string));
        }
    }

    public XMLSchemaReference runtimeSchemaReference() {
        if (this.schemaSource instanceof ClasspathResourceSpecification) {
            return new XMLSchemaClassPathReference(this.schemaSource.getLocation());
        }
        if (this.schemaSource instanceof FileResourceSpecification) {
            return new XMLSchemaFileReference(this.schemaSource.getLocation());
        }
        if (this.schemaSource instanceof UrlResourceSpecification) {
            return new XMLSchemaURLReference(this.schemaSource.getLocation());
        }
        return null;
    }

    public NamespaceResolver runtimeNamespaceResolver() {
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        Iterator iterator = this.namespaces();
        while (iterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)iterator.next();
            if (!mWNamespace.isDeclared() || "".equals(mWNamespace.getNamespacePrefix())) continue;
            namespaceResolver.put(mWNamespace.getNamespacePrefix(), mWNamespace.getNamespaceUrl());
        }
        if (this.shouldUseDefaultNamespace() && !"".equals(this.getDefaultNamespaceUrl())) {
            namespaceResolver.setDefaultNamespaceURI(this.getDefaultNamespaceUrl());
        }
        return namespaceResolver;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWXmlSchema.class);
        xMLDescriptor.setDefaultRootElement("xml-schema");
        xMLDescriptor.addDirectMapping(NAME_PROPERTY, "name/text()");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("targetNamespaceUrl");
        xMLDirectMapping.setXPath("target-namespace-url/text()");
        xMLDirectMapping.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = new XMLDirectMapping();
        xMLDirectMapping2.setAttributeName(DEFAULT_NAMESPACE_URL);
        xMLDirectMapping2.setXPath("default-namespace-url/text()");
        xMLDirectMapping2.setNullValue((Object)"");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping2);
        XMLDirectMapping xMLDirectMapping3 = new XMLDirectMapping();
        xMLDirectMapping3.setAttributeName(SHOULD_USE_DEFAULT_NAMESPACE);
        xMLDirectMapping3.setXPath("should-default-namespace-url/text()");
        xMLDirectMapping3.setNullValue((Object)false);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping3);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(SCHEMA_SOURCE_PROPERTY);
        xMLCompositeObjectMapping.setXPath("schema-source");
        xMLCompositeObjectMapping.setReferenceClass(ResourceSpecification.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName("builtInNamespaces");
        xMLCompositeCollectionMapping.setGetMethodName("getPersistedBuiltInNamespacesForTopLink");
        xMLCompositeCollectionMapping.setSetMethodName("setPersistedBuiltInNamespacesForTopLink");
        xMLCompositeCollectionMapping.setXPath("built-in-namespaces/namespace");
        xMLCompositeCollectionMapping.setReferenceClass(BuiltInNamespace.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping2 = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping2.setAttributeName("declaredNamespaces");
        xMLCompositeCollectionMapping2.setGetMethodName("getDeclaredNamespacesForToplink");
        xMLCompositeCollectionMapping2.setSetMethodName("setDeclaredNamespacesForToplink");
        xMLCompositeCollectionMapping2.setXPath("declared-namespaces/namespace");
        xMLCompositeCollectionMapping2.setReferenceClass(MWNamespace.class);
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping2);
        return xMLDescriptor;
    }

    private Collection getPersistedBuiltInNamespacesForTopLink() {
        Vector<BuiltInNamespace> vector = new Vector<BuiltInNamespace>();
        ListIterator listIterator = this.builtInNamespaces();
        while (listIterator.hasNext()) {
            MWNamespace mWNamespace = (MWNamespace)listIterator.next();
            BuiltInNamespace builtInNamespace = new BuiltInNamespace();
            builtInNamespace.url = mWNamespace.getNamespaceUrl();
            builtInNamespace.prefix = mWNamespace.getNamespacePrefix();
            builtInNamespace.declared = mWNamespace.isDeclared();
            vector.add(builtInNamespace);
        }
        return vector;
    }

    private void setPersistedBuiltInNamespacesForTopLink(Collection collection) {
        for (BuiltInNamespace builtInNamespace : collection) {
            String string = builtInNamespace.url;
            String string2 = builtInNamespace.prefix;
            boolean bl = builtInNamespace.declared;
            MWNamespace mWNamespace = this.builtInNamespace(string);
            mWNamespace.setNamespacePrefixFromSchemaDocForTopLink(string2);
            mWNamespace.setNamespaceIsDeclaredFromSchemaDocForTopLink(bl);
        }
    }

    private Collection getDeclaredNamespacesForToplink() {
        return CollectionTools.sortedSet(this.declaredNamespaces());
    }

    private void setDeclaredNamespacesForToplink(Collection collection) {
        this.declaredNamespaces = collection;
    }

    public String getDefaultNamespaceUrl() {
        return this.defaultNamespaceUrl;
    }

    public void setDefaultNamespaceUrl(String string) {
        String string2 = this.defaultNamespaceUrl;
        this.defaultNamespaceUrl = string;
        this.firePropertyChanged(DEFAULT_NAMESPACE_URL, string2, string);
    }

    public boolean shouldUseDefaultNamespace() {
        return this.shouldUseDefaultNamespace;
    }

    public void setShouldUseDefaultNamespace(boolean bl) {
        boolean bl2 = this.shouldUseDefaultNamespace;
        this.shouldUseDefaultNamespace = bl;
        this.firePropertyChanged(SHOULD_USE_DEFAULT_NAMESPACE, bl2, bl);
    }

    public static class BuiltInNamespace {
        String url;
        String prefix;
        Boolean declared;

        public static XMLDescriptor buildDescriptor() {
            XMLDescriptor xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setJavaClass(BuiltInNamespace.class);
            ((AbstractDirectMapping)xMLDescriptor.addDirectMapping("url", "@url")).setNullValue((Object)"");
            ((AbstractDirectMapping)xMLDescriptor.addDirectMapping("prefix", "@prefix")).setNullValue((Object)"");
            ((AbstractDirectMapping)xMLDescriptor.addDirectMapping("declared", "@declared")).setNullValue((Object)Boolean.FALSE);
            return xMLDescriptor;
        }

        private BuiltInNamespace() {
        }
    }
}

