/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalForeignKey;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.jdbc.JDBCExternalTableDescription;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class JDBCExternalTable
implements ExternalTable {
    private final JDBCExternalTableDescription tableDescription;
    private final JDBCExternalColumn[] columns;
    private final ExternalForeignKey[] foreignKeys;
    private static final JDBCExternalForeignKey[] EMPTY_FOREIGN_KEYS = new JDBCExternalForeignKey[0];

    JDBCExternalTable(JDBCExternalTableDescription jDBCExternalTableDescription) throws SQLException {
        this.tableDescription = jDBCExternalTableDescription;
        this.columns = this.buildColumns();
        this.markPrimaryKeyColumns();
        this.foreignKeys = this.buildForeignKeys();
    }

    private JDBCExternalColumn[] buildColumns() throws SQLException {
        ArrayList<JDBCExternalColumn> arrayList = new ArrayList<JDBCExternalColumn>();
        ResultSet resultSet = this.metaData().getColumns(this.tableDescription.getCatalogName(), this.tableDescription.getSchemaName(), this.tableDescription.getName(), null);
        while (resultSet.next()) {
            arrayList.add(new JDBCExternalColumn(resultSet));
        }
        resultSet.close();
        return arrayList.toArray(new JDBCExternalColumn[arrayList.size()]);
    }

    private void markPrimaryKeyColumns() {
        Collection collection = this.primaryKeyColumnNames();
        int n = this.columns.length;
        while (n-- > 0) {
            JDBCExternalColumn jDBCExternalColumn = this.columns[n];
            jDBCExternalColumn.setPrimaryKey(collection.contains(jDBCExternalColumn.getName()));
        }
    }

    private Collection primaryKeyColumnNames() {
        try {
            return this.primaryKeyColumnNames2();
        }
        catch (SQLException sQLException) {
            return Collections.EMPTY_SET;
        }
    }

    private Collection primaryKeyColumnNames2() throws SQLException {
        HashSet<String> hashSet = new HashSet<String>();
        ResultSet resultSet = this.metaData().getPrimaryKeys(this.tableDescription.getCatalogName(), this.tableDescription.getSchemaName(), this.tableDescription.getName());
        while (resultSet.next()) {
            hashSet.add(resultSet.getString(4).trim());
        }
        resultSet.close();
        return hashSet;
    }

    private JDBCExternalForeignKey[] buildForeignKeys() {
        try {
            return this.buildForeignKeys2();
        }
        catch (SQLException sQLException) {
            return EMPTY_FOREIGN_KEYS;
        }
    }

    private JDBCExternalForeignKey[] buildForeignKeys2() throws SQLException {
        ArrayList<JDBCExternalForeignKey> arrayList = new ArrayList<JDBCExternalForeignKey>();
        ResultSet resultSet = this.metaData().getImportedKeys(this.tableDescription.getCatalogName(), this.tableDescription.getSchemaName(), this.tableDescription.getName());
        while (resultSet.next()) {
            String string = resultSet.getString(12).trim();
            JDBCExternalForeignKey jDBCExternalForeignKey = this.foreignKeyNamed(string, arrayList);
            if (jDBCExternalForeignKey == null) {
                jDBCExternalForeignKey = new JDBCExternalForeignKey(this, string, resultSet);
                arrayList.add(jDBCExternalForeignKey);
            }
            jDBCExternalForeignKey.addColumnPair(resultSet);
        }
        resultSet.close();
        return arrayList.toArray(new JDBCExternalForeignKey[arrayList.size()]);
    }

    private JDBCExternalForeignKey foreignKeyNamed(String string, Collection collection) {
        for (JDBCExternalForeignKey jDBCExternalForeignKey : collection) {
            if (!jDBCExternalForeignKey.getName().equals(string)) continue;
            return jDBCExternalForeignKey;
        }
        return null;
    }

    public ExternalColumn[] getColumns() {
        return this.columns;
    }

    public ExternalForeignKey[] getForeignKeys() {
        return this.foreignKeys;
    }

    private DatabaseMetaData metaData() {
        return this.tableDescription.metaData();
    }

    JDBCExternalDatabase database() {
        return this.tableDescription.getDatabase();
    }

    JDBCExternalColumn columnNamed(String string) {
        int n = this.columns.length;
        while (n-- > 0) {
            JDBCExternalColumn jDBCExternalColumn = this.columns[n];
            if (!jDBCExternalColumn.getName().equals(string)) continue;
            return jDBCExternalColumn;
        }
        return null;
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.tableDescription.getQualifiedName());
    }
}

