/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.DefaultChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DatabasePlatformRepository
extends AbstractNodeModel {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private File file;
    public static final String FILE_PROPERTY = "file";
    private Collection platforms;
    public static final String PLATFORMS_COLLECTION = "platforms";
    private DatabasePlatform defaultPlatform;
    public static final String DEFAULT_PLATFORM_PROPERTY = "defaultPlatform";
    private JDBCTypeRepository jdbcTypeRepository;
    private ChangeNotifier changeNotifier;
    private Node.Validator validator;
    private Collection originalPlatformShortFileNames;
    private File originalFile;
    private static final String PLATFORMS_DIRECTORY_NAME = "platforms";
    private static final String DEFAULT_PLATFORM_REPOSITORY_FILE_NAME = "platforms.dpr";
    private static DatabasePlatformRepository defaultRepository;

    public static DatabasePlatformRepository getDefault() {
        if (defaultRepository == null) {
            defaultRepository = DatabasePlatformRepository.buildDefault();
        }
        return defaultRepository;
    }

    private static DatabasePlatformRepository buildDefault() {
        try {
            return new DatabasePlatformRepository(DatabasePlatformRepository.buildDefaultFile());
        }
        catch (CorruptXMLException corruptXMLException) {
            throw new RuntimeException(corruptXMLException);
        }
    }

    private static File buildDefaultFile() {
        try {
            return FileTools.resourceFile("/platforms.dpr");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    public DatabasePlatformRepository(File file) throws CorruptXMLException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.read();
    }

    public DatabasePlatformRepository(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.jdbcTypeRepository = new JDBCTypeRepository(this);
        this.originalPlatformShortFileNames = Collections.EMPTY_SET;
    }

    protected void initialize() {
        super.initialize();
        this.platforms = new Vector();
        this.changeNotifier = DefaultChangeNotifier.instance();
        this.validator = NULL_VALIDATOR;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        String string2 = this.name;
        this.name = string;
        this.firePropertyChanged(NAME_PROPERTY, string2, string);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        if (file == null) {
            throw new NullPointerException();
        }
        File file2 = this.file;
        this.file = file;
        this.firePropertyChanged(FILE_PROPERTY, file2, file);
        if (file2 != null && file2.exists()) {
            if (file2.getParentFile().equals(file.getParentFile())) {
                if (!file2.getName().equals(file.getName())) {
                    this.originalFile = file2;
                }
            } else {
                this.markEntireBranchDirty();
                this.originalPlatformShortFileNames = Collections.EMPTY_SET;
            }
        }
    }

    public Iterator platforms() {
        return new CloneIterator(this.platforms){

            protected void remove(Object object) {
                DatabasePlatformRepository.this.removePlatform((DatabasePlatform)object);
            }
        };
    }

    public int platformsSize() {
        return this.platforms.size();
    }

    public DatabasePlatform addPlatform(String string, String string2) {
        this.checkPlatform(string, string2);
        return this.addPlatform(new DatabasePlatform(this, string, string2));
    }

    private DatabasePlatform addPlatform(DatabasePlatform databasePlatform) {
        this.addItemToCollection(databasePlatform, this.platforms, "platforms");
        this.markBranchDirty();
        if (this.defaultPlatform == null) {
            this.setDefaultPlatform(databasePlatform);
        }
        return databasePlatform;
    }

    public void removePlatform(DatabasePlatform databasePlatform) {
        this.removeItemFromCollection(databasePlatform, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public void removePlatforms(Collection collection) {
        this.removeItemsFromCollection(collection, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public void removePlatforms(Iterator iterator) {
        this.removeItemsFromCollection(iterator, this.platforms, "platforms");
        this.markBranchDirty();
        this.resetDefaultPlatform();
    }

    public DatabasePlatform getDefaultPlatform() {
        return this.defaultPlatform;
    }

    public void setDefaultPlatform(DatabasePlatform databasePlatform) {
        if (databasePlatform == null && this.platforms.size() > 0) {
            throw new NullPointerException();
        }
        DatabasePlatform databasePlatform2 = this.defaultPlatform;
        this.defaultPlatform = databasePlatform;
        this.firePropertyChanged(DEFAULT_PLATFORM_PROPERTY, databasePlatform2, databasePlatform);
    }

    public JDBCTypeRepository getJDBCTypeRepository() {
        return this.jdbcTypeRepository;
    }

    public ChangeNotifier getChangeNotifier() {
        return this.changeNotifier;
    }

    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        this.changeNotifier = changeNotifier;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    private File platformsDirectory() {
        return new File(this.file.getParentFile(), "platforms");
    }

    public DatabasePlatform platformNamed(String string) {
        Collection collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform databasePlatform : this.platforms) {
                if (!databasePlatform.getName().equals(string)) continue;
                return databasePlatform;
            }
            throw new IllegalArgumentException("missing database platform named: " + string);
        }
    }

    public DatabasePlatform platformForRuntimePlatformClassNamed(String string) {
        Collection collection = this.platforms;
        synchronized (collection) {
            for (DatabasePlatform databasePlatform : this.platforms) {
                if (!databasePlatform.getRuntimePlatformClassName().equals(string)) continue;
                return databasePlatform;
            }
            throw new IllegalArgumentException("missing database platform for run-time platform class: " + string);
        }
    }

    private Iterator platformNames() {
        return new TransformationIterator(this.platforms()){

            protected Object transform(Object object) {
                return ((DatabasePlatform)object).getName();
            }
        };
    }

    private Iterator platformShortFileNames() {
        return new TransformationIterator(this.platforms()){

            protected Object transform(Object object) {
                return ((DatabasePlatform)object).getShortFileName();
            }
        };
    }

    private Iterator lowerCasePlatformShortFileNames() {
        return new TransformationIterator(this.platformShortFileNames()){

            protected Object transform(Object object) {
                return ((String)object).toLowerCase();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        Collection collection = this.platforms;
        synchronized (collection) {
            list.addAll(this.platforms);
        }
        list.add(this.jdbcTypeRepository);
    }

    protected void addTransientAspectNamesTo(Set set) {
        super.addTransientAspectNamesTo(set);
        set.add("platforms");
    }

    protected void addProblemsTo(List list) {
        if (this.platforms.isEmpty()) {
            list.add(this.buildProblem("001"));
        }
        super.addProblemsTo(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDefaultPlatform() {
        Collection collection = this.platforms;
        synchronized (collection) {
            if (!this.platforms.contains(this.defaultPlatform)) {
                if (this.platforms.isEmpty()) {
                    this.setDefaultPlatform(null);
                } else {
                    this.setDefaultPlatform((DatabasePlatform)this.platforms.iterator().next());
                }
            }
        }
    }

    public DatabasePlatform clone(DatabasePlatform databasePlatform) {
        String string = databasePlatform.getName();
        String string2 = databasePlatform.getShortFileName();
        String string3 = FileTools.stripExtension(string2);
        String string4 = FileTools.extension(string2);
        DatabasePlatform databasePlatform2 = null;
        int n = 1;
        boolean bl = false;
        while (!bl) {
            String string5 = string + ++n;
            String string6 = string3 + n + string4;
            try {
                databasePlatform2 = this.addPlatform(string5, string6);
                bl = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string7 = illegalArgumentException.getMessage();
                if (string7.indexOf(string5) != -1 || string7.indexOf(string6) != -1) continue;
                throw illegalArgumentException;
            }
        }
        databasePlatform2.cloneFrom(databasePlatform);
        return databasePlatform2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcTypeAdded(JDBCType jDBCType) {
        Collection collection = this.platforms;
        synchronized (collection) {
            Iterator iterator = this.platforms.iterator();
            while (iterator.hasNext()) {
                ((DatabasePlatform)iterator.next()).jdbcTypeAdded(jDBCType);
            }
        }
    }

    private void checkPlatform(DatabasePlatform databasePlatform) {
        this.checkPlatform(databasePlatform.getName(), databasePlatform.getShortFileName());
    }

    private void checkPlatform(String string, String string2) {
        this.checkPlatformName(string);
        this.checkPlatformShortFileName(string2);
    }

    void checkPlatformName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("platform name is required");
        }
        if (CollectionTools.contains(this.platformNames(), (Object)string)) {
            throw new IllegalArgumentException("duplicate platform name: " + string);
        }
    }

    void checkPlatformShortFileName(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("platform short file name is required");
        }
        if (FileTools.fileNameIsInvalid(string)) {
            throw new IllegalArgumentException("invalid file name: " + string);
        }
        if (CollectionTools.contains(this.lowerCasePlatformShortFileNames(), (Object)string.toLowerCase())) {
            throw new IllegalArgumentException("duplicate file name: " + string);
        }
    }

    private void read() throws CorruptXMLException {
        Document document = XMLTools.parse(this.file);
        Node node = XMLTools.child(document, "platforms");
        if (node == null) {
            throw this.buildCorruptXMLException("missing root node: platforms");
        }
        this.name = XMLTools.childTextContent(node, NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw this.buildCorruptXMLException("name is required");
        }
        ClassTools.setFieldValue(this, "comment", XMLTools.childTextContent(node, "comment", ""));
        this.jdbcTypeRepository = new JDBCTypeRepository(this, XMLTools.child(node, "jdbc-type-repository"));
        this.readPlatforms();
        String string = XMLTools.childTextContent(node, "default-platform", null);
        if (string == null || string.length() == 0) {
            if (this.platforms.size() != 0) {
                throw this.buildCorruptXMLException("default platform name is required");
            }
        } else {
            if (this.platforms.size() == 0) {
                throw this.buildCorruptXMLException("default platform should not be specified when there are no platforms");
            }
            try {
                this.defaultPlatform = this.platformNamed(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.buildCorruptXMLException(illegalArgumentException);
            }
        }
        this.originalPlatformShortFileNames = CollectionTools.collection(this.platformShortFileNames());
        this.markEntireBranchClean();
    }

    private void readPlatforms() throws CorruptXMLException {
        File file = this.platformsDirectory();
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            while (n-- > 0) {
                this.readPlatform(fileArray[n]);
            }
        }
    }

    private void readPlatform(File file) throws CorruptXMLException {
        if (file.isFile() && FileTools.extension(file).toLowerCase().equals(".xml")) {
            DatabasePlatform databasePlatform = new DatabasePlatform(this, file);
            try {
                this.checkPlatform(databasePlatform);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.buildCorruptXMLException(illegalArgumentException);
            }
            this.platforms.add(databasePlatform);
        }
    }

    private CorruptXMLException buildCorruptXMLException(String string) {
        return new CorruptXMLException(string + " (" + this.file.getPath() + ")");
    }

    private CorruptXMLException buildCorruptXMLException(Throwable throwable) {
        return new CorruptXMLException(this.file.getPath(), throwable);
    }

    public void write() {
        if (this.isCleanBranch()) {
            return;
        }
        if (this.file == null) {
            throw new IllegalStateException("the repository's file must be set before it is written");
        }
        this.writePlatforms();
        if (this.isDirtyBranch()) {
            this.writeRepositoryFile();
            this.markEntireBranchClean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePlatforms() {
        File file = this.platformsDirectory();
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IllegalStateException("platforms directory is not a directory: " + file.getAbsolutePath());
            }
        } else if (!file.mkdirs()) {
            throw new RuntimeException("unable to create platforms directory: " + file.getAbsolutePath());
        }
        this.deleteOldPlatformFiles(file);
        Collection collection = this.platforms;
        synchronized (collection) {
            Iterator iterator = this.platforms.iterator();
            while (iterator.hasNext()) {
                ((DatabasePlatform)iterator.next()).write(file);
            }
        }
    }

    private void deleteOldPlatformFiles(File file) {
        HashBag hashBag = new HashBag(this.originalPlatformShortFileNames);
        Collection collection = CollectionTools.collection(this.platformShortFileNames());
        hashBag.removeAll(collection);
        for (String string : hashBag) {
            new File(file, string).delete();
        }
        this.originalPlatformShortFileNames = collection;
    }

    private void writeRepositoryFile() {
        Document document = XMLTools.newDocument();
        Element element = document.createElement("platforms");
        document.appendChild(element);
        XMLTools.addSimpleTextNode((Node)element, NAME_PROPERTY, this.name);
        XMLTools.addSimpleTextNode((Node)element, "comment", (String)ClassTools.getFieldValue(this, "comment"), "");
        if (this.defaultPlatform != null) {
            XMLTools.addSimpleTextNode((Node)element, "default-platform", this.defaultPlatform.getName());
        }
        this.jdbcTypeRepository.write(element.appendChild(document.createElement("jdbc-type-repository")));
        XMLTools.print(document, this.file);
        if (this.originalFile != null) {
            if (!this.originalFile.delete()) {
                throw new RuntimeException("unable to delete original file: " + this.originalFile.getPath());
            }
            this.originalFile = null;
        }
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer stringBuffer) {
        Iterator iterator = this.platforms();
        while (iterator.hasNext()) {
            DatabasePlatform databasePlatform = (DatabasePlatform)iterator.next();
            databasePlatform.toString(stringBuffer);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
    }
}

