/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsmodel;

import java.util.List;
import org.eclipse.persistence.tools.workbench.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabaseType;
import org.eclipse.persistence.tools.workbench.platformsmodel.JDBCType;
import org.eclipse.persistence.tools.workbench.utility.XMLTools;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.w3c.dom.Node;

public final class JDBCTypeToDatabaseTypeMapping
extends AbstractNodeModel {
    private JDBCType jdbcType;
    private DatabaseType databaseType;
    public static final String DATABASE_TYPE_PROPERTY = "databaseType";

    JDBCTypeToDatabaseTypeMapping(DatabasePlatform databasePlatform, Node node) throws CorruptXMLException {
        super(databasePlatform);
        this.read(node);
    }

    JDBCTypeToDatabaseTypeMapping(DatabasePlatform databasePlatform, JDBCType jDBCType) {
        super(databasePlatform);
        if (jDBCType == null) {
            throw new NullPointerException();
        }
        this.jdbcType = jDBCType;
    }

    private DatabasePlatform getPlatform() {
        return (DatabasePlatform)this.getParent();
    }

    public JDBCType getJDBCType() {
        return this.jdbcType;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseType databaseType) {
        DatabaseType databaseType2 = this.databaseType;
        this.databaseType = databaseType;
        this.firePropertyChanged(DATABASE_TYPE_PROPERTY, databaseType2, databaseType);
    }

    boolean maps(JDBCType jDBCType) {
        return this.jdbcType == jDBCType;
    }

    boolean maps(int n) {
        return this.jdbcType.getCode() == n;
    }

    private JDBCType jdbcTypeNamed(String string) {
        return this.getPlatform().jdbcTypeNamed(string);
    }

    private DatabaseType databaseTypeNamed(String string) {
        return this.getPlatform().databaseTypeNamed(string);
    }

    protected void addProblemsTo(List list) {
        if (this.databaseType == null) {
            list.add(this.buildProblem("002", this.getJDBCType().getName()));
        }
        super.addProblemsTo(list);
    }

    void cloneFrom(JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping) {
        DatabaseType databaseType = jDBCTypeToDatabaseTypeMapping.getDatabaseType();
        if (databaseType != null) {
            this.databaseType = this.databaseTypeNamed(databaseType.getName());
        }
    }

    public int compareTo(Object object) {
        JDBCTypeToDatabaseTypeMapping jDBCTypeToDatabaseTypeMapping = (JDBCTypeToDatabaseTypeMapping)object;
        return this.jdbcType.compareTo(jDBCTypeToDatabaseTypeMapping.jdbcType);
    }

    private void read(Node node) throws CorruptXMLException {
        try {
            this.jdbcType = this.jdbcTypeNamed(XMLTools.childTextContent(node, "jdbc-type", null));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CorruptXMLException("platform: " + this.getPlatform().getName(), illegalArgumentException);
        }
        String string = XMLTools.childTextContent(node, "database-type", null);
        if (string != null) {
            try {
                this.databaseType = this.databaseTypeNamed(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CorruptXMLException(illegalArgumentException);
            }
        }
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode(node, "jdbc-type", this.jdbcType.getName());
        if (this.databaseType != null) {
            XMLTools.addSimpleTextNode(node, "database-type", this.databaseType.getName());
        }
    }

    private void displayStringOn(StringBuffer stringBuffer) {
        stringBuffer.append(this.jdbcType.getName());
        stringBuffer.append(" => ");
        stringBuffer.append(this.databaseType == null ? "null" : this.databaseType.getName());
    }

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayStringOn(stringBuffer);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        this.displayStringOn(stringBuffer);
    }
}

