/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.persistence.tools.workbench.utility.Classpath;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class ManifestInterrogator {
    private Defaults defaults;
    private String jarFileName;
    private Manifest manifest;
    private static final Attributes.Name RELEASE_DESIGNATION = new Attributes.Name("Release-Designation");
    private static final Attributes.Name LIBRARY_DESIGNATION = new Attributes.Name("Library-Designation");

    public ManifestInterrogator(Class clazz, Defaults defaults) {
        this.defaults = defaults;
        this.initialize(clazz);
    }

    private void initialize(Class clazz) {
        this.jarFileName = this.buildJarFileName(clazz);
        this.manifest = this.buildManifest();
    }

    protected String buildJarFileName(Class clazz) {
        File file;
        URL uRL = Classpath.convertToResource(clazz);
        if (uRL.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        try {
            file = FileTools.buildFile(uRL);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        return file.getAbsolutePath().substring(0, file.getAbsolutePath().indexOf(33));
    }

    private Manifest buildManifest() {
        JarFile jarFile = this.buildJarFile();
        if (jarFile == null) {
            return new Manifest();
        }
        try {
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                return new Manifest();
            }
            return manifest;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private JarFile buildJarFile() {
        if (this.jarFileName == null) {
            return null;
        }
        try {
            return new JarFile(this.jarFileName);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public String getMainAttributeValue(Attributes.Name name) {
        return this.getMainAttributeValue(name, null);
    }

    public String getMainAttributeValue(Attributes.Name name, String string) {
        String string2 = this.manifest.getMainAttributes().getValue(name);
        if (StringTools.stringIsEmpty(string2)) {
            return string;
        }
        return string2;
    }

    public boolean isDevelopmentMode() {
        return this.jarFileName == null;
    }

    public String getFullProductName() {
        return this.getSpecificationVendor() + " " + this.getProductName();
    }

    public String getProductName() {
        return this.getMainAttributeValue(Attributes.Name.SPECIFICATION_TITLE, this.defaults.defaultSpecificationTitle());
    }

    public String getSpecificationVendor() {
        return this.getMainAttributeValue(Attributes.Name.SPECIFICATION_VENDOR, this.defaults.defaultSpecificationVendor());
    }

    public String getShortProductName() {
        return this.getMainAttributeValue(LIBRARY_DESIGNATION, this.defaults.defaultLibraryDesignation());
    }

    public String getVersionNumber() {
        return this.getMainAttributeValue(Attributes.Name.SPECIFICATION_VERSION, this.defaults.defaultSpecificationVersion());
    }

    public String getBuildNumber() {
        if (this.isDevelopmentMode()) {
            return "<dev>";
        }
        String string = this.getVersionNumber();
        String string2 = this.getMainAttributeValue(Attributes.Name.IMPLEMENTATION_VERSION, this.defaults.defaultImplementationVersion());
        return string2.substring(string.length() + 1);
    }

    public String getReleaseDesignation() {
        return this.getMainAttributeValue(RELEASE_DESIGNATION, this.defaults.defaultReleaseDesignation());
    }

    public static interface Defaults {
        public String defaultSpecificationTitle();

        public String defaultSpecificationVendor();

        public String defaultReleaseDesignation();

        public String defaultLibraryDesignation();

        public String defaultSpecificationVersion();

        public String defaultImplementationVersion();
    }
}

