/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.Serializable;
import org.eclipse.persistence.tools.workbench.utility.Command;

public class SynchronizedObject
implements Cloneable,
Serializable {
    private Object value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedObject(Object object, Object object2) {
        this.value = object;
        this.mutex = object2;
    }

    public SynchronizedObject(Object object) {
        this.value = object;
        this.mutex = this;
    }

    public SynchronizedObject() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object object) {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (this.value != object) {
                this.value = object;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNull() {
        Object object = this.mutex;
        synchronized (object) {
            this.setValue(null);
        }
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(Object object) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            while (this.value != object) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIsNot(Object object) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            while (this.value == object) {
                this.mutex.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilNotNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetValue(Object object) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            this.waitUntilValueIsNot(object);
            this.setValue(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitToSetNull() throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilNotNull();
            this.setValue(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(Object object, long l) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (l == 0L) {
                this.waitUntilValueIs(object);
                return true;
            }
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (this.value != object && l3 > 0L) {
                this.mutex.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
            return this.value == object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIsNot(Object object, long l) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            if (l == 0L) {
                this.waitUntilValueIsNot(object);
                return true;
            }
            long l2 = System.currentTimeMillis() + l;
            long l3 = l;
            while (this.value == object && l3 > 0L) {
                this.mutex.wait(l3);
                l3 = l2 - System.currentTimeMillis();
            }
            return this.value != object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNull(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs(null, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilNotNull(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIsNot(null, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(Object object, long l) throws InterruptedException {
        Object object2 = this.mutex;
        synchronized (object2) {
            boolean bl = this.waitUntilValueIsNot(object, l);
            if (bl) {
                this.setValue(object);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetNull(long l) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = this.waitUntilNotNull(l);
            if (bl) {
                this.setValue(null);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                return super.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof SynchronizedObject)) {
            return false;
        }
        Object object2 = this.getValue();
        Object object3 = ((SynchronizedObject)object).getValue();
        return object2 == null ? object3 == null : object2.equals(object3);
    }

    public int hashCode() {
        Object object = this.getValue();
        return object == null ? 0 : object.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getValue());
    }
}

