/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.StringWriter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class LineNumber {
    private short startPC;
    private short lineNumber;

    LineNumber(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.initialize(classFileDataInputStream);
    }

    void initialize(ClassFileDataInputStream classFileDataInputStream) throws IOException {
        this.startPC = classFileDataInputStream.readU2();
        this.lineNumber = classFileDataInputStream.readU2();
    }

    public String displayString() {
        StringWriter stringWriter = new StringWriter(1000);
        IndentingPrintWriter indentingPrintWriter = new IndentingPrintWriter(stringWriter);
        this.displayStringOn(indentingPrintWriter);
        return stringWriter.toString();
    }

    public void displayStringOn(IndentingPrintWriter indentingPrintWriter) {
        indentingPrintWriter.print("line number: ");
        indentingPrintWriter.print(this.lineNumber);
        indentingPrintWriter.print(" PC start: ");
        indentingPrintWriter.println(this.startPC);
    }

    public short getStartPC() {
        return this.startPC;
    }

    public short getLineNumber() {
        return this.lineNumber;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return ClassTools.shortClassNameForObject(this) + '(' + this.lineNumber + ':' + this.startPC + ')';
    }
}

